/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v251.segment;

// import ca.uhn.hl7v2.model.v251.group.*;
import ca.uhn.hl7v2.model.v251.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 TCD message segment (Test Code Detail). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>TCD-1: Universal Service Identifier (CE) <b> </b>
     * <li>TCD-2: Auto-Dilution Factor (SN) <b>optional </b>
     * <li>TCD-3: Rerun Dilution Factor (SN) <b>optional </b>
     * <li>TCD-4: Pre-Dilution Factor (SN) <b>optional </b>
     * <li>TCD-5: Endogenous Content of Pre-Dilution Diluent (SN) <b>optional </b>
     * <li>TCD-6: Automatic Repeat Allowed (ID) <b>optional </b>
     * <li>TCD-7: Reflex Allowed (ID) <b>optional </b>
     * <li>TCD-8: Analyte Repeat Status (CE) <b>optional </b>
 * </ul>
 */
public class TCD extends AbstractSegment {

    /** 
     * Creates a new TCD segment
     */
    public TCD(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(CE.class, true, 1, 250, new Object[]{ getMessage(), new Integer(0) }, "Universal Service Identifier");
                                  this.add(SN.class, false, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "Auto-Dilution Factor");
                                  this.add(SN.class, false, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "Rerun Dilution Factor");
                                  this.add(SN.class, false, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "Pre-Dilution Factor");
                                  this.add(SN.class, false, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "Endogenous Content of Pre-Dilution Diluent");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "Automatic Repeat Allowed");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "Reflex Allowed");
                                  this.add(CE.class, false, 1, 250, new Object[]{ getMessage(), new Integer(389) }, "Analyte Repeat Status");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating TCD - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * TCD-1: "Universal Service Identifier" - creates it if necessary
     */
    public CE getUniversalServiceIdentifier() { 
        CE ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * TCD-1: "Universal Service Identifier" - creates it if necessary
     */
    public CE getTcd1_UniversalServiceIdentifier() { 
        CE ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * TCD-2: "Auto-Dilution Factor" - creates it if necessary
     */
    public SN getAutoDilutionFactor() { 
        SN ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (SN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * TCD-2: "Auto-Dilution Factor" - creates it if necessary
     */
    public SN getTcd2_AutoDilutionFactor() { 
        SN ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (SN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * TCD-3: "Rerun Dilution Factor" - creates it if necessary
     */
    public SN getRerunDilutionFactor() { 
        SN ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (SN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * TCD-3: "Rerun Dilution Factor" - creates it if necessary
     */
    public SN getTcd3_RerunDilutionFactor() { 
        SN ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (SN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * TCD-4: "Pre-Dilution Factor" - creates it if necessary
     */
    public SN getPreDilutionFactor() { 
        SN ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (SN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * TCD-4: "Pre-Dilution Factor" - creates it if necessary
     */
    public SN getTcd4_PreDilutionFactor() { 
        SN ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (SN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * TCD-5: "Endogenous Content of Pre-Dilution Diluent" - creates it if necessary
     */
    public SN getEndogenousContentOfPreDilutionDiluent() { 
        SN ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (SN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * TCD-5: "Endogenous Content of Pre-Dilution Diluent" - creates it if necessary
     */
    public SN getTcd5_EndogenousContentOfPreDilutionDiluent() { 
        SN ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (SN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * TCD-6: "Automatic Repeat Allowed" - creates it if necessary
     */
    public ID getAutomaticRepeatAllowed() { 
        ID ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * TCD-6: "Automatic Repeat Allowed" - creates it if necessary
     */
    public ID getTcd6_AutomaticRepeatAllowed() { 
        ID ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * TCD-7: "Reflex Allowed" - creates it if necessary
     */
    public ID getReflexAllowed() { 
        ID ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * TCD-7: "Reflex Allowed" - creates it if necessary
     */
    public ID getTcd7_ReflexAllowed() { 
        ID ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * TCD-8: "Analyte Repeat Status" - creates it if necessary
     */
    public CE getAnalyteRepeatStatus() { 
        CE ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * TCD-8: "Analyte Repeat Status" - creates it if necessary
     */
    public CE getTcd8_AnalyteRepeatStatus() { 
        CE ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new CE(getMessage());
          case 1: return new SN(getMessage());
          case 2: return new SN(getMessage());
          case 3: return new SN(getMessage());
          case 4: return new SN(getMessage());
          case 5: return new ID(getMessage(), new Integer( 136 ));
          case 6: return new ID(getMessage(), new Integer( 136 ));
          case 7: return new CE(getMessage());
          default: return null;
       }
   }


}

