/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.datatype;

import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v251.datatype.IS;
import ca.uhn.hl7v2.model.v251.datatype.TS;
import org.slf4j.LoggerFactory;

public class DLD
extends AbstractType
implements Composite {
    private Type[] data;

    public DLD(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[2];
        this.data[0] = new IS(this.getMessage(), 113);
        this.data[1] = new TS(this.getMessage());
    }

    public Type[] getComponents() {
        return this.data;
    }

    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + ((Object)((Object)this)).getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public IS getDischargeLocation() {
        IS ret = null;
        try {
            ret = (IS)this.getComponent(0);
        }
        catch (DataTypeException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public IS getDld1_DischargeLocation() {
        IS ret = null;
        try {
            ret = (IS)this.getComponent(0);
        }
        catch (DataTypeException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public TS getEffectiveDate() {
        TS ret = null;
        try {
            ret = (TS)this.getComponent(1);
        }
        catch (DataTypeException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public TS getDld2_EffectiveDate() {
        TS ret = null;
        try {
            ret = (TS)this.getComponent(1);
        }
        catch (DataTypeException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }
}

