/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.datatype;

import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v251.datatype.HD;
import ca.uhn.hl7v2.model.v251.datatype.ID;
import ca.uhn.hl7v2.model.v251.datatype.ST;
import org.slf4j.LoggerFactory;

public class RP
extends AbstractType
implements Composite {
    private Type[] data;

    public RP(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[4];
        this.data[0] = new ST(this.getMessage());
        this.data[1] = new HD(this.getMessage());
        this.data[2] = new ID(this.getMessage(), 191);
        this.data[3] = new ID(this.getMessage(), 291);
    }

    public Type[] getComponents() {
        return this.data;
    }

    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + ((Object)((Object)this)).getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public ST getPointer() {
        ST ret = null;
        try {
            ret = (ST)this.getComponent(0);
        }
        catch (DataTypeException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ST getRp1_Pointer() {
        ST ret = null;
        try {
            ret = (ST)this.getComponent(0);
        }
        catch (DataTypeException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public HD getApplicationID() {
        HD ret = null;
        try {
            ret = (HD)this.getComponent(1);
        }
        catch (DataTypeException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public HD getRp2_ApplicationID() {
        HD ret = null;
        try {
            ret = (HD)this.getComponent(1);
        }
        catch (DataTypeException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ID getTypeOfData() {
        ID ret = null;
        try {
            ret = (ID)this.getComponent(2);
        }
        catch (DataTypeException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ID getRp3_TypeOfData() {
        ID ret = null;
        try {
            ret = (ID)this.getComponent(2);
        }
        catch (DataTypeException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ID getSubtype() {
        ID ret = null;
        try {
            ret = (ID)this.getComponent(3);
        }
        catch (DataTypeException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ID getRp4_Subtype() {
        ID ret = null;
        try {
            ret = (ID)this.getComponent(3);
        }
        catch (DataTypeException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }
}

