/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v251.group.BPS_O29_PRODUCT;
import ca.uhn.hl7v2.model.v251.group.BPS_O29_TIMING;
import ca.uhn.hl7v2.model.v251.segment.BPO;
import ca.uhn.hl7v2.model.v251.segment.NTE;
import ca.uhn.hl7v2.model.v251.segment.ORC;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BPS_O29_ORDER
extends AbstractGroup {
    public BPS_O29_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, true, false);
            this.add(BPS_O29_TIMING.class, false, true);
            this.add(BPO.class, true, false);
            this.add(NTE.class, false, true);
            this.add(BPS_O29_PRODUCT.class, false, true);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error creating BPS_O29_ORDER - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5.1";
    }

    public ORC getORC() {
        ORC ret = null;
        try {
            ret = (ORC)this.get("ORC");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public BPS_O29_TIMING getTIMING() {
        BPS_O29_TIMING ret = null;
        try {
            ret = (BPS_O29_TIMING)this.get("TIMING");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public BPS_O29_TIMING getTIMING(int rep) {
        BPS_O29_TIMING ret = null;
        try {
            ret = (BPS_O29_TIMING)this.get("TIMING", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getTIMINGReps() {
        int reps = -1;
        try {
            reps = this.getAll("TIMING").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<BPS_O29_TIMING> getTIMINGAll() throws HL7Exception {
        return this.getAllAsList("TIMING", BPS_O29_TIMING.class);
    }

    public void insertTIMING(BPS_O29_TIMING structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING", (Structure)structure, rep);
    }

    public BPS_O29_TIMING insertTIMING(int rep) throws HL7Exception {
        return (BPS_O29_TIMING)super.insertRepetition("TIMING", rep);
    }

    public BPS_O29_TIMING removeTIMING(int rep) throws HL7Exception {
        return (BPS_O29_TIMING)super.removeRepetition("TIMING", rep);
    }

    public BPO getBPO() {
        BPO ret = null;
        try {
            ret = (BPO)this.get("BPO");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE() {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE(int rep) {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getNTEReps() {
        int reps = -1;
        try {
            reps = this.getAll("NTE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public BPS_O29_PRODUCT getPRODUCT() {
        BPS_O29_PRODUCT ret = null;
        try {
            ret = (BPS_O29_PRODUCT)this.get("PRODUCT");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public BPS_O29_PRODUCT getPRODUCT(int rep) {
        BPS_O29_PRODUCT ret = null;
        try {
            ret = (BPS_O29_PRODUCT)this.get("PRODUCT", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getPRODUCTReps() {
        int reps = -1;
        try {
            reps = this.getAll("PRODUCT").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<BPS_O29_PRODUCT> getPRODUCTAll() throws HL7Exception {
        return this.getAllAsList("PRODUCT", BPS_O29_PRODUCT.class);
    }

    public void insertPRODUCT(BPS_O29_PRODUCT structure, int rep) throws HL7Exception {
        super.insertRepetition("PRODUCT", (Structure)structure, rep);
    }

    public BPS_O29_PRODUCT insertPRODUCT(int rep) throws HL7Exception {
        return (BPS_O29_PRODUCT)super.insertRepetition("PRODUCT", rep);
    }

    public BPS_O29_PRODUCT removePRODUCT(int rep) throws HL7Exception {
        return (BPS_O29_PRODUCT)super.removeRepetition("PRODUCT", rep);
    }
}

