/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v251.group.RGR_RGR_ORDER;
import ca.uhn.hl7v2.model.v251.group.RGR_RGR_PATIENT;
import ca.uhn.hl7v2.model.v251.segment.QRD;
import ca.uhn.hl7v2.model.v251.segment.QRF;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RGR_RGR_DEFINITION
extends AbstractGroup {
    public RGR_RGR_DEFINITION(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(QRD.class, true, false);
            this.add(QRF.class, false, false);
            this.add(RGR_RGR_PATIENT.class, false, false);
            this.add(RGR_RGR_ORDER.class, true, true);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error creating RGR_RGR_DEFINITION - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5.1";
    }

    public QRD getQRD() {
        QRD ret = null;
        try {
            ret = (QRD)this.get("QRD");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public QRF getQRF() {
        QRF ret = null;
        try {
            ret = (QRF)this.get("QRF");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RGR_RGR_PATIENT getPATIENT() {
        RGR_RGR_PATIENT ret = null;
        try {
            ret = (RGR_RGR_PATIENT)this.get("PATIENT");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RGR_RGR_ORDER getORDER() {
        RGR_RGR_ORDER ret = null;
        try {
            ret = (RGR_RGR_ORDER)this.get("ORDER");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RGR_RGR_ORDER getORDER(int rep) {
        RGR_RGR_ORDER ret = null;
        try {
            ret = (RGR_RGR_ORDER)this.get("ORDER", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getORDERReps() {
        int reps = -1;
        try {
            reps = this.getAll("ORDER").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<RGR_RGR_ORDER> getORDERAll() throws HL7Exception {
        return this.getAllAsList("ORDER", RGR_RGR_ORDER.class);
    }

    public void insertORDER(RGR_RGR_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition("ORDER", (Structure)structure, rep);
    }

    public RGR_RGR_ORDER insertORDER(int rep) throws HL7Exception {
        return (RGR_RGR_ORDER)super.insertRepetition("ORDER", rep);
    }

    public RGR_RGR_ORDER removeORDER(int rep) throws HL7Exception {
        return (RGR_RGR_ORDER)super.removeRepetition("ORDER", rep);
    }
}

