/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v251.group.RGV_O15_ENCODING;
import ca.uhn.hl7v2.model.v251.group.RGV_O15_GIVE;
import ca.uhn.hl7v2.model.v251.group.RGV_O15_ORDER_DETAIL;
import ca.uhn.hl7v2.model.v251.group.RGV_O15_TIMING;
import ca.uhn.hl7v2.model.v251.segment.ORC;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RGV_O15_ORDER
extends AbstractGroup {
    public RGV_O15_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, true, false);
            this.add(RGV_O15_TIMING.class, false, true);
            this.add(RGV_O15_ORDER_DETAIL.class, false, false);
            this.add(RGV_O15_ENCODING.class, false, false);
            this.add(RGV_O15_GIVE.class, true, true);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error creating RGV_O15_ORDER - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5.1";
    }

    public ORC getORC() {
        ORC ret = null;
        try {
            ret = (ORC)this.get("ORC");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RGV_O15_TIMING getTIMING() {
        RGV_O15_TIMING ret = null;
        try {
            ret = (RGV_O15_TIMING)this.get("TIMING");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RGV_O15_TIMING getTIMING(int rep) {
        RGV_O15_TIMING ret = null;
        try {
            ret = (RGV_O15_TIMING)this.get("TIMING", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getTIMINGReps() {
        int reps = -1;
        try {
            reps = this.getAll("TIMING").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<RGV_O15_TIMING> getTIMINGAll() throws HL7Exception {
        return this.getAllAsList("TIMING", RGV_O15_TIMING.class);
    }

    public void insertTIMING(RGV_O15_TIMING structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING", (Structure)structure, rep);
    }

    public RGV_O15_TIMING insertTIMING(int rep) throws HL7Exception {
        return (RGV_O15_TIMING)super.insertRepetition("TIMING", rep);
    }

    public RGV_O15_TIMING removeTIMING(int rep) throws HL7Exception {
        return (RGV_O15_TIMING)super.removeRepetition("TIMING", rep);
    }

    public RGV_O15_ORDER_DETAIL getORDER_DETAIL() {
        RGV_O15_ORDER_DETAIL ret = null;
        try {
            ret = (RGV_O15_ORDER_DETAIL)this.get("ORDER_DETAIL");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RGV_O15_ENCODING getENCODING() {
        RGV_O15_ENCODING ret = null;
        try {
            ret = (RGV_O15_ENCODING)this.get("ENCODING");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RGV_O15_GIVE getGIVE() {
        RGV_O15_GIVE ret = null;
        try {
            ret = (RGV_O15_GIVE)this.get("GIVE");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RGV_O15_GIVE getGIVE(int rep) {
        RGV_O15_GIVE ret = null;
        try {
            ret = (RGV_O15_GIVE)this.get("GIVE", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getGIVEReps() {
        int reps = -1;
        try {
            reps = this.getAll("GIVE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<RGV_O15_GIVE> getGIVEAll() throws HL7Exception {
        return this.getAllAsList("GIVE", RGV_O15_GIVE.class);
    }

    public void insertGIVE(RGV_O15_GIVE structure, int rep) throws HL7Exception {
        super.insertRepetition("GIVE", (Structure)structure, rep);
    }

    public RGV_O15_GIVE insertGIVE(int rep) throws HL7Exception {
        return (RGV_O15_GIVE)super.insertRepetition("GIVE", rep);
    }

    public RGV_O15_GIVE removeGIVE(int rep) throws HL7Exception {
        return (RGV_O15_GIVE)super.removeRepetition("GIVE", rep);
    }
}

