/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v251.group.RRD_O14_ORDER;
import ca.uhn.hl7v2.model.v251.group.RRD_O14_PATIENT;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RRD_O14_RESPONSE
extends AbstractGroup {
    public RRD_O14_RESPONSE(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(RRD_O14_PATIENT.class, false, false);
            this.add(RRD_O14_ORDER.class, true, true);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error creating RRD_O14_RESPONSE - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5.1";
    }

    public RRD_O14_PATIENT getPATIENT() {
        RRD_O14_PATIENT ret = null;
        try {
            ret = (RRD_O14_PATIENT)this.get("PATIENT");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RRD_O14_ORDER getORDER() {
        RRD_O14_ORDER ret = null;
        try {
            ret = (RRD_O14_ORDER)this.get("ORDER");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RRD_O14_ORDER getORDER(int rep) {
        RRD_O14_ORDER ret = null;
        try {
            ret = (RRD_O14_ORDER)this.get("ORDER", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getORDERReps() {
        int reps = -1;
        try {
            reps = this.getAll("ORDER").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<RRD_O14_ORDER> getORDERAll() throws HL7Exception {
        return this.getAllAsList("ORDER", RRD_O14_ORDER.class);
    }

    public void insertORDER(RRD_O14_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition("ORDER", (Structure)structure, rep);
    }

    public RRD_O14_ORDER insertORDER(int rep) throws HL7Exception {
        return (RRD_O14_ORDER)super.insertRepetition("ORDER", rep);
    }

    public RRD_O14_ORDER removeORDER(int rep) throws HL7Exception {
        return (RRD_O14_ORDER)super.removeRepetition("ORDER", rep);
    }
}

