/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v251.segment.RDF;
import ca.uhn.hl7v2.model.v251.segment.RDT;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RTB_Z74_ROW_DEFINITION
extends AbstractGroup {
    public RTB_Z74_ROW_DEFINITION(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(RDF.class, true, false);
            this.add(RDT.class, false, true);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error creating RTB_Z74_ROW_DEFINITION - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5.1";
    }

    public RDF getRDF() {
        RDF ret = null;
        try {
            ret = (RDF)this.get("RDF");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RDT getRDT() {
        RDT ret = null;
        try {
            ret = (RDT)this.get("RDT");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RDT getRDT(int rep) {
        RDT ret = null;
        try {
            ret = (RDT)this.get("RDT", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getRDTReps() {
        int reps = -1;
        try {
            reps = this.getAll("RDT").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<RDT> getRDTAll() throws HL7Exception {
        return this.getAllAsList("RDT", RDT.class);
    }

    public void insertRDT(RDT structure, int rep) throws HL7Exception {
        super.insertRepetition("RDT", (Structure)structure, rep);
    }

    public RDT insertRDT(int rep) throws HL7Exception {
        return (RDT)super.insertRepetition("RDT", rep);
    }

    public RDT removeRDT(int rep) throws HL7Exception {
        return (RDT)super.removeRepetition("RDT", rep);
    }
}

