/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v251.group.NMQ_N01_CLOCK_AND_STATISTICS;
import ca.uhn.hl7v2.model.v251.group.NMQ_N01_QRY_WITH_DETAIL;
import ca.uhn.hl7v2.model.v251.segment.MSH;
import ca.uhn.hl7v2.model.v251.segment.SFT;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NMQ_N01
extends AbstractMessage {
    public NMQ_N01() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public NMQ_N01(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(NMQ_N01_QRY_WITH_DETAIL.class, false, false);
            this.add(NMQ_N01_CLOCK_AND_STATISTICS.class, true, true);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error creating NMQ_N01 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5.1";
    }

    public MSH getMSH() {
        MSH ret = null;
        try {
            ret = (MSH)this.get("MSH");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public SFT getSFT() {
        SFT ret = null;
        try {
            ret = (SFT)this.get("SFT");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public SFT getSFT(int rep) {
        SFT ret = null;
        try {
            ret = (SFT)this.get("SFT", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getSFTReps() {
        int reps = -1;
        try {
            reps = this.getAll("SFT").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", (Structure)structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public NMQ_N01_QRY_WITH_DETAIL getQRY_WITH_DETAIL() {
        NMQ_N01_QRY_WITH_DETAIL ret = null;
        try {
            ret = (NMQ_N01_QRY_WITH_DETAIL)this.get("QRY_WITH_DETAIL");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NMQ_N01_CLOCK_AND_STATISTICS getCLOCK_AND_STATISTICS() {
        NMQ_N01_CLOCK_AND_STATISTICS ret = null;
        try {
            ret = (NMQ_N01_CLOCK_AND_STATISTICS)this.get("CLOCK_AND_STATISTICS");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NMQ_N01_CLOCK_AND_STATISTICS getCLOCK_AND_STATISTICS(int rep) {
        NMQ_N01_CLOCK_AND_STATISTICS ret = null;
        try {
            ret = (NMQ_N01_CLOCK_AND_STATISTICS)this.get("CLOCK_AND_STATISTICS", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getCLOCK_AND_STATISTICSReps() {
        int reps = -1;
        try {
            reps = this.getAll("CLOCK_AND_STATISTICS").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<NMQ_N01_CLOCK_AND_STATISTICS> getCLOCK_AND_STATISTICSAll() throws HL7Exception {
        return this.getAllAsList("CLOCK_AND_STATISTICS", NMQ_N01_CLOCK_AND_STATISTICS.class);
    }

    public void insertCLOCK_AND_STATISTICS(NMQ_N01_CLOCK_AND_STATISTICS structure, int rep) throws HL7Exception {
        super.insertRepetition("CLOCK_AND_STATISTICS", (Structure)structure, rep);
    }

    public NMQ_N01_CLOCK_AND_STATISTICS insertCLOCK_AND_STATISTICS(int rep) throws HL7Exception {
        return (NMQ_N01_CLOCK_AND_STATISTICS)super.insertRepetition("CLOCK_AND_STATISTICS", rep);
    }

    public NMQ_N01_CLOCK_AND_STATISTICS removeCLOCK_AND_STATISTICS(int rep) throws HL7Exception {
        return (NMQ_N01_CLOCK_AND_STATISTICS)super.removeRepetition("CLOCK_AND_STATISTICS", rep);
    }
}

