/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v251.group.SRR_S01_SCHEDULE;
import ca.uhn.hl7v2.model.v251.segment.ERR;
import ca.uhn.hl7v2.model.v251.segment.MSA;
import ca.uhn.hl7v2.model.v251.segment.MSH;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SRR_S01
extends AbstractMessage {
    public SRR_S01() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public SRR_S01(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(MSA.class, true, false);
            this.add(ERR.class, false, true);
            this.add(SRR_S01_SCHEDULE.class, false, false);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error creating SRR_S01 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5.1";
    }

    public MSH getMSH() {
        MSH ret = null;
        try {
            ret = (MSH)this.get("MSH");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public MSA getMSA() {
        MSA ret = null;
        try {
            ret = (MSA)this.get("MSA");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ERR getERR() {
        ERR ret = null;
        try {
            ret = (ERR)this.get("ERR");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ERR getERR(int rep) {
        ERR ret = null;
        try {
            ret = (ERR)this.get("ERR", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getERRReps() {
        int reps = -1;
        try {
            reps = this.getAll("ERR").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<ERR> getERRAll() throws HL7Exception {
        return this.getAllAsList("ERR", ERR.class);
    }

    public void insertERR(ERR structure, int rep) throws HL7Exception {
        super.insertRepetition("ERR", (Structure)structure, rep);
    }

    public ERR insertERR(int rep) throws HL7Exception {
        return (ERR)super.insertRepetition("ERR", rep);
    }

    public ERR removeERR(int rep) throws HL7Exception {
        return (ERR)super.removeRepetition("ERR", rep);
    }

    public SRR_S01_SCHEDULE getSCHEDULE() {
        SRR_S01_SCHEDULE ret = null;
        try {
            ret = (SRR_S01_SCHEDULE)this.get("SCHEDULE");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }
}

