/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v251.group.SUR_P09_FACILITY;
import ca.uhn.hl7v2.model.v251.segment.MSH;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SUR_P09
extends AbstractMessage {
    public SUR_P09() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public SUR_P09(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SUR_P09_FACILITY.class, true, true);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error creating SUR_P09 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5.1";
    }

    public MSH getMSH() {
        MSH ret = null;
        try {
            ret = (MSH)this.get("MSH");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public SUR_P09_FACILITY getFACILITY() {
        SUR_P09_FACILITY ret = null;
        try {
            ret = (SUR_P09_FACILITY)this.get("FACILITY");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public SUR_P09_FACILITY getFACILITY(int rep) {
        SUR_P09_FACILITY ret = null;
        try {
            ret = (SUR_P09_FACILITY)this.get("FACILITY", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getFACILITYReps() {
        int reps = -1;
        try {
            reps = this.getAll("FACILITY").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<SUR_P09_FACILITY> getFACILITYAll() throws HL7Exception {
        return this.getAllAsList("FACILITY", SUR_P09_FACILITY.class);
    }

    public void insertFACILITY(SUR_P09_FACILITY structure, int rep) throws HL7Exception {
        super.insertRepetition("FACILITY", (Structure)structure, rep);
    }

    public SUR_P09_FACILITY insertFACILITY(int rep) throws HL7Exception {
        return (SUR_P09_FACILITY)super.insertRepetition("FACILITY", rep);
    }

    public SUR_P09_FACILITY removeFACILITY(int rep) throws HL7Exception {
        return (SUR_P09_FACILITY)super.removeRepetition("FACILITY", rep);
    }
}

