/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v251.datatype.CE;
import ca.uhn.hl7v2.model.v251.datatype.CP;
import ca.uhn.hl7v2.model.v251.datatype.EI;
import ca.uhn.hl7v2.model.v251.datatype.NM;
import ca.uhn.hl7v2.model.v251.datatype.ST;
import ca.uhn.hl7v2.model.v251.datatype.TS;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class AUT
extends AbstractSegment {
    public AUT(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Authorizing Payor, Plan ID");
            this.add(CE.class, true, 1, 250, new Object[]{this.getMessage()}, "Authorizing Payor, Company ID");
            this.add(ST.class, false, 1, 45, new Object[]{this.getMessage()}, "Authorizing Payor, Company Name");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Authorization Effective Date");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Authorization Expiration Date");
            this.add(EI.class, false, 1, 30, new Object[]{this.getMessage()}, "Authorization Identifier");
            this.add(CP.class, false, 1, 25, new Object[]{this.getMessage()}, "Reimbursement Limit");
            this.add(NM.class, false, 1, 2, new Object[]{this.getMessage()}, "Requested Number of Treatments");
            this.add(NM.class, false, 1, 2, new Object[]{this.getMessage()}, "Authorized Number of Treatments");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Process Date");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating AUT - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public CE getAuthorizingPayorPlanID() {
        CE retVal = (CE)this.getTypedField(1, 0);
        return retVal;
    }

    public CE getAut1_AuthorizingPayorPlanID() {
        CE retVal = (CE)this.getTypedField(1, 0);
        return retVal;
    }

    public CE getAuthorizingPayorCompanyID() {
        CE retVal = (CE)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getAut2_AuthorizingPayorCompanyID() {
        CE retVal = (CE)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getAuthorizingPayorCompanyName() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public ST getAut3_AuthorizingPayorCompanyName() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public TS getAuthorizationEffectiveDate() {
        TS retVal = (TS)this.getTypedField(4, 0);
        return retVal;
    }

    public TS getAut4_AuthorizationEffectiveDate() {
        TS retVal = (TS)this.getTypedField(4, 0);
        return retVal;
    }

    public TS getAuthorizationExpirationDate() {
        TS retVal = (TS)this.getTypedField(5, 0);
        return retVal;
    }

    public TS getAut5_AuthorizationExpirationDate() {
        TS retVal = (TS)this.getTypedField(5, 0);
        return retVal;
    }

    public EI getAuthorizationIdentifier() {
        EI retVal = (EI)this.getTypedField(6, 0);
        return retVal;
    }

    public EI getAut6_AuthorizationIdentifier() {
        EI retVal = (EI)this.getTypedField(6, 0);
        return retVal;
    }

    public CP getReimbursementLimit() {
        CP retVal = (CP)this.getTypedField(7, 0);
        return retVal;
    }

    public CP getAut7_ReimbursementLimit() {
        CP retVal = (CP)this.getTypedField(7, 0);
        return retVal;
    }

    public NM getRequestedNumberOfTreatments() {
        NM retVal = (NM)this.getTypedField(8, 0);
        return retVal;
    }

    public NM getAut8_RequestedNumberOfTreatments() {
        NM retVal = (NM)this.getTypedField(8, 0);
        return retVal;
    }

    public NM getAuthorizedNumberOfTreatments() {
        NM retVal = (NM)this.getTypedField(9, 0);
        return retVal;
    }

    public NM getAut9_AuthorizedNumberOfTreatments() {
        NM retVal = (NM)this.getTypedField(9, 0);
        return retVal;
    }

    public TS getProcessDate() {
        TS retVal = (TS)this.getTypedField(10, 0);
        return retVal;
    }

    public TS getAut10_ProcessDate() {
        TS retVal = (TS)this.getTypedField(10, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CE(this.getMessage());
            }
            case 1: {
                return new CE(this.getMessage());
            }
            case 2: {
                return new ST(this.getMessage());
            }
            case 3: {
                return new TS(this.getMessage());
            }
            case 4: {
                return new TS(this.getMessage());
            }
            case 5: {
                return new EI(this.getMessage());
            }
            case 6: {
                return new CP(this.getMessage());
            }
            case 7: {
                return new NM(this.getMessage());
            }
            case 8: {
                return new NM(this.getMessage());
            }
            case 9: {
                return new TS(this.getMessage());
            }
        }
        return null;
    }
}

