/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.datatype;

import ca.uhn.hl7v2.model.AbstractComposite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v251.datatype.CE;
import ca.uhn.hl7v2.model.v251.datatype.TS;

public class DIN
extends AbstractComposite {
    private Type[] data;

    public DIN(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[2];
        this.data[0] = new TS(this.getMessage());
        this.data[1] = new CE(this.getMessage());
    }

    public Type[] getComponents() {
        return this.data;
    }

    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + ((Object)((Object)this)).getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public TS getDate() {
        return (TS)this.getTyped(0, TS.class);
    }

    public TS getDin1_Date() {
        return (TS)this.getTyped(0, TS.class);
    }

    public CE getInstitutionName() {
        return (CE)this.getTyped(1, CE.class);
    }

    public CE getDin2_InstitutionName() {
        return (CE)this.getTyped(1, CE.class);
    }
}

