/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v251.group.PGL_PC6_GOAL;
import ca.uhn.hl7v2.model.v251.group.PGL_PC6_PATIENT_VISIT;
import ca.uhn.hl7v2.model.v251.segment.MSH;
import ca.uhn.hl7v2.model.v251.segment.PID;
import ca.uhn.hl7v2.model.v251.segment.SFT;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PGL_PC6
extends AbstractMessage {
    public PGL_PC6() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public PGL_PC6(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(PID.class, true, false);
            this.add(PGL_PC6_PATIENT_VISIT.class, false, false);
            this.add(PGL_PC6_GOAL.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating PGL_PC6 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5.1";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return (SFT)this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return (SFT)this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", (Structure)structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public PID getPID() {
        return (PID)this.getTyped("PID", PID.class);
    }

    public PGL_PC6_PATIENT_VISIT getPATIENT_VISIT() {
        return (PGL_PC6_PATIENT_VISIT)this.getTyped("PATIENT_VISIT", PGL_PC6_PATIENT_VISIT.class);
    }

    public PGL_PC6_GOAL getGOAL() {
        return (PGL_PC6_GOAL)this.getTyped("GOAL", PGL_PC6_GOAL.class);
    }

    public PGL_PC6_GOAL getGOAL(int rep) {
        return (PGL_PC6_GOAL)this.getTyped("GOAL", rep, PGL_PC6_GOAL.class);
    }

    public int getGOALReps() {
        return this.getReps("GOAL");
    }

    public List<PGL_PC6_GOAL> getGOALAll() throws HL7Exception {
        return this.getAllAsList("GOAL", PGL_PC6_GOAL.class);
    }

    public void insertGOAL(PGL_PC6_GOAL structure, int rep) throws HL7Exception {
        super.insertRepetition("GOAL", (Structure)structure, rep);
    }

    public PGL_PC6_GOAL insertGOAL(int rep) throws HL7Exception {
        return (PGL_PC6_GOAL)super.insertRepetition("GOAL", rep);
    }

    public PGL_PC6_GOAL removeGOAL(int rep) throws HL7Exception {
        return (PGL_PC6_GOAL)super.removeRepetition("GOAL", rep);
    }
}

