/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v251.group.OUL_R23_PATIENT;
import ca.uhn.hl7v2.model.v251.group.OUL_R23_SPECIMEN;
import ca.uhn.hl7v2.model.v251.group.OUL_R23_VISIT;
import ca.uhn.hl7v2.model.v251.segment.DSC;
import ca.uhn.hl7v2.model.v251.segment.MSH;
import ca.uhn.hl7v2.model.v251.segment.NTE;
import ca.uhn.hl7v2.model.v251.segment.SFT;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OUL_R23
extends AbstractMessage {
    public OUL_R23() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public OUL_R23(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(NTE.class, false, false);
            this.add(OUL_R23_PATIENT.class, false, false);
            this.add(OUL_R23_VISIT.class, false, false);
            this.add(OUL_R23_SPECIMEN.class, true, true);
            this.add(DSC.class, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating OUL_R23 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5.1";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return (SFT)this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return (SFT)this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", (Structure)structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public NTE getNTE() {
        return (NTE)this.getTyped("NTE", NTE.class);
    }

    public OUL_R23_PATIENT getPATIENT() {
        return (OUL_R23_PATIENT)this.getTyped("PATIENT", OUL_R23_PATIENT.class);
    }

    public OUL_R23_VISIT getVISIT() {
        return (OUL_R23_VISIT)this.getTyped("VISIT", OUL_R23_VISIT.class);
    }

    public OUL_R23_SPECIMEN getSPECIMEN() {
        return (OUL_R23_SPECIMEN)this.getTyped("SPECIMEN", OUL_R23_SPECIMEN.class);
    }

    public OUL_R23_SPECIMEN getSPECIMEN(int rep) {
        return (OUL_R23_SPECIMEN)this.getTyped("SPECIMEN", rep, OUL_R23_SPECIMEN.class);
    }

    public int getSPECIMENReps() {
        return this.getReps("SPECIMEN");
    }

    public List<OUL_R23_SPECIMEN> getSPECIMENAll() throws HL7Exception {
        return this.getAllAsList("SPECIMEN", OUL_R23_SPECIMEN.class);
    }

    public void insertSPECIMEN(OUL_R23_SPECIMEN structure, int rep) throws HL7Exception {
        super.insertRepetition("SPECIMEN", (Structure)structure, rep);
    }

    public OUL_R23_SPECIMEN insertSPECIMEN(int rep) throws HL7Exception {
        return (OUL_R23_SPECIMEN)super.insertRepetition("SPECIMEN", rep);
    }

    public OUL_R23_SPECIMEN removeSPECIMEN(int rep) throws HL7Exception {
        return (OUL_R23_SPECIMEN)super.removeRepetition("SPECIMEN", rep);
    }

    public DSC getDSC() {
        return (DSC)this.getTyped("DSC", DSC.class);
    }
}

