/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v251.group.PEX_P07_EXPERIENCE;
import ca.uhn.hl7v2.model.v251.group.PEX_P07_VISIT;
import ca.uhn.hl7v2.model.v251.segment.EVN;
import ca.uhn.hl7v2.model.v251.segment.MSH;
import ca.uhn.hl7v2.model.v251.segment.NTE;
import ca.uhn.hl7v2.model.v251.segment.PD1;
import ca.uhn.hl7v2.model.v251.segment.PID;
import ca.uhn.hl7v2.model.v251.segment.SFT;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PEX_P07
extends AbstractMessage {
    public PEX_P07() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public PEX_P07(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(EVN.class, true, false);
            this.add(PID.class, true, false);
            this.add(PD1.class, false, false);
            this.add(NTE.class, false, true);
            this.add(PEX_P07_VISIT.class, false, false);
            this.add(PEX_P07_EXPERIENCE.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating PEX_P07 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5.1";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return (SFT)this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return (SFT)this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", (Structure)structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public EVN getEVN() {
        return (EVN)this.getTyped("EVN", EVN.class);
    }

    public PID getPID() {
        return (PID)this.getTyped("PID", PID.class);
    }

    public PD1 getPD1() {
        return (PD1)this.getTyped("PD1", PD1.class);
    }

    public NTE getNTE() {
        return (NTE)this.getTyped("NTE", NTE.class);
    }

    public NTE getNTE(int rep) {
        return (NTE)this.getTyped("NTE", rep, NTE.class);
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public PEX_P07_VISIT getVISIT() {
        return (PEX_P07_VISIT)this.getTyped("VISIT", PEX_P07_VISIT.class);
    }

    public PEX_P07_EXPERIENCE getEXPERIENCE() {
        return (PEX_P07_EXPERIENCE)this.getTyped("EXPERIENCE", PEX_P07_EXPERIENCE.class);
    }

    public PEX_P07_EXPERIENCE getEXPERIENCE(int rep) {
        return (PEX_P07_EXPERIENCE)this.getTyped("EXPERIENCE", rep, PEX_P07_EXPERIENCE.class);
    }

    public int getEXPERIENCEReps() {
        return this.getReps("EXPERIENCE");
    }

    public List<PEX_P07_EXPERIENCE> getEXPERIENCEAll() throws HL7Exception {
        return this.getAllAsList("EXPERIENCE", PEX_P07_EXPERIENCE.class);
    }

    public void insertEXPERIENCE(PEX_P07_EXPERIENCE structure, int rep) throws HL7Exception {
        super.insertRepetition("EXPERIENCE", (Structure)structure, rep);
    }

    public PEX_P07_EXPERIENCE insertEXPERIENCE(int rep) throws HL7Exception {
        return (PEX_P07_EXPERIENCE)super.insertRepetition("EXPERIENCE", rep);
    }

    public PEX_P07_EXPERIENCE removeEXPERIENCE(int rep) throws HL7Exception {
        return (PEX_P07_EXPERIENCE)super.removeRepetition("EXPERIENCE", rep);
    }
}

