/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v26.datatype;

import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.log.HapiLogFactory;

/**
 * <p>Represents an HL7 CD (Channel Definition) data type. 
 * This type consists of the following components:</p>
 * <ul>
 * <li>Channel Identifier (WVI)
 * <li>Waveform Source (WVS)
 * <li>Channel Sensitivity and Units (CSU)
 * <li>Channel Calibration Parameters (CCP)
 * <li>Channel Sampling Frequency (NM)
 * <li>Minimum and Maximum Data Values (NR)
 * </ul>
 */
public class CD extends AbstractType implements Composite {

    private Type[] data;

    /** 
     * Creates a new CD type
     */
    public CD(Message message) {
        super(message);
        init();
    }

    private void init() {
        data = new Type[6];    
        data[0] = new WVI(getMessage());
        data[1] = new WVS(getMessage());
        data[2] = new CSU(getMessage());
        data[3] = new CCP(getMessage());
        data[4] = new NM(getMessage());
        data[5] = new NR(getMessage());
    }


    /**
     * Returns an array containing the data elements.
     */
    public Type[] getComponents() { 
        return this.data; 
    }

    /**
     * Returns an individual data component.
     *
     * @param number The component number (0-indexed)
     * @throws DataTypeException if the given element number is out of range.
     */
    public Type getComponent(int number) throws DataTypeException { 

        try { 
            return this.data[number]; 
        } catch (ArrayIndexOutOfBoundsException e) { 
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + getClass().getName() + " has only " + this.data.length + " components)"); 
        } 
    } 


    /**
     * Returns Channel Identifier (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public WVI getChannelIdentifier() {
       WVI ret = null;
       try {
          ret = (WVI)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Channel Identifier (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public WVI getCd1_ChannelIdentifier() {
       WVI ret = null;
       try {
          ret = (WVI)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Waveform Source (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public WVS getWaveformSource() {
       WVS ret = null;
       try {
          ret = (WVS)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Waveform Source (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public WVS getCd2_WaveformSource() {
       WVS ret = null;
       try {
          ret = (WVS)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Channel Sensitivity and Units (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CSU getChannelSensitivityAndUnits() {
       CSU ret = null;
       try {
          ret = (CSU)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Channel Sensitivity and Units (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CSU getCd3_ChannelSensitivityAndUnits() {
       CSU ret = null;
       try {
          ret = (CSU)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Channel Calibration Parameters (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CCP getChannelCalibrationParameters() {
       CCP ret = null;
       try {
          ret = (CCP)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Channel Calibration Parameters (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CCP getCd4_ChannelCalibrationParameters() {
       CCP ret = null;
       try {
          ret = (CCP)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Channel Sampling Frequency (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getChannelSamplingFrequency() {
       NM ret = null;
       try {
          ret = (NM)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Channel Sampling Frequency (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getCd5_ChannelSamplingFrequency() {
       NM ret = null;
       try {
          ret = (NM)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Minimum and Maximum Data Values (component #6).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NR getMinimumAndMaximumDataValues() {
       NR ret = null;
       try {
          ret = (NR)getComponent(5);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Minimum and Maximum Data Values (component #6).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NR getCd6_MinimumAndMaximumDataValues() {
       NR ret = null;
       try {
          ret = (NR)getComponent(5);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }



}

