/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v26.datatype;

import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.log.HapiLogFactory;

/**
 * <p>Represents an HL7 CQ (Composite Quantity with Units) data type. 
 * This type consists of the following components:</p>
 * <ul>
 * <li>Quantity (NM)
 * <li>Units (CWE)
 * </ul>
 */
public class CQ extends AbstractType implements Composite {

    private Type[] data;

    /** 
     * Creates a new CQ type
     */
    public CQ(Message message) {
        super(message);
        init();
    }

    private void init() {
        data = new Type[2];    
        data[0] = new NM(getMessage());
        data[1] = new CWE(getMessage());
    }


    /**
     * Returns an array containing the data elements.
     */
    public Type[] getComponents() { 
        return this.data; 
    }

    /**
     * Returns an individual data component.
     *
     * @param number The component number (0-indexed)
     * @throws DataTypeException if the given element number is out of range.
     */
    public Type getComponent(int number) throws DataTypeException { 

        try { 
            return this.data[number]; 
        } catch (ArrayIndexOutOfBoundsException e) { 
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + getClass().getName() + " has only " + this.data.length + " components)"); 
        } 
    } 


    /**
     * Returns Quantity (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getQuantity() {
       NM ret = null;
       try {
          ret = (NM)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Quantity (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getCq1_Quantity() {
       NM ret = null;
       try {
          ret = (NM)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Units (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CWE getUnits() {
       CWE ret = null;
       try {
          ret = (CWE)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Units (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CWE getCq2_Units() {
       CWE ret = null;
       try {
          ret = (CWE)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }



}

