/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v26.datatype;

import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.log.HapiLogFactory;

/**
 * <p>Represents an HL7 DLT (Delta) data type. 
 * This type consists of the following components:</p>
 * <ul>
 * <li>Normal Range (NR)
 * <li>Numeric Threshold (NM)
 * <li>Change Computation (ID)
 * <li>Days Retained (NM)
 * </ul>
 */
public class DLT extends AbstractType implements Composite {

    private Type[] data;

    /** 
     * Creates a new DLT type
     */
    public DLT(Message message) {
        super(message);
        init();
    }

    private void init() {
        data = new Type[4];    
        data[0] = new NR(getMessage());
        data[1] = new NM(getMessage());
        data[2] = new ID(getMessage(), 523);
        data[3] = new NM(getMessage());
    }


    /**
     * Returns an array containing the data elements.
     */
    public Type[] getComponents() { 
        return this.data; 
    }

    /**
     * Returns an individual data component.
     *
     * @param number The component number (0-indexed)
     * @throws DataTypeException if the given element number is out of range.
     */
    public Type getComponent(int number) throws DataTypeException { 

        try { 
            return this.data[number]; 
        } catch (ArrayIndexOutOfBoundsException e) { 
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + getClass().getName() + " has only " + this.data.length + " components)"); 
        } 
    } 


    /**
     * Returns Normal Range (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NR getNormalRange() {
       NR ret = null;
       try {
          ret = (NR)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Normal Range (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NR getDlt1_NormalRange() {
       NR ret = null;
       try {
          ret = (NR)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Numeric Threshold (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getNumericThreshold() {
       NM ret = null;
       try {
          ret = (NM)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Numeric Threshold (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getDlt2_NumericThreshold() {
       NM ret = null;
       try {
          ret = (NM)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Change Computation (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getChangeComputation() {
       ID ret = null;
       try {
          ret = (ID)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Change Computation (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getDlt3_ChangeComputation() {
       ID ret = null;
       try {
          ret = (ID)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Days Retained (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getDaysRetained() {
       NM ret = null;
       try {
          ret = (NM)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Days Retained (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getDlt4_DaysRetained() {
       NM ret = null;
       try {
          ret = (NM)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }



}

