/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v26.datatype;

import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.log.HapiLogFactory;

/**
 * <p>Represents an HL7 TQ (Timing Quantity) data type. 
 * This type consists of the following components:</p>
 * <ul>
 * <li>Quantity (CQ)
 * <li>Interval (RI)
 * <li>Duration (ST)
 * <li>Start Date/Time (DTM)
 * <li>End Date/Time (DTM)
 * <li>Priority (ST)
 * <li>Condition (ST)
 * <li>Text (TX)
 * <li>Conjunction (ID)
 * <li>Order Sequencing (OSD)
 * <li>Occurrence Duration (CWE)
 * <li>Total Occurrences (NM)
 * </ul>
 */
public class TQ extends AbstractType implements Composite {

    private Type[] data;

    /** 
     * Creates a new TQ type
     */
    public TQ(Message message) {
        super(message);
        init();
    }

    private void init() {
        data = new Type[12];    
        data[0] = new CQ(getMessage());
        data[1] = new RI(getMessage());
        data[2] = new ST(getMessage());
        data[3] = new DTM(getMessage());
        data[4] = new DTM(getMessage());
        data[5] = new ST(getMessage());
        data[6] = new ST(getMessage());
        data[7] = new TX(getMessage());
        data[8] = new ID(getMessage(), 472);
        data[9] = new OSD(getMessage());
        data[10] = new CWE(getMessage());
        data[11] = new NM(getMessage());
    }


    /**
     * Returns an array containing the data elements.
     */
    public Type[] getComponents() { 
        return this.data; 
    }

    /**
     * Returns an individual data component.
     *
     * @param number The component number (0-indexed)
     * @throws DataTypeException if the given element number is out of range.
     */
    public Type getComponent(int number) throws DataTypeException { 

        try { 
            return this.data[number]; 
        } catch (ArrayIndexOutOfBoundsException e) { 
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + getClass().getName() + " has only " + this.data.length + " components)"); 
        } 
    } 


    /**
     * Returns Quantity (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CQ getQuantity() {
       CQ ret = null;
       try {
          ret = (CQ)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Quantity (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CQ getTq1_Quantity() {
       CQ ret = null;
       try {
          ret = (CQ)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Interval (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public RI getInterval() {
       RI ret = null;
       try {
          ret = (RI)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Interval (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public RI getTq2_Interval() {
       RI ret = null;
       try {
          ret = (RI)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Duration (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getDuration() {
       ST ret = null;
       try {
          ret = (ST)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Duration (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getTq3_Duration() {
       ST ret = null;
       try {
          ret = (ST)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Start Date/Time (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public DTM getStartDateTime() {
       DTM ret = null;
       try {
          ret = (DTM)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Start Date/Time (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public DTM getTq4_StartDateTime() {
       DTM ret = null;
       try {
          ret = (DTM)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns End Date/Time (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public DTM getEndDateTime() {
       DTM ret = null;
       try {
          ret = (DTM)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns End Date/Time (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public DTM getTq5_EndDateTime() {
       DTM ret = null;
       try {
          ret = (DTM)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Priority (component #6).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getPriority() {
       ST ret = null;
       try {
          ret = (ST)getComponent(5);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Priority (component #6).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getTq6_Priority() {
       ST ret = null;
       try {
          ret = (ST)getComponent(5);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Condition (component #7).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getCondition() {
       ST ret = null;
       try {
          ret = (ST)getComponent(6);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Condition (component #7).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getTq7_Condition() {
       ST ret = null;
       try {
          ret = (ST)getComponent(6);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Text (component #8).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public TX getText() {
       TX ret = null;
       try {
          ret = (TX)getComponent(7);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Text (component #8).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public TX getTq8_Text() {
       TX ret = null;
       try {
          ret = (TX)getComponent(7);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Conjunction (component #9).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getConjunction() {
       ID ret = null;
       try {
          ret = (ID)getComponent(8);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Conjunction (component #9).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getTq9_Conjunction() {
       ID ret = null;
       try {
          ret = (ID)getComponent(8);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Order Sequencing (component #10).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public OSD getOrderSequencing() {
       OSD ret = null;
       try {
          ret = (OSD)getComponent(9);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Order Sequencing (component #10).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public OSD getTq10_OrderSequencing() {
       OSD ret = null;
       try {
          ret = (OSD)getComponent(9);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Occurrence Duration (component #11).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CWE getOccurrenceDuration() {
       CWE ret = null;
       try {
          ret = (CWE)getComponent(10);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Occurrence Duration (component #11).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CWE getTq11_OccurrenceDuration() {
       CWE ret = null;
       try {
          ret = (CWE)getComponent(10);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Total Occurrences (component #12).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getTotalOccurrences() {
       NM ret = null;
       try {
          ret = (NM)getComponent(11);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Total Occurrences (component #12).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getTq12_TotalOccurrences() {
       NM ret = null;
       try {
          ret = (NM)getComponent(11);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }



}

