/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v26.datatype;

import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.log.HapiLogFactory;

/**
 * <p>Represents an HL7 VH (Visiting Hours) data type. 
 * This type consists of the following components:</p>
 * <ul>
 * <li>Start Day Range (ID)
 * <li>End Day Range (ID)
 * <li>Start Hour Range (TM)
 * <li>End Hour Range (TM)
 * </ul>
 */
public class VH extends AbstractType implements Composite {

    private Type[] data;

    /** 
     * Creates a new VH type
     */
    public VH(Message message) {
        super(message);
        init();
    }

    private void init() {
        data = new Type[4];    
        data[0] = new ID(getMessage(), 267);
        data[1] = new ID(getMessage(), 267);
        data[2] = new TM(getMessage());
        data[3] = new TM(getMessage());
    }


    /**
     * Returns an array containing the data elements.
     */
    public Type[] getComponents() { 
        return this.data; 
    }

    /**
     * Returns an individual data component.
     *
     * @param number The component number (0-indexed)
     * @throws DataTypeException if the given element number is out of range.
     */
    public Type getComponent(int number) throws DataTypeException { 

        try { 
            return this.data[number]; 
        } catch (ArrayIndexOutOfBoundsException e) { 
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + getClass().getName() + " has only " + this.data.length + " components)"); 
        } 
    } 


    /**
     * Returns Start Day Range (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getStartDayRange() {
       ID ret = null;
       try {
          ret = (ID)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Start Day Range (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getVh1_StartDayRange() {
       ID ret = null;
       try {
          ret = (ID)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns End Day Range (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getEndDayRange() {
       ID ret = null;
       try {
          ret = (ID)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns End Day Range (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getVh2_EndDayRange() {
       ID ret = null;
       try {
          ret = (ID)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Start Hour Range (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public TM getStartHourRange() {
       TM ret = null;
       try {
          ret = (TM)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Start Hour Range (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public TM getVh3_StartHourRange() {
       TM ret = null;
       try {
          ret = (TM)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns End Hour Range (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public TM getEndHourRange() {
       TM ret = null;
       try {
          ret = (TM)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns End Hour Range (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public TM getVh4_EndHourRange() {
       TM ret = null;
       try {
          ret = (TM)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }



}

