/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v26.datatype;

import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.log.HapiLogFactory;

/**
 * <p>Represents an HL7 XON (Extended Composite Name and Identification Number for Organizations) data type. 
 * This type consists of the following components:</p>
 * <ul>
 * <li>Organization Name (ST)
 * <li>Organization Name Type Code (IS)
 * <li>ID Number (NM)
 * <li>Identifier Check Digit (NM)
 * <li>Check Digit Scheme (ID)
 * <li>Assigning Authority (HD)
 * <li>Identifier Type Code (ID)
 * <li>Assigning Facility (HD)
 * <li>Name Representation Code (ID)
 * <li>Organization Identifier (ST)
 * </ul>
 */
public class XON extends AbstractType implements Composite {

    private Type[] data;

    /** 
     * Creates a new XON type
     */
    public XON(Message message) {
        super(message);
        init();
    }

    private void init() {
        data = new Type[10];    
        data[0] = new ST(getMessage());
        data[1] = new IS(getMessage(), 204);
        data[2] = new NM(getMessage());
        data[3] = new NM(getMessage());
        data[4] = new ID(getMessage(), 61);
        data[5] = new HD(getMessage());
        data[6] = new ID(getMessage(), 203);
        data[7] = new HD(getMessage());
        data[8] = new ID(getMessage(), 465);
        data[9] = new ST(getMessage());
    }


    /**
     * Returns an array containing the data elements.
     */
    public Type[] getComponents() { 
        return this.data; 
    }

    /**
     * Returns an individual data component.
     *
     * @param number The component number (0-indexed)
     * @throws DataTypeException if the given element number is out of range.
     */
    public Type getComponent(int number) throws DataTypeException { 

        try { 
            return this.data[number]; 
        } catch (ArrayIndexOutOfBoundsException e) { 
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + getClass().getName() + " has only " + this.data.length + " components)"); 
        } 
    } 


    /**
     * Returns Organization Name (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getOrganizationName() {
       ST ret = null;
       try {
          ret = (ST)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Organization Name (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getXon1_OrganizationName() {
       ST ret = null;
       try {
          ret = (ST)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Organization Name Type Code (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getOrganizationNameTypeCode() {
       IS ret = null;
       try {
          ret = (IS)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Organization Name Type Code (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getXon2_OrganizationNameTypeCode() {
       IS ret = null;
       try {
          ret = (IS)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns ID Number (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getIDNumber() {
       NM ret = null;
       try {
          ret = (NM)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns ID Number (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getXon3_IDNumber() {
       NM ret = null;
       try {
          ret = (NM)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Identifier Check Digit (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getIdentifierCheckDigit() {
       NM ret = null;
       try {
          ret = (NM)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Identifier Check Digit (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getXon4_IdentifierCheckDigit() {
       NM ret = null;
       try {
          ret = (NM)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Check Digit Scheme (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getCheckDigitScheme() {
       ID ret = null;
       try {
          ret = (ID)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Check Digit Scheme (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getXon5_CheckDigitScheme() {
       ID ret = null;
       try {
          ret = (ID)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Assigning Authority (component #6).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public HD getAssigningAuthority() {
       HD ret = null;
       try {
          ret = (HD)getComponent(5);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Assigning Authority (component #6).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public HD getXon6_AssigningAuthority() {
       HD ret = null;
       try {
          ret = (HD)getComponent(5);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Identifier Type Code (component #7).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getIdentifierTypeCode() {
       ID ret = null;
       try {
          ret = (ID)getComponent(6);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Identifier Type Code (component #7).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getXon7_IdentifierTypeCode() {
       ID ret = null;
       try {
          ret = (ID)getComponent(6);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Assigning Facility (component #8).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public HD getAssigningFacility() {
       HD ret = null;
       try {
          ret = (HD)getComponent(7);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Assigning Facility (component #8).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public HD getXon8_AssigningFacility() {
       HD ret = null;
       try {
          ret = (HD)getComponent(7);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Name Representation Code (component #9).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getNameRepresentationCode() {
       ID ret = null;
       try {
          ret = (ID)getComponent(8);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Name Representation Code (component #9).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getXon9_NameRepresentationCode() {
       ID ret = null;
       try {
          ret = (ID)getComponent(8);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Organization Identifier (component #10).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getOrganizationIdentifier() {
       ST ret = null;
       try {
          ret = (ST)getComponent(9);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Organization Identifier (component #10).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getXon10_OrganizationIdentifier() {
       ST ret = null;
       try {
          ret = (ST)getComponent(9);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }



}

