/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.model.v26.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericSegment;

/**
 * <p>Represents a CSU_C09_PATIENT group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: PID (Patient Identification) <b> </b></li>
                 * <li>2: PD1 (Patient Additional Demographic) <b>optional </b></li>
                 * <li>3: NTE (Notes and Comments) <b>optional repeating</b></li>
                 * <li>4: CSU_C09_VISIT (a Group object) <b>optional </b></li>
                 * <li>5: CSR (Clinical Study Registration) <b> </b></li>
                 * <li>6: CSU_C09_STUDY_PHASE (a Group object) <b> repeating</b></li>
 * </ul>
 */
public class CSU_C09_PATIENT extends AbstractGroup {

    /** 
     * Creates a new CSU_C09_PATIENT group
     */
    public CSU_C09_PATIENT(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(PID.class, true, false);
                          this.add(PD1.class, false, false);
                          this.add(NTE.class, false, true);
                          this.add(CSU_C09_VISIT.class, false, false);
                          this.add(CSR.class, true, false);
                          this.add(CSU_C09_STUDY_PHASE.class, true, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating CSU_C09_PATIENT - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.6"
     */
    public String getVersion() {
       return "2.6";
    }



    /**
     * Returns
     * PID (Patient Identification) - creates it if necessary
     */
    public PID getPID() { 
       PID ret = null;
       try {
          ret = (PID)this.get("PID");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * PD1 (Patient Additional Demographic) - creates it if necessary
     */
    public PD1 getPD1() { 
       PD1 ret = null;
       try {
          ret = (PD1)this.get("PD1");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * NTE (Notes and Comments) - creates it if necessary
     */
    public NTE getNTE() { 
       NTE ret = null;
       try {
          ret = (NTE)this.get("NTE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * NTE (Notes and Comments) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public NTE getNTE(int rep) { 
       NTE ret = null;
       try {
          ret = (NTE)this.get("NTE", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of NTE 
     */ 
    public int getNTEReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("NTE").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of NTE (Notes and Comments)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertNTE(NTE structure, int rep) throws HL7Exception { 
       super.insertRepetition("NTE", structure, rep);
    }


    /**
     * Inserts a specific repetition of NTE (Notes and Comments)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public NTE insertNTE(int rep) throws HL7Exception { 
       return (NTE)super.insertRepetition("NTE", rep);
    }


    /**
     * Removes a specific repetition of NTE (Notes and Comments)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public NTE removeNTE(int rep) throws HL7Exception { 
       return (NTE)super.removeRepetition("NTE", rep);
    }



    /**
     * Returns
     * VISIT (a Group object) - creates it if necessary
     */
    public CSU_C09_VISIT getVISIT() { 
       CSU_C09_VISIT ret = null;
       try {
          ret = (CSU_C09_VISIT)this.get("VISIT");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * CSR (Clinical Study Registration) - creates it if necessary
     */
    public CSR getCSR() { 
       CSR ret = null;
       try {
          ret = (CSR)this.get("CSR");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * STUDY_PHASE (a Group object) - creates it if necessary
     */
    public CSU_C09_STUDY_PHASE getSTUDY_PHASE() { 
       CSU_C09_STUDY_PHASE ret = null;
       try {
          ret = (CSU_C09_STUDY_PHASE)this.get("STUDY_PHASE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * STUDY_PHASE (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public CSU_C09_STUDY_PHASE getSTUDY_PHASE(int rep) { 
       CSU_C09_STUDY_PHASE ret = null;
       try {
          ret = (CSU_C09_STUDY_PHASE)this.get("STUDY_PHASE", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of STUDY_PHASE 
     */ 
    public int getSTUDY_PHASEReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("STUDY_PHASE").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of STUDY_PHASE (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertSTUDY_PHASE(CSU_C09_STUDY_PHASE structure, int rep) throws HL7Exception { 
       super.insertRepetition("STUDY_PHASE", structure, rep);
    }


    /**
     * Inserts a specific repetition of STUDY_PHASE (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public CSU_C09_STUDY_PHASE insertSTUDY_PHASE(int rep) throws HL7Exception { 
       return (CSU_C09_STUDY_PHASE)super.insertRepetition("STUDY_PHASE", rep);
    }


    /**
     * Removes a specific repetition of STUDY_PHASE (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public CSU_C09_STUDY_PHASE removeSTUDY_PHASE(int rep) throws HL7Exception { 
       return (CSU_C09_STUDY_PHASE)super.removeRepetition("STUDY_PHASE", rep);
    }



}

