/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.model.v26.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericSegment;

/**
 * <p>Represents a EHC_E10_PRODUCT_SERVICE_GROUP group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: PSG (Product/Service Group) <b> </b></li>
                 * <li>2: EHC_E10_PRODUCT_SERVICE_LINE_INFO (a Group object) <b> repeating</b></li>
 * </ul>
 */
public class EHC_E10_PRODUCT_SERVICE_GROUP extends AbstractGroup {

    /** 
     * Creates a new EHC_E10_PRODUCT_SERVICE_GROUP group
     */
    public EHC_E10_PRODUCT_SERVICE_GROUP(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(PSG.class, true, false);
                          this.add(EHC_E10_PRODUCT_SERVICE_LINE_INFO.class, true, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating EHC_E10_PRODUCT_SERVICE_GROUP - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.6"
     */
    public String getVersion() {
       return "2.6";
    }



    /**
     * Returns
     * PSG (Product/Service Group) - creates it if necessary
     */
    public PSG getPSG() { 
       PSG ret = null;
       try {
          ret = (PSG)this.get("PSG");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * PRODUCT_SERVICE_LINE_INFO (a Group object) - creates it if necessary
     */
    public EHC_E10_PRODUCT_SERVICE_LINE_INFO getPRODUCT_SERVICE_LINE_INFO() { 
       EHC_E10_PRODUCT_SERVICE_LINE_INFO ret = null;
       try {
          ret = (EHC_E10_PRODUCT_SERVICE_LINE_INFO)this.get("PRODUCT_SERVICE_LINE_INFO");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * PRODUCT_SERVICE_LINE_INFO (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public EHC_E10_PRODUCT_SERVICE_LINE_INFO getPRODUCT_SERVICE_LINE_INFO(int rep) { 
       EHC_E10_PRODUCT_SERVICE_LINE_INFO ret = null;
       try {
          ret = (EHC_E10_PRODUCT_SERVICE_LINE_INFO)this.get("PRODUCT_SERVICE_LINE_INFO", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of PRODUCT_SERVICE_LINE_INFO 
     */ 
    public int getPRODUCT_SERVICE_LINE_INFOReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("PRODUCT_SERVICE_LINE_INFO").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of PRODUCT_SERVICE_LINE_INFO (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertPRODUCT_SERVICE_LINE_INFO(EHC_E10_PRODUCT_SERVICE_LINE_INFO structure, int rep) throws HL7Exception { 
       super.insertRepetition("PRODUCT_SERVICE_LINE_INFO", structure, rep);
    }


    /**
     * Inserts a specific repetition of PRODUCT_SERVICE_LINE_INFO (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public EHC_E10_PRODUCT_SERVICE_LINE_INFO insertPRODUCT_SERVICE_LINE_INFO(int rep) throws HL7Exception { 
       return (EHC_E10_PRODUCT_SERVICE_LINE_INFO)super.insertRepetition("PRODUCT_SERVICE_LINE_INFO", rep);
    }


    /**
     * Removes a specific repetition of PRODUCT_SERVICE_LINE_INFO (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public EHC_E10_PRODUCT_SERVICE_LINE_INFO removePRODUCT_SERVICE_LINE_INFO(int rep) throws HL7Exception { 
       return (EHC_E10_PRODUCT_SERVICE_LINE_INFO)super.removeRepetition("PRODUCT_SERVICE_LINE_INFO", rep);
    }



}

