/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.model.v26.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericSegment;

/**
 * <p>Represents a EHC_E15_PAYMENT_REMITTANCE_DETAIL_INFO group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: IPR (Invoice Processing Results) <b> </b></li>
                 * <li>2: IVC (Invoice Segment) <b> </b></li>
                 * <li>3: EHC_E15_PRODUCT_SERVICE_SECTION (a Group object) <b> repeating</b></li>
 * </ul>
 */
public class EHC_E15_PAYMENT_REMITTANCE_DETAIL_INFO extends AbstractGroup {

    /** 
     * Creates a new EHC_E15_PAYMENT_REMITTANCE_DETAIL_INFO group
     */
    public EHC_E15_PAYMENT_REMITTANCE_DETAIL_INFO(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(IPR.class, true, false);
                          this.add(IVC.class, true, false);
                          this.add(EHC_E15_PRODUCT_SERVICE_SECTION.class, true, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating EHC_E15_PAYMENT_REMITTANCE_DETAIL_INFO - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.6"
     */
    public String getVersion() {
       return "2.6";
    }



    /**
     * Returns
     * IPR (Invoice Processing Results) - creates it if necessary
     */
    public IPR getIPR() { 
       IPR ret = null;
       try {
          ret = (IPR)this.get("IPR");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * IVC (Invoice Segment) - creates it if necessary
     */
    public IVC getIVC() { 
       IVC ret = null;
       try {
          ret = (IVC)this.get("IVC");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * PRODUCT_SERVICE_SECTION (a Group object) - creates it if necessary
     */
    public EHC_E15_PRODUCT_SERVICE_SECTION getPRODUCT_SERVICE_SECTION() { 
       EHC_E15_PRODUCT_SERVICE_SECTION ret = null;
       try {
          ret = (EHC_E15_PRODUCT_SERVICE_SECTION)this.get("PRODUCT_SERVICE_SECTION");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * PRODUCT_SERVICE_SECTION (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public EHC_E15_PRODUCT_SERVICE_SECTION getPRODUCT_SERVICE_SECTION(int rep) { 
       EHC_E15_PRODUCT_SERVICE_SECTION ret = null;
       try {
          ret = (EHC_E15_PRODUCT_SERVICE_SECTION)this.get("PRODUCT_SERVICE_SECTION", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of PRODUCT_SERVICE_SECTION 
     */ 
    public int getPRODUCT_SERVICE_SECTIONReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("PRODUCT_SERVICE_SECTION").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of PRODUCT_SERVICE_SECTION (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertPRODUCT_SERVICE_SECTION(EHC_E15_PRODUCT_SERVICE_SECTION structure, int rep) throws HL7Exception { 
       super.insertRepetition("PRODUCT_SERVICE_SECTION", structure, rep);
    }


    /**
     * Inserts a specific repetition of PRODUCT_SERVICE_SECTION (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public EHC_E15_PRODUCT_SERVICE_SECTION insertPRODUCT_SERVICE_SECTION(int rep) throws HL7Exception { 
       return (EHC_E15_PRODUCT_SERVICE_SECTION)super.insertRepetition("PRODUCT_SERVICE_SECTION", rep);
    }


    /**
     * Removes a specific repetition of PRODUCT_SERVICE_SECTION (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public EHC_E15_PRODUCT_SERVICE_SECTION removePRODUCT_SERVICE_SECTION(int rep) throws HL7Exception { 
       return (EHC_E15_PRODUCT_SERVICE_SECTION)super.removeRepetition("PRODUCT_SERVICE_SECTION", rep);
    }



}

