/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.model.v26.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericSegment;

/**
 * <p>Represents a MFN_M16_MATERIAL_ITEM_RECORD group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: MFE (Master File Entry) <b> </b></li>
                 * <li>2: ITM (Material Item) <b> </b></li>
                 * <li>3: NTE (Notes and Comments) <b>optional repeating</b></li>
                 * <li>4: MFN_M16_STERILIZATION (a Group object) <b>optional repeating</b></li>
                 * <li>5: MFN_M16_PURCHASING_VENDOR (a Group object) <b>optional repeating</b></li>
                 * <li>6: MFN_M16_MATERIAL_LOCATION (a Group object) <b>optional repeating</b></li>
 * </ul>
 */
public class MFN_M16_MATERIAL_ITEM_RECORD extends AbstractGroup {

    /** 
     * Creates a new MFN_M16_MATERIAL_ITEM_RECORD group
     */
    public MFN_M16_MATERIAL_ITEM_RECORD(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(MFE.class, true, false);
                          this.add(ITM.class, true, false);
                          this.add(NTE.class, false, true);
                          this.add(MFN_M16_STERILIZATION.class, false, true);
                          this.add(MFN_M16_PURCHASING_VENDOR.class, false, true);
                          this.add(MFN_M16_MATERIAL_LOCATION.class, false, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating MFN_M16_MATERIAL_ITEM_RECORD - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.6"
     */
    public String getVersion() {
       return "2.6";
    }



    /**
     * Returns
     * MFE (Master File Entry) - creates it if necessary
     */
    public MFE getMFE() { 
       MFE ret = null;
       try {
          ret = (MFE)this.get("MFE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * ITM (Material Item) - creates it if necessary
     */
    public ITM getITM() { 
       ITM ret = null;
       try {
          ret = (ITM)this.get("ITM");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * NTE (Notes and Comments) - creates it if necessary
     */
    public NTE getNTE() { 
       NTE ret = null;
       try {
          ret = (NTE)this.get("NTE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * NTE (Notes and Comments) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public NTE getNTE(int rep) { 
       NTE ret = null;
       try {
          ret = (NTE)this.get("NTE", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of NTE 
     */ 
    public int getNTEReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("NTE").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of NTE (Notes and Comments)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertNTE(NTE structure, int rep) throws HL7Exception { 
       super.insertRepetition("NTE", structure, rep);
    }


    /**
     * Inserts a specific repetition of NTE (Notes and Comments)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public NTE insertNTE(int rep) throws HL7Exception { 
       return (NTE)super.insertRepetition("NTE", rep);
    }


    /**
     * Removes a specific repetition of NTE (Notes and Comments)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public NTE removeNTE(int rep) throws HL7Exception { 
       return (NTE)super.removeRepetition("NTE", rep);
    }



    /**
     * Returns
     * the first repetition of 
     * STERILIZATION (a Group object) - creates it if necessary
     */
    public MFN_M16_STERILIZATION getSTERILIZATION() { 
       MFN_M16_STERILIZATION ret = null;
       try {
          ret = (MFN_M16_STERILIZATION)this.get("STERILIZATION");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * STERILIZATION (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public MFN_M16_STERILIZATION getSTERILIZATION(int rep) { 
       MFN_M16_STERILIZATION ret = null;
       try {
          ret = (MFN_M16_STERILIZATION)this.get("STERILIZATION", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of STERILIZATION 
     */ 
    public int getSTERILIZATIONReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("STERILIZATION").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of STERILIZATION (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertSTERILIZATION(MFN_M16_STERILIZATION structure, int rep) throws HL7Exception { 
       super.insertRepetition("STERILIZATION", structure, rep);
    }


    /**
     * Inserts a specific repetition of STERILIZATION (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public MFN_M16_STERILIZATION insertSTERILIZATION(int rep) throws HL7Exception { 
       return (MFN_M16_STERILIZATION)super.insertRepetition("STERILIZATION", rep);
    }


    /**
     * Removes a specific repetition of STERILIZATION (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public MFN_M16_STERILIZATION removeSTERILIZATION(int rep) throws HL7Exception { 
       return (MFN_M16_STERILIZATION)super.removeRepetition("STERILIZATION", rep);
    }



    /**
     * Returns
     * the first repetition of 
     * PURCHASING_VENDOR (a Group object) - creates it if necessary
     */
    public MFN_M16_PURCHASING_VENDOR getPURCHASING_VENDOR() { 
       MFN_M16_PURCHASING_VENDOR ret = null;
       try {
          ret = (MFN_M16_PURCHASING_VENDOR)this.get("PURCHASING_VENDOR");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * PURCHASING_VENDOR (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public MFN_M16_PURCHASING_VENDOR getPURCHASING_VENDOR(int rep) { 
       MFN_M16_PURCHASING_VENDOR ret = null;
       try {
          ret = (MFN_M16_PURCHASING_VENDOR)this.get("PURCHASING_VENDOR", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of PURCHASING_VENDOR 
     */ 
    public int getPURCHASING_VENDORReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("PURCHASING_VENDOR").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of PURCHASING_VENDOR (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertPURCHASING_VENDOR(MFN_M16_PURCHASING_VENDOR structure, int rep) throws HL7Exception { 
       super.insertRepetition("PURCHASING_VENDOR", structure, rep);
    }


    /**
     * Inserts a specific repetition of PURCHASING_VENDOR (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public MFN_M16_PURCHASING_VENDOR insertPURCHASING_VENDOR(int rep) throws HL7Exception { 
       return (MFN_M16_PURCHASING_VENDOR)super.insertRepetition("PURCHASING_VENDOR", rep);
    }


    /**
     * Removes a specific repetition of PURCHASING_VENDOR (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public MFN_M16_PURCHASING_VENDOR removePURCHASING_VENDOR(int rep) throws HL7Exception { 
       return (MFN_M16_PURCHASING_VENDOR)super.removeRepetition("PURCHASING_VENDOR", rep);
    }



    /**
     * Returns
     * the first repetition of 
     * MATERIAL_LOCATION (a Group object) - creates it if necessary
     */
    public MFN_M16_MATERIAL_LOCATION getMATERIAL_LOCATION() { 
       MFN_M16_MATERIAL_LOCATION ret = null;
       try {
          ret = (MFN_M16_MATERIAL_LOCATION)this.get("MATERIAL_LOCATION");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * MATERIAL_LOCATION (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public MFN_M16_MATERIAL_LOCATION getMATERIAL_LOCATION(int rep) { 
       MFN_M16_MATERIAL_LOCATION ret = null;
       try {
          ret = (MFN_M16_MATERIAL_LOCATION)this.get("MATERIAL_LOCATION", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of MATERIAL_LOCATION 
     */ 
    public int getMATERIAL_LOCATIONReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("MATERIAL_LOCATION").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of MATERIAL_LOCATION (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertMATERIAL_LOCATION(MFN_M16_MATERIAL_LOCATION structure, int rep) throws HL7Exception { 
       super.insertRepetition("MATERIAL_LOCATION", structure, rep);
    }


    /**
     * Inserts a specific repetition of MATERIAL_LOCATION (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public MFN_M16_MATERIAL_LOCATION insertMATERIAL_LOCATION(int rep) throws HL7Exception { 
       return (MFN_M16_MATERIAL_LOCATION)super.insertRepetition("MATERIAL_LOCATION", rep);
    }


    /**
     * Removes a specific repetition of MATERIAL_LOCATION (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public MFN_M16_MATERIAL_LOCATION removeMATERIAL_LOCATION(int rep) throws HL7Exception { 
       return (MFN_M16_MATERIAL_LOCATION)super.removeRepetition("MATERIAL_LOCATION", rep);
    }



}

