/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.model.v26.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericSegment;

/**
 * <p>Represents a OMD_O03_ORDER_DIET group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: ORC (Common Order) <b> </b></li>
                 * <li>2: OMD_O03_TIMING_DIET (a Group object) <b>optional repeating</b></li>
                 * <li>3: OMD_O03_DIET (a Group object) <b>optional </b></li>
 * </ul>
 */
public class OMD_O03_ORDER_DIET extends AbstractGroup {

    /** 
     * Creates a new OMD_O03_ORDER_DIET group
     */
    public OMD_O03_ORDER_DIET(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(ORC.class, true, false);
                          this.add(OMD_O03_TIMING_DIET.class, false, true);
                          this.add(OMD_O03_DIET.class, false, false);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating OMD_O03_ORDER_DIET - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.6"
     */
    public String getVersion() {
       return "2.6";
    }



    /**
     * Returns
     * ORC (Common Order) - creates it if necessary
     */
    public ORC getORC() { 
       ORC ret = null;
       try {
          ret = (ORC)this.get("ORC");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * TIMING_DIET (a Group object) - creates it if necessary
     */
    public OMD_O03_TIMING_DIET getTIMING_DIET() { 
       OMD_O03_TIMING_DIET ret = null;
       try {
          ret = (OMD_O03_TIMING_DIET)this.get("TIMING_DIET");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * TIMING_DIET (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public OMD_O03_TIMING_DIET getTIMING_DIET(int rep) { 
       OMD_O03_TIMING_DIET ret = null;
       try {
          ret = (OMD_O03_TIMING_DIET)this.get("TIMING_DIET", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of TIMING_DIET 
     */ 
    public int getTIMING_DIETReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("TIMING_DIET").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of TIMING_DIET (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertTIMING_DIET(OMD_O03_TIMING_DIET structure, int rep) throws HL7Exception { 
       super.insertRepetition("TIMING_DIET", structure, rep);
    }


    /**
     * Inserts a specific repetition of TIMING_DIET (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public OMD_O03_TIMING_DIET insertTIMING_DIET(int rep) throws HL7Exception { 
       return (OMD_O03_TIMING_DIET)super.insertRepetition("TIMING_DIET", rep);
    }


    /**
     * Removes a specific repetition of TIMING_DIET (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public OMD_O03_TIMING_DIET removeTIMING_DIET(int rep) throws HL7Exception { 
       return (OMD_O03_TIMING_DIET)super.removeRepetition("TIMING_DIET", rep);
    }



    /**
     * Returns
     * DIET (a Group object) - creates it if necessary
     */
    public OMD_O03_DIET getDIET() { 
       OMD_O03_DIET ret = null;
       try {
          ret = (OMD_O03_DIET)this.get("DIET");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




}

