/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.model.v26.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericSegment;

/**
 * <p>Represents a ORD_O04_ORDER_TRAY group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: ORC (Common Order) <b> </b></li>
                 * <li>2: ORD_O04_TIMING_TRAY (a Group object) <b>optional repeating</b></li>
                 * <li>3: ODT (Diet Tray Instructions) <b>optional repeating</b></li>
                 * <li>4: NTE (Notes and Comments) <b>optional repeating</b></li>
 * </ul>
 */
public class ORD_O04_ORDER_TRAY extends AbstractGroup {

    /** 
     * Creates a new ORD_O04_ORDER_TRAY group
     */
    public ORD_O04_ORDER_TRAY(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(ORC.class, true, false);
                          this.add(ORD_O04_TIMING_TRAY.class, false, true);
                          this.add(ODT.class, false, true);
                          this.add(NTE.class, false, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating ORD_O04_ORDER_TRAY - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.6"
     */
    public String getVersion() {
       return "2.6";
    }



    /**
     * Returns
     * ORC (Common Order) - creates it if necessary
     */
    public ORC getORC() { 
       ORC ret = null;
       try {
          ret = (ORC)this.get("ORC");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * TIMING_TRAY (a Group object) - creates it if necessary
     */
    public ORD_O04_TIMING_TRAY getTIMING_TRAY() { 
       ORD_O04_TIMING_TRAY ret = null;
       try {
          ret = (ORD_O04_TIMING_TRAY)this.get("TIMING_TRAY");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * TIMING_TRAY (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public ORD_O04_TIMING_TRAY getTIMING_TRAY(int rep) { 
       ORD_O04_TIMING_TRAY ret = null;
       try {
          ret = (ORD_O04_TIMING_TRAY)this.get("TIMING_TRAY", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of TIMING_TRAY 
     */ 
    public int getTIMING_TRAYReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("TIMING_TRAY").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of TIMING_TRAY (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertTIMING_TRAY(ORD_O04_TIMING_TRAY structure, int rep) throws HL7Exception { 
       super.insertRepetition("TIMING_TRAY", structure, rep);
    }


    /**
     * Inserts a specific repetition of TIMING_TRAY (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public ORD_O04_TIMING_TRAY insertTIMING_TRAY(int rep) throws HL7Exception { 
       return (ORD_O04_TIMING_TRAY)super.insertRepetition("TIMING_TRAY", rep);
    }


    /**
     * Removes a specific repetition of TIMING_TRAY (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public ORD_O04_TIMING_TRAY removeTIMING_TRAY(int rep) throws HL7Exception { 
       return (ORD_O04_TIMING_TRAY)super.removeRepetition("TIMING_TRAY", rep);
    }



    /**
     * Returns
     * the first repetition of 
     * ODT (Diet Tray Instructions) - creates it if necessary
     */
    public ODT getODT() { 
       ODT ret = null;
       try {
          ret = (ODT)this.get("ODT");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * ODT (Diet Tray Instructions) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public ODT getODT(int rep) { 
       ODT ret = null;
       try {
          ret = (ODT)this.get("ODT", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of ODT 
     */ 
    public int getODTReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("ODT").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of ODT (Diet Tray Instructions)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertODT(ODT structure, int rep) throws HL7Exception { 
       super.insertRepetition("ODT", structure, rep);
    }


    /**
     * Inserts a specific repetition of ODT (Diet Tray Instructions)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public ODT insertODT(int rep) throws HL7Exception { 
       return (ODT)super.insertRepetition("ODT", rep);
    }


    /**
     * Removes a specific repetition of ODT (Diet Tray Instructions)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public ODT removeODT(int rep) throws HL7Exception { 
       return (ODT)super.removeRepetition("ODT", rep);
    }



    /**
     * Returns
     * the first repetition of 
     * NTE (Notes and Comments) - creates it if necessary
     */
    public NTE getNTE() { 
       NTE ret = null;
       try {
          ret = (NTE)this.get("NTE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * NTE (Notes and Comments) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public NTE getNTE(int rep) { 
       NTE ret = null;
       try {
          ret = (NTE)this.get("NTE", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of NTE 
     */ 
    public int getNTEReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("NTE").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of NTE (Notes and Comments)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertNTE(NTE structure, int rep) throws HL7Exception { 
       super.insertRepetition("NTE", structure, rep);
    }


    /**
     * Inserts a specific repetition of NTE (Notes and Comments)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public NTE insertNTE(int rep) throws HL7Exception { 
       return (NTE)super.insertRepetition("NTE", rep);
    }


    /**
     * Removes a specific repetition of NTE (Notes and Comments)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public NTE removeNTE(int rep) throws HL7Exception { 
       return (NTE)super.removeRepetition("NTE", rep);
    }



}

