/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v26.segment;

// import ca.uhn.hl7v2.model.v26.group.*;
import ca.uhn.hl7v2.model.v26.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 ADJ message segment (Adjustment). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>ADJ-1: Provider Adjustment Number (EI) <b> </b>
     * <li>ADJ-2: Payer Adjustment Number (EI) <b> </b>
     * <li>ADJ-3: Adjustment Sequence Number (SI) <b> </b>
     * <li>ADJ-4: Adjustment Category (IS) <b> </b>
     * <li>ADJ-5: Adjustment Amount (CP) <b>optional </b>
     * <li>ADJ-6: Adjustment Quantity (CQ) <b>optional </b>
     * <li>ADJ-7: Adjustment Reason PA (CWE) <b>optional </b>
     * <li>ADJ-8: Adjustment Description (ST) <b>optional </b>
     * <li>ADJ-9: Original Value (NM) <b>optional </b>
     * <li>ADJ-10: Substitute Value (NM) <b>optional </b>
     * <li>ADJ-11: Adjustment Action (IS) <b>optional </b>
     * <li>ADJ-12: Provider Adjustment Number Cross Reference (EI) <b>optional </b>
     * <li>ADJ-13: Provider Product/Service Line Item Number Cross Reference (EI) <b>optional </b>
     * <li>ADJ-14: Adjustment Date (DTM) <b> </b>
     * <li>ADJ-15: Responsible Organization (XON) <b>optional </b>
 * </ul>
 */
public class ADJ extends AbstractSegment {

    /** 
     * Creates a new ADJ segment
     */
    public ADJ(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(EI.class, true, 1, 73, new Object[]{ getMessage(), new Integer(0) }, "Provider Adjustment Number");
                                  this.add(EI.class, true, 1, 73, new Object[]{ getMessage(), new Integer(0) }, "Payer Adjustment Number");
                                  this.add(SI.class, true, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "Adjustment Sequence Number");
                                  this.add(IS.class, true, 1, 4, new Object[]{ getMessage() }, "Adjustment Category");
                                  this.add(CP.class, false, 1, 254, new Object[]{ getMessage(), new Integer(0) }, "Adjustment Amount");
                                  this.add(CQ.class, false, 1, 222, new Object[]{ getMessage(), new Integer(560) }, "Adjustment Quantity");
                                  this.add(CWE.class, false, 1, 211, new Object[]{ getMessage(), new Integer(565) }, "Adjustment Reason PA");
                                  this.add(ST.class, false, 1, 250, new Object[]{ getMessage(), new Integer(0) }, "Adjustment Description");
                                  this.add(NM.class, false, 1, 250, new Object[]{ getMessage(), new Integer(0) }, "Original Value");
                                  this.add(NM.class, false, 1, 250, new Object[]{ getMessage(), new Integer(0) }, "Substitute Value");
                                  this.add(IS.class, false, 1, 4, new Object[]{ getMessage() }, "Adjustment Action");
                                  this.add(EI.class, false, 1, 73, new Object[]{ getMessage(), new Integer(0) }, "Provider Adjustment Number Cross Reference");
                                  this.add(EI.class, false, 1, 73, new Object[]{ getMessage(), new Integer(0) }, "Provider Product/Service Line Item Number Cross Reference");
                                  this.add(DTM.class, true, 1, 26, new Object[]{ getMessage(), new Integer(0) }, "Adjustment Date");
                                  this.add(XON.class, false, 1, 183, new Object[]{ getMessage(), new Integer(0) }, "Responsible Organization");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating ADJ - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * ADJ-1: "Provider Adjustment Number" - creates it if necessary
     */
    public EI getProviderAdjustmentNumber() { 
        EI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ADJ-1: "Provider Adjustment Number" - creates it if necessary
     */
    public EI getAdj1_ProviderAdjustmentNumber() { 
        EI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * ADJ-2: "Payer Adjustment Number" - creates it if necessary
     */
    public EI getPayerAdjustmentNumber() { 
        EI ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ADJ-2: "Payer Adjustment Number" - creates it if necessary
     */
    public EI getAdj2_PayerAdjustmentNumber() { 
        EI ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * ADJ-3: "Adjustment Sequence Number" - creates it if necessary
     */
    public SI getAdjustmentSequenceNumber() { 
        SI ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ADJ-3: "Adjustment Sequence Number" - creates it if necessary
     */
    public SI getAdj3_AdjustmentSequenceNumber() { 
        SI ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * ADJ-4: "Adjustment Category" - creates it if necessary
     */
    public IS getAdjustmentCategory() { 
        IS ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ADJ-4: "Adjustment Category" - creates it if necessary
     */
    public IS getAdj4_AdjustmentCategory() { 
        IS ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * ADJ-5: "Adjustment Amount" - creates it if necessary
     */
    public CP getAdjustmentAmount() { 
        CP ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ADJ-5: "Adjustment Amount" - creates it if necessary
     */
    public CP getAdj5_AdjustmentAmount() { 
        CP ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * ADJ-6: "Adjustment Quantity" - creates it if necessary
     */
    public CQ getAdjustmentQuantity() { 
        CQ ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (CQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ADJ-6: "Adjustment Quantity" - creates it if necessary
     */
    public CQ getAdj6_AdjustmentQuantity() { 
        CQ ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (CQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * ADJ-7: "Adjustment Reason PA" - creates it if necessary
     */
    public CWE getAdjustmentReasonPA() { 
        CWE ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ADJ-7: "Adjustment Reason PA" - creates it if necessary
     */
    public CWE getAdj7_AdjustmentReasonPA() { 
        CWE ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * ADJ-8: "Adjustment Description" - creates it if necessary
     */
    public ST getAdjustmentDescription() { 
        ST ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ADJ-8: "Adjustment Description" - creates it if necessary
     */
    public ST getAdj8_AdjustmentDescription() { 
        ST ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * ADJ-9: "Original Value" - creates it if necessary
     */
    public NM getOriginalValue() { 
        NM ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ADJ-9: "Original Value" - creates it if necessary
     */
    public NM getAdj9_OriginalValue() { 
        NM ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * ADJ-10: "Substitute Value" - creates it if necessary
     */
    public NM getSubstituteValue() { 
        NM ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ADJ-10: "Substitute Value" - creates it if necessary
     */
    public NM getAdj10_SubstituteValue() { 
        NM ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * ADJ-11: "Adjustment Action" - creates it if necessary
     */
    public IS getAdjustmentAction() { 
        IS ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ADJ-11: "Adjustment Action" - creates it if necessary
     */
    public IS getAdj11_AdjustmentAction() { 
        IS ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * ADJ-12: "Provider Adjustment Number Cross Reference" - creates it if necessary
     */
    public EI getProviderAdjustmentNumberCrossReference() { 
        EI ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ADJ-12: "Provider Adjustment Number Cross Reference" - creates it if necessary
     */
    public EI getAdj12_ProviderAdjustmentNumberCrossReference() { 
        EI ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * ADJ-13: "Provider Product/Service Line Item Number Cross Reference" - creates it if necessary
     */
    public EI getProviderProductServiceLineItemNumberCrossReference() { 
        EI ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ADJ-13: "Provider Product/Service Line Item Number Cross Reference" - creates it if necessary
     */
    public EI getAdj13_ProviderProductServiceLineItemNumberCrossReference() { 
        EI ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * ADJ-14: "Adjustment Date" - creates it if necessary
     */
    public DTM getAdjustmentDate() { 
        DTM ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ADJ-14: "Adjustment Date" - creates it if necessary
     */
    public DTM getAdj14_AdjustmentDate() { 
        DTM ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * ADJ-15: "Responsible Organization" - creates it if necessary
     */
    public XON getResponsibleOrganization() { 
        XON ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (XON)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ADJ-15: "Responsible Organization" - creates it if necessary
     */
    public XON getAdj15_ResponsibleOrganization() { 
        XON ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (XON)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new EI(getMessage());
          case 1: return new EI(getMessage());
          case 2: return new SI(getMessage());
          case 3: return new IS(getMessage(), new Integer( 564 ));
          case 4: return new CP(getMessage());
          case 5: return new CQ(getMessage());
          case 6: return new CWE(getMessage());
          case 7: return new ST(getMessage());
          case 8: return new NM(getMessage());
          case 9: return new NM(getMessage());
          case 10: return new IS(getMessage(), new Integer( 569 ));
          case 11: return new EI(getMessage());
          case 12: return new EI(getMessage());
          case 13: return new DTM(getMessage());
          case 14: return new XON(getMessage());
          default: return null;
       }
   }


}

