/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v26.segment;

// import ca.uhn.hl7v2.model.v26.group.*;
import ca.uhn.hl7v2.model.v26.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 BTX message segment (Blood Product Transfusion/Disposition). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>BTX-1: Set ID - BTX (SI) <b> </b>
     * <li>BTX-2: BC Donation ID (EI) <b>optional </b>
     * <li>BTX-3: BC Component (CNE) <b>optional </b>
     * <li>BTX-4: BC Blood Group (CNE) <b>optional </b>
     * <li>BTX-5: CP Commercial Product (CWE) <b>optional </b>
     * <li>BTX-6: CP Manufacturer (XON) <b>optional </b>
     * <li>BTX-7: CP Lot Number (EI) <b>optional </b>
     * <li>BTX-8: BP Quantity (NM) <b> </b>
     * <li>BTX-9: BP Amount (NM) <b>optional </b>
     * <li>BTX-10: BP Units (CWE) <b>optional </b>
     * <li>BTX-11: BP Transfusion/Disposition Status (CWE) <b> </b>
     * <li>BTX-12: BP Message Status (ID) <b> </b>
     * <li>BTX-13: BP Date/Time of Status (DTM) <b> </b>
     * <li>BTX-14: BP Transfusion Administrator (XCN) <b>optional </b>
     * <li>BTX-15: BP Transfusion Verifier (XCN) <b>optional </b>
     * <li>BTX-16: BP Transfusion Start Date/Time of Status (DTM) <b>optional </b>
     * <li>BTX-17: BP Transfusion End Date/Time of Status (DTM) <b>optional </b>
     * <li>BTX-18: BP Adverse Reaction Type (CWE) <b>optional repeating</b>
     * <li>BTX-19: BP Transfusion Interrupted Reason (CWE) <b>optional </b>
 * </ul>
 */
public class BTX extends AbstractSegment {

    /** 
     * Creates a new BTX segment
     */
    public BTX(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(SI.class, true, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "Set ID - BTX");
                                  this.add(EI.class, false, 1, 22, new Object[]{ getMessage(), new Integer(0) }, "BC Donation ID");
                                  this.add(CNE.class, false, 1, 250, new Object[]{ getMessage(), new Integer(9999) }, "BC Component");
                                  this.add(CNE.class, false, 1, 250, new Object[]{ getMessage(), new Integer(9999) }, "BC Blood Group");
                                  this.add(CWE.class, false, 1, 250, new Object[]{ getMessage(), new Integer(512) }, "CP Commercial Product");
                                  this.add(XON.class, false, 1, 250, new Object[]{ getMessage(), new Integer(0) }, "CP Manufacturer");
                                  this.add(EI.class, false, 1, 22, new Object[]{ getMessage(), new Integer(0) }, "CP Lot Number");
                                  this.add(NM.class, true, 1, 5, new Object[]{ getMessage(), new Integer(0) }, "BP Quantity");
                                  this.add(NM.class, false, 1, 5, new Object[]{ getMessage(), new Integer(0) }, "BP Amount");
                                  this.add(CWE.class, false, 1, 250, new Object[]{ getMessage(), new Integer(9999) }, "BP Units");
                                  this.add(CWE.class, true, 1, 250, new Object[]{ getMessage(), new Integer(513) }, "BP Transfusion/Disposition Status");
                                  this.add(ID.class, true, 1, 1, new Object[]{ getMessage() }, "BP Message Status");
                                  this.add(DTM.class, true, 1, 24, new Object[]{ getMessage(), new Integer(0) }, "BP Date/Time of Status");
                                  this.add(XCN.class, false, 1, 250, new Object[]{ getMessage(), new Integer(0) }, "BP Transfusion Administrator");
                                  this.add(XCN.class, false, 1, 250, new Object[]{ getMessage(), new Integer(0) }, "BP Transfusion Verifier");
                                  this.add(DTM.class, false, 1, 24, new Object[]{ getMessage(), new Integer(0) }, "BP Transfusion Start Date/Time of Status");
                                  this.add(DTM.class, false, 1, 24, new Object[]{ getMessage(), new Integer(0) }, "BP Transfusion End Date/Time of Status");
                                  this.add(CWE.class, false, 0, 250, new Object[]{ getMessage(), new Integer(514) }, "BP Adverse Reaction Type");
                                  this.add(CWE.class, false, 1, 250, new Object[]{ getMessage(), new Integer(515) }, "BP Transfusion Interrupted Reason");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating BTX - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * BTX-1: "Set ID - BTX" - creates it if necessary
     */
    public SI getSetIDBTX() { 
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * BTX-1: "Set ID - BTX" - creates it if necessary
     */
    public SI getBtx1_SetIDBTX() { 
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * BTX-2: "BC Donation ID" - creates it if necessary
     */
    public EI getBCDonationID() { 
        EI ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * BTX-2: "BC Donation ID" - creates it if necessary
     */
    public EI getBtx2_BCDonationID() { 
        EI ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * BTX-3: "BC Component" - creates it if necessary
     */
    public CNE getBCComponent() { 
        CNE ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * BTX-3: "BC Component" - creates it if necessary
     */
    public CNE getBtx3_BCComponent() { 
        CNE ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * BTX-4: "BC Blood Group" - creates it if necessary
     */
    public CNE getBCBloodGroup() { 
        CNE ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * BTX-4: "BC Blood Group" - creates it if necessary
     */
    public CNE getBtx4_BCBloodGroup() { 
        CNE ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * BTX-5: "CP Commercial Product" - creates it if necessary
     */
    public CWE getCPCommercialProduct() { 
        CWE ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * BTX-5: "CP Commercial Product" - creates it if necessary
     */
    public CWE getBtx5_CPCommercialProduct() { 
        CWE ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * BTX-6: "CP Manufacturer" - creates it if necessary
     */
    public XON getCPManufacturer() { 
        XON ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (XON)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * BTX-6: "CP Manufacturer" - creates it if necessary
     */
    public XON getBtx6_CPManufacturer() { 
        XON ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (XON)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * BTX-7: "CP Lot Number" - creates it if necessary
     */
    public EI getCPLotNumber() { 
        EI ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * BTX-7: "CP Lot Number" - creates it if necessary
     */
    public EI getBtx7_CPLotNumber() { 
        EI ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * BTX-8: "BP Quantity" - creates it if necessary
     */
    public NM getBPQuantity() { 
        NM ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * BTX-8: "BP Quantity" - creates it if necessary
     */
    public NM getBtx8_BPQuantity() { 
        NM ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * BTX-9: "BP Amount" - creates it if necessary
     */
    public NM getBPAmount() { 
        NM ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * BTX-9: "BP Amount" - creates it if necessary
     */
    public NM getBtx9_BPAmount() { 
        NM ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * BTX-10: "BP Units" - creates it if necessary
     */
    public CWE getBPUnits() { 
        CWE ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * BTX-10: "BP Units" - creates it if necessary
     */
    public CWE getBtx10_BPUnits() { 
        CWE ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * BTX-11: "BP Transfusion/Disposition Status" - creates it if necessary
     */
    public CWE getBPTransfusionDispositionStatus() { 
        CWE ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * BTX-11: "BP Transfusion/Disposition Status" - creates it if necessary
     */
    public CWE getBtx11_BPTransfusionDispositionStatus() { 
        CWE ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * BTX-12: "BP Message Status" - creates it if necessary
     */
    public ID getBPMessageStatus() { 
        ID ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * BTX-12: "BP Message Status" - creates it if necessary
     */
    public ID getBtx12_BPMessageStatus() { 
        ID ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * BTX-13: "BP Date/Time of Status" - creates it if necessary
     */
    public DTM getBPDateTimeOfStatus() { 
        DTM ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * BTX-13: "BP Date/Time of Status" - creates it if necessary
     */
    public DTM getBtx13_BPDateTimeOfStatus() { 
        DTM ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * BTX-14: "BP Transfusion Administrator" - creates it if necessary
     */
    public XCN getBPTransfusionAdministrator() { 
        XCN ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (XCN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * BTX-14: "BP Transfusion Administrator" - creates it if necessary
     */
    public XCN getBtx14_BPTransfusionAdministrator() { 
        XCN ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (XCN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * BTX-15: "BP Transfusion Verifier" - creates it if necessary
     */
    public XCN getBPTransfusionVerifier() { 
        XCN ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (XCN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * BTX-15: "BP Transfusion Verifier" - creates it if necessary
     */
    public XCN getBtx15_BPTransfusionVerifier() { 
        XCN ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (XCN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * BTX-16: "BP Transfusion Start Date/Time of Status" - creates it if necessary
     */
    public DTM getBPTransfusionStartDateTimeOfStatus() { 
        DTM ret = null;
        try {
            Type t = this.getField(16, 0);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * BTX-16: "BP Transfusion Start Date/Time of Status" - creates it if necessary
     */
    public DTM getBtx16_BPTransfusionStartDateTimeOfStatus() { 
        DTM ret = null;
        try {
            Type t = this.getField(16, 0);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * BTX-17: "BP Transfusion End Date/Time of Status" - creates it if necessary
     */
    public DTM getBPTransfusionEndDateTimeOfStatus() { 
        DTM ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * BTX-17: "BP Transfusion End Date/Time of Status" - creates it if necessary
     */
    public DTM getBtx17_BPTransfusionEndDateTimeOfStatus() { 
        DTM ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of BP Adverse Reaction Type (BTX-18).
     */
    public CWE[] getBPAdverseReactionType() {
        CWE[] ret = null;
        try {
            Type[] t = this.getField(18);  
            ret = new CWE[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CWE)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * BTX-18: "BP Adverse Reaction Type" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CWE getBPAdverseReactionType(int rep) { 
        CWE ret = null;
        try {
            Type t = this.getField(18, rep);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * BTX-18: "BP Adverse Reaction Type" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CWE getBtx18_BPAdverseReactionType(int rep) { 
        CWE ret = null;
        try {
            Type t = this.getField(18, rep);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * BTX-18: "BP Adverse Reaction Type" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE insertBPAdverseReactionType(int rep) throws HL7Exception { 
        return (CWE) super.insertRepetition(18, rep);
    }



    /**
     * Inserts a repetition of
     * BTX-18: "BP Adverse Reaction Type" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE insertBtx18_BPAdverseReactionType(int rep) throws HL7Exception { 
        return (CWE) super.insertRepetition(18, rep);
    }


    /**
     * Removes a repetition of
     * BTX-18: "BP Adverse Reaction Type" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE removeBPAdverseReactionType(int rep) throws HL7Exception { 
        return (CWE) super.removeRepetition(18, rep);
    }


    /**
     * Removes a repetition of
     * BTX-18: "BP Adverse Reaction Type" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE removeBtx18_BPAdverseReactionType(int rep) throws HL7Exception { 
        return (CWE) super.removeRepetition(18, rep);
    }




    /**
     * Returns
     * BTX-19: "BP Transfusion Interrupted Reason" - creates it if necessary
     */
    public CWE getBPTransfusionInterruptedReason() { 
        CWE ret = null;
        try {
            Type t = this.getField(19, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * BTX-19: "BP Transfusion Interrupted Reason" - creates it if necessary
     */
    public CWE getBtx19_BPTransfusionInterruptedReason() { 
        CWE ret = null;
        try {
            Type t = this.getField(19, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new SI(getMessage());
          case 1: return new EI(getMessage());
          case 2: return new CNE(getMessage());
          case 3: return new CNE(getMessage());
          case 4: return new CWE(getMessage());
          case 5: return new XON(getMessage());
          case 6: return new EI(getMessage());
          case 7: return new NM(getMessage());
          case 8: return new NM(getMessage());
          case 9: return new CWE(getMessage());
          case 10: return new CWE(getMessage());
          case 11: return new ID(getMessage(), new Integer( 511 ));
          case 12: return new DTM(getMessage());
          case 13: return new XCN(getMessage());
          case 14: return new XCN(getMessage());
          case 15: return new DTM(getMessage());
          case 16: return new DTM(getMessage());
          case 17: return new CWE(getMessage());
          case 18: return new CWE(getMessage());
          default: return null;
       }
   }


}

