/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v26.segment;

// import ca.uhn.hl7v2.model.v26.group.*;
import ca.uhn.hl7v2.model.v26.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 CSR message segment (Clinical Study Registration). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>CSR-1: Sponsor Study ID (EI) <b> </b>
     * <li>CSR-2: Alternate Study ID (EI) <b>optional </b>
     * <li>CSR-3: Institution Registering the Patient (CWE) <b>optional </b>
     * <li>CSR-4: Sponsor Patient ID (CX) <b> </b>
     * <li>CSR-5: Alternate Patient ID - CSR (CX) <b>optional </b>
     * <li>CSR-6: Date/Time of Patient Study Registration (DTM) <b> </b>
     * <li>CSR-7: Person Performing Study Registration (XCN) <b>optional repeating</b>
     * <li>CSR-8: Study Authorizing Provider (XCN) <b> repeating</b>
     * <li>CSR-9: Date/time Patient Study Consent Signed (DTM) <b>optional </b>
     * <li>CSR-10: Patient Study Eligibility Status (CWE) <b>optional </b>
     * <li>CSR-11: Study Randomization Date/time (DTM) <b>optional repeating</b>
     * <li>CSR-12: Randomized Study Arm (CWE) <b>optional repeating</b>
     * <li>CSR-13: Stratum for Study Randomization (CWE) <b>optional repeating</b>
     * <li>CSR-14: Patient Evaluability Status (CWE) <b>optional </b>
     * <li>CSR-15: Date/time Ended Study (DTM) <b>optional </b>
     * <li>CSR-16: Reason Ended Study (CWE) <b>optional </b>
 * </ul>
 */
public class CSR extends AbstractSegment {

    /** 
     * Creates a new CSR segment
     */
    public CSR(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(EI.class, true, 1, 427, new Object[]{ getMessage(), new Integer(0) }, "Sponsor Study ID");
                                  this.add(EI.class, false, 1, 427, new Object[]{ getMessage(), new Integer(0) }, "Alternate Study ID");
                                  this.add(CWE.class, false, 1, 705, new Object[]{ getMessage(), new Integer(9999) }, "Institution Registering the Patient");
                                  this.add(CX.class, true, 1, 1913, new Object[]{ getMessage(), new Integer(0) }, "Sponsor Patient ID");
                                  this.add(CX.class, false, 1, 1913, new Object[]{ getMessage(), new Integer(0) }, "Alternate Patient ID - CSR");
                                  this.add(DTM.class, true, 1, 24, new Object[]{ getMessage(), new Integer(0) }, "Date/Time of Patient Study Registration");
                                  this.add(XCN.class, false, 0, 3220, new Object[]{ getMessage(), new Integer(0) }, "Person Performing Study Registration");
                                  this.add(XCN.class, true, 0, 3220, new Object[]{ getMessage(), new Integer(0) }, "Study Authorizing Provider");
                                  this.add(DTM.class, false, 1, 24, new Object[]{ getMessage(), new Integer(0) }, "Date/time Patient Study Consent Signed");
                                  this.add(CWE.class, false, 1, 705, new Object[]{ getMessage(), new Integer(9999) }, "Patient Study Eligibility Status");
                                  this.add(DTM.class, false, 3, 24, new Object[]{ getMessage(), new Integer(0) }, "Study Randomization Date/time");
                                  this.add(CWE.class, false, 3, 705, new Object[]{ getMessage(), new Integer(9999) }, "Randomized Study Arm");
                                  this.add(CWE.class, false, 3, 705, new Object[]{ getMessage(), new Integer(9999) }, "Stratum for Study Randomization");
                                  this.add(CWE.class, false, 1, 705, new Object[]{ getMessage(), new Integer(9999) }, "Patient Evaluability Status");
                                  this.add(DTM.class, false, 1, 24, new Object[]{ getMessage(), new Integer(0) }, "Date/time Ended Study");
                                  this.add(CWE.class, false, 1, 705, new Object[]{ getMessage(), new Integer(9999) }, "Reason Ended Study");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating CSR - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * CSR-1: "Sponsor Study ID" - creates it if necessary
     */
    public EI getSponsorStudyID() { 
        EI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * CSR-1: "Sponsor Study ID" - creates it if necessary
     */
    public EI getCsr1_SponsorStudyID() { 
        EI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * CSR-2: "Alternate Study ID" - creates it if necessary
     */
    public EI getAlternateStudyID() { 
        EI ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * CSR-2: "Alternate Study ID" - creates it if necessary
     */
    public EI getCsr2_AlternateStudyID() { 
        EI ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * CSR-3: "Institution Registering the Patient" - creates it if necessary
     */
    public CWE getInstitutionRegisteringThePatient() { 
        CWE ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * CSR-3: "Institution Registering the Patient" - creates it if necessary
     */
    public CWE getCsr3_InstitutionRegisteringThePatient() { 
        CWE ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * CSR-4: "Sponsor Patient ID" - creates it if necessary
     */
    public CX getSponsorPatientID() { 
        CX ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (CX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * CSR-4: "Sponsor Patient ID" - creates it if necessary
     */
    public CX getCsr4_SponsorPatientID() { 
        CX ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (CX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * CSR-5: "Alternate Patient ID - CSR" - creates it if necessary
     */
    public CX getAlternatePatientIDCSR() { 
        CX ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (CX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * CSR-5: "Alternate Patient ID - CSR" - creates it if necessary
     */
    public CX getCsr5_AlternatePatientIDCSR() { 
        CX ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (CX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * CSR-6: "Date/Time of Patient Study Registration" - creates it if necessary
     */
    public DTM getDateTimeOfPatientStudyRegistration() { 
        DTM ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * CSR-6: "Date/Time of Patient Study Registration" - creates it if necessary
     */
    public DTM getCsr6_DateTimeOfPatientStudyRegistration() { 
        DTM ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Person Performing Study Registration (CSR-7).
     */
    public XCN[] getPersonPerformingStudyRegistration() {
        XCN[] ret = null;
        try {
            Type[] t = this.getField(7);  
            ret = new XCN[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (XCN)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * CSR-7: "Person Performing Study Registration" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XCN getPersonPerformingStudyRegistration(int rep) { 
        XCN ret = null;
        try {
            Type t = this.getField(7, rep);
            ret = (XCN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * CSR-7: "Person Performing Study Registration" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XCN getCsr7_PersonPerformingStudyRegistration(int rep) { 
        XCN ret = null;
        try {
            Type t = this.getField(7, rep);
            ret = (XCN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * CSR-7: "Person Performing Study Registration" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XCN insertPersonPerformingStudyRegistration(int rep) throws HL7Exception { 
        return (XCN) super.insertRepetition(7, rep);
    }



    /**
     * Inserts a repetition of
     * CSR-7: "Person Performing Study Registration" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XCN insertCsr7_PersonPerformingStudyRegistration(int rep) throws HL7Exception { 
        return (XCN) super.insertRepetition(7, rep);
    }


    /**
     * Removes a repetition of
     * CSR-7: "Person Performing Study Registration" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XCN removePersonPerformingStudyRegistration(int rep) throws HL7Exception { 
        return (XCN) super.removeRepetition(7, rep);
    }


    /**
     * Removes a repetition of
     * CSR-7: "Person Performing Study Registration" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XCN removeCsr7_PersonPerformingStudyRegistration(int rep) throws HL7Exception { 
        return (XCN) super.removeRepetition(7, rep);
    }



    /**
     * Returns all repetitions of Study Authorizing Provider (CSR-8).
     */
    public XCN[] getStudyAuthorizingProvider() {
        XCN[] ret = null;
        try {
            Type[] t = this.getField(8);  
            ret = new XCN[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (XCN)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * CSR-8: "Study Authorizing Provider" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XCN getStudyAuthorizingProvider(int rep) { 
        XCN ret = null;
        try {
            Type t = this.getField(8, rep);
            ret = (XCN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * CSR-8: "Study Authorizing Provider" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XCN getCsr8_StudyAuthorizingProvider(int rep) { 
        XCN ret = null;
        try {
            Type t = this.getField(8, rep);
            ret = (XCN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * CSR-8: "Study Authorizing Provider" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XCN insertStudyAuthorizingProvider(int rep) throws HL7Exception { 
        return (XCN) super.insertRepetition(8, rep);
    }



    /**
     * Inserts a repetition of
     * CSR-8: "Study Authorizing Provider" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XCN insertCsr8_StudyAuthorizingProvider(int rep) throws HL7Exception { 
        return (XCN) super.insertRepetition(8, rep);
    }


    /**
     * Removes a repetition of
     * CSR-8: "Study Authorizing Provider" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XCN removeStudyAuthorizingProvider(int rep) throws HL7Exception { 
        return (XCN) super.removeRepetition(8, rep);
    }


    /**
     * Removes a repetition of
     * CSR-8: "Study Authorizing Provider" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XCN removeCsr8_StudyAuthorizingProvider(int rep) throws HL7Exception { 
        return (XCN) super.removeRepetition(8, rep);
    }




    /**
     * Returns
     * CSR-9: "Date/time Patient Study Consent Signed" - creates it if necessary
     */
    public DTM getDateTimePatientStudyConsentSigned() { 
        DTM ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * CSR-9: "Date/time Patient Study Consent Signed" - creates it if necessary
     */
    public DTM getCsr9_DateTimePatientStudyConsentSigned() { 
        DTM ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * CSR-10: "Patient Study Eligibility Status" - creates it if necessary
     */
    public CWE getPatientStudyEligibilityStatus() { 
        CWE ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * CSR-10: "Patient Study Eligibility Status" - creates it if necessary
     */
    public CWE getCsr10_PatientStudyEligibilityStatus() { 
        CWE ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Study Randomization Date/time (CSR-11).
     */
    public DTM[] getStudyRandomizationDateTime() {
        DTM[] ret = null;
        try {
            Type[] t = this.getField(11);  
            ret = new DTM[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (DTM)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * CSR-11: "Study Randomization Date/time" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public DTM getStudyRandomizationDateTime(int rep) { 
        DTM ret = null;
        try {
            Type t = this.getField(11, rep);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * CSR-11: "Study Randomization Date/time" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public DTM getCsr11_StudyRandomizationDateTime(int rep) { 
        DTM ret = null;
        try {
            Type t = this.getField(11, rep);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * CSR-11: "Study Randomization Date/time" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public DTM insertStudyRandomizationDateTime(int rep) throws HL7Exception { 
        return (DTM) super.insertRepetition(11, rep);
    }



    /**
     * Inserts a repetition of
     * CSR-11: "Study Randomization Date/time" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public DTM insertCsr11_StudyRandomizationDateTime(int rep) throws HL7Exception { 
        return (DTM) super.insertRepetition(11, rep);
    }


    /**
     * Removes a repetition of
     * CSR-11: "Study Randomization Date/time" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public DTM removeStudyRandomizationDateTime(int rep) throws HL7Exception { 
        return (DTM) super.removeRepetition(11, rep);
    }


    /**
     * Removes a repetition of
     * CSR-11: "Study Randomization Date/time" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public DTM removeCsr11_StudyRandomizationDateTime(int rep) throws HL7Exception { 
        return (DTM) super.removeRepetition(11, rep);
    }



    /**
     * Returns all repetitions of Randomized Study Arm (CSR-12).
     */
    public CWE[] getRandomizedStudyArm() {
        CWE[] ret = null;
        try {
            Type[] t = this.getField(12);  
            ret = new CWE[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CWE)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * CSR-12: "Randomized Study Arm" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CWE getRandomizedStudyArm(int rep) { 
        CWE ret = null;
        try {
            Type t = this.getField(12, rep);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * CSR-12: "Randomized Study Arm" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CWE getCsr12_RandomizedStudyArm(int rep) { 
        CWE ret = null;
        try {
            Type t = this.getField(12, rep);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * CSR-12: "Randomized Study Arm" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE insertRandomizedStudyArm(int rep) throws HL7Exception { 
        return (CWE) super.insertRepetition(12, rep);
    }



    /**
     * Inserts a repetition of
     * CSR-12: "Randomized Study Arm" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE insertCsr12_RandomizedStudyArm(int rep) throws HL7Exception { 
        return (CWE) super.insertRepetition(12, rep);
    }


    /**
     * Removes a repetition of
     * CSR-12: "Randomized Study Arm" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE removeRandomizedStudyArm(int rep) throws HL7Exception { 
        return (CWE) super.removeRepetition(12, rep);
    }


    /**
     * Removes a repetition of
     * CSR-12: "Randomized Study Arm" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE removeCsr12_RandomizedStudyArm(int rep) throws HL7Exception { 
        return (CWE) super.removeRepetition(12, rep);
    }



    /**
     * Returns all repetitions of Stratum for Study Randomization (CSR-13).
     */
    public CWE[] getStratumForStudyRandomization() {
        CWE[] ret = null;
        try {
            Type[] t = this.getField(13);  
            ret = new CWE[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CWE)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * CSR-13: "Stratum for Study Randomization" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CWE getStratumForStudyRandomization(int rep) { 
        CWE ret = null;
        try {
            Type t = this.getField(13, rep);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * CSR-13: "Stratum for Study Randomization" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CWE getCsr13_StratumForStudyRandomization(int rep) { 
        CWE ret = null;
        try {
            Type t = this.getField(13, rep);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * CSR-13: "Stratum for Study Randomization" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE insertStratumForStudyRandomization(int rep) throws HL7Exception { 
        return (CWE) super.insertRepetition(13, rep);
    }



    /**
     * Inserts a repetition of
     * CSR-13: "Stratum for Study Randomization" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE insertCsr13_StratumForStudyRandomization(int rep) throws HL7Exception { 
        return (CWE) super.insertRepetition(13, rep);
    }


    /**
     * Removes a repetition of
     * CSR-13: "Stratum for Study Randomization" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE removeStratumForStudyRandomization(int rep) throws HL7Exception { 
        return (CWE) super.removeRepetition(13, rep);
    }


    /**
     * Removes a repetition of
     * CSR-13: "Stratum for Study Randomization" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE removeCsr13_StratumForStudyRandomization(int rep) throws HL7Exception { 
        return (CWE) super.removeRepetition(13, rep);
    }




    /**
     * Returns
     * CSR-14: "Patient Evaluability Status" - creates it if necessary
     */
    public CWE getPatientEvaluabilityStatus() { 
        CWE ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * CSR-14: "Patient Evaluability Status" - creates it if necessary
     */
    public CWE getCsr14_PatientEvaluabilityStatus() { 
        CWE ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * CSR-15: "Date/time Ended Study" - creates it if necessary
     */
    public DTM getDateTimeEndedStudy() { 
        DTM ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * CSR-15: "Date/time Ended Study" - creates it if necessary
     */
    public DTM getCsr15_DateTimeEndedStudy() { 
        DTM ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * CSR-16: "Reason Ended Study" - creates it if necessary
     */
    public CWE getReasonEndedStudy() { 
        CWE ret = null;
        try {
            Type t = this.getField(16, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * CSR-16: "Reason Ended Study" - creates it if necessary
     */
    public CWE getCsr16_ReasonEndedStudy() { 
        CWE ret = null;
        try {
            Type t = this.getField(16, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new EI(getMessage());
          case 1: return new EI(getMessage());
          case 2: return new CWE(getMessage());
          case 3: return new CX(getMessage());
          case 4: return new CX(getMessage());
          case 5: return new DTM(getMessage());
          case 6: return new XCN(getMessage());
          case 7: return new XCN(getMessage());
          case 8: return new DTM(getMessage());
          case 9: return new CWE(getMessage());
          case 10: return new DTM(getMessage());
          case 11: return new CWE(getMessage());
          case 12: return new CWE(getMessage());
          case 13: return new CWE(getMessage());
          case 14: return new DTM(getMessage());
          case 15: return new CWE(getMessage());
          default: return null;
       }
   }


}

