/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v26.segment;

// import ca.uhn.hl7v2.model.v26.group.*;
import ca.uhn.hl7v2.model.v26.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 CSS message segment (Clinical Study Data Schedule Segment). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>CSS-1: Study Scheduled Time Point (CWE) <b> </b>
     * <li>CSS-2: Study Scheduled Patient Time Point (DTM) <b>optional </b>
     * <li>CSS-3: Study Quality Control Codes (CWE) <b>optional repeating</b>
 * </ul>
 */
public class CSS extends AbstractSegment {

    /** 
     * Creates a new CSS segment
     */
    public CSS(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(CWE.class, true, 1, 705, new Object[]{ getMessage(), new Integer(9999) }, "Study Scheduled Time Point");
                                  this.add(DTM.class, false, 1, 24, new Object[]{ getMessage(), new Integer(0) }, "Study Scheduled Patient Time Point");
                                  this.add(CWE.class, false, 3, 705, new Object[]{ getMessage(), new Integer(9999) }, "Study Quality Control Codes");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating CSS - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * CSS-1: "Study Scheduled Time Point" - creates it if necessary
     */
    public CWE getStudyScheduledTimePoint() { 
        CWE ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * CSS-1: "Study Scheduled Time Point" - creates it if necessary
     */
    public CWE getCss1_StudyScheduledTimePoint() { 
        CWE ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * CSS-2: "Study Scheduled Patient Time Point" - creates it if necessary
     */
    public DTM getStudyScheduledPatientTimePoint() { 
        DTM ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * CSS-2: "Study Scheduled Patient Time Point" - creates it if necessary
     */
    public DTM getCss2_StudyScheduledPatientTimePoint() { 
        DTM ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Study Quality Control Codes (CSS-3).
     */
    public CWE[] getStudyQualityControlCodes() {
        CWE[] ret = null;
        try {
            Type[] t = this.getField(3);  
            ret = new CWE[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CWE)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * CSS-3: "Study Quality Control Codes" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CWE getStudyQualityControlCodes(int rep) { 
        CWE ret = null;
        try {
            Type t = this.getField(3, rep);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * CSS-3: "Study Quality Control Codes" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CWE getCss3_StudyQualityControlCodes(int rep) { 
        CWE ret = null;
        try {
            Type t = this.getField(3, rep);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * CSS-3: "Study Quality Control Codes" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE insertStudyQualityControlCodes(int rep) throws HL7Exception { 
        return (CWE) super.insertRepetition(3, rep);
    }



    /**
     * Inserts a repetition of
     * CSS-3: "Study Quality Control Codes" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE insertCss3_StudyQualityControlCodes(int rep) throws HL7Exception { 
        return (CWE) super.insertRepetition(3, rep);
    }


    /**
     * Removes a repetition of
     * CSS-3: "Study Quality Control Codes" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE removeStudyQualityControlCodes(int rep) throws HL7Exception { 
        return (CWE) super.removeRepetition(3, rep);
    }


    /**
     * Removes a repetition of
     * CSS-3: "Study Quality Control Codes" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE removeCss3_StudyQualityControlCodes(int rep) throws HL7Exception { 
        return (CWE) super.removeRepetition(3, rep);
    }






    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new CWE(getMessage());
          case 1: return new DTM(getMessage());
          case 2: return new CWE(getMessage());
          default: return null;
       }
   }


}

