/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v26.segment;

// import ca.uhn.hl7v2.model.v26.group.*;
import ca.uhn.hl7v2.model.v26.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 ERR message segment (Error). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>ERR-1: Error Code and Location (ELD) <b>optional repeating</b>
     * <li>ERR-2: Error Location (ERL) <b>optional repeating</b>
     * <li>ERR-3: HL7 Error Code (CWE) <b> </b>
     * <li>ERR-4: Severity (ID) <b> </b>
     * <li>ERR-5: Application Error Code (CWE) <b>optional </b>
     * <li>ERR-6: Application Error Parameter (ST) <b>optional repeating</b>
     * <li>ERR-7: Diagnostic Information (TX) <b>optional </b>
     * <li>ERR-8: User Message (TX) <b>optional </b>
     * <li>ERR-9: Inform Person Indicator (IS) <b>optional repeating</b>
     * <li>ERR-10: Override Type (CWE) <b>optional </b>
     * <li>ERR-11: Override Reason Code (CWE) <b>optional repeating</b>
     * <li>ERR-12: Help Desk Contact Point (XTN) <b>optional repeating</b>
 * </ul>
 */
public class ERR extends AbstractSegment {

    /** 
     * Creates a new ERR segment
     */
    public ERR(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(ELD.class, false, 0, 0, new Object[]{ getMessage(), new Integer(0) }, "Error Code and Location");
                                  this.add(ERL.class, false, 0, 18, new Object[]{ getMessage(), new Integer(0) }, "Error Location");
                                  this.add(CWE.class, true, 1, 705, new Object[]{ getMessage(), new Integer(357) }, "HL7 Error Code");
                                  this.add(ID.class, true, 1, 2, new Object[]{ getMessage() }, "Severity");
                                  this.add(CWE.class, false, 1, 705, new Object[]{ getMessage(), new Integer(533) }, "Application Error Code");
                                  this.add(ST.class, false, 10, 80, new Object[]{ getMessage(), new Integer(0) }, "Application Error Parameter");
                                  this.add(TX.class, false, 1, 2048, new Object[]{ getMessage(), new Integer(0) }, "Diagnostic Information");
                                  this.add(TX.class, false, 1, 250, new Object[]{ getMessage(), new Integer(0) }, "User Message");
                                  this.add(IS.class, false, 0, 20, new Object[]{ getMessage() }, "Inform Person Indicator");
                                  this.add(CWE.class, false, 1, 705, new Object[]{ getMessage(), new Integer(518) }, "Override Type");
                                  this.add(CWE.class, false, 0, 705, new Object[]{ getMessage(), new Integer(519) }, "Override Reason Code");
                                  this.add(XTN.class, false, 0, 652, new Object[]{ getMessage(), new Integer(0) }, "Help Desk Contact Point");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating ERR - this is probably a bug in the source code generator.", e);
       }
    }


    /**
     * Returns all repetitions of Error Code and Location (ERR-1).
     */
    public ELD[] getErrorCodeAndLocation() {
        ELD[] ret = null;
        try {
            Type[] t = this.getField(1);  
            ret = new ELD[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (ELD)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * ERR-1: "Error Code and Location" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ELD getErrorCodeAndLocation(int rep) { 
        ELD ret = null;
        try {
            Type t = this.getField(1, rep);
            ret = (ELD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * ERR-1: "Error Code and Location" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ELD getErr1_ErrorCodeAndLocation(int rep) { 
        ELD ret = null;
        try {
            Type t = this.getField(1, rep);
            ret = (ELD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * ERR-1: "Error Code and Location" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ELD insertErrorCodeAndLocation(int rep) throws HL7Exception { 
        return (ELD) super.insertRepetition(1, rep);
    }



    /**
     * Inserts a repetition of
     * ERR-1: "Error Code and Location" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ELD insertErr1_ErrorCodeAndLocation(int rep) throws HL7Exception { 
        return (ELD) super.insertRepetition(1, rep);
    }


    /**
     * Removes a repetition of
     * ERR-1: "Error Code and Location" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ELD removeErrorCodeAndLocation(int rep) throws HL7Exception { 
        return (ELD) super.removeRepetition(1, rep);
    }


    /**
     * Removes a repetition of
     * ERR-1: "Error Code and Location" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ELD removeErr1_ErrorCodeAndLocation(int rep) throws HL7Exception { 
        return (ELD) super.removeRepetition(1, rep);
    }



    /**
     * Returns all repetitions of Error Location (ERR-2).
     */
    public ERL[] getErrorLocation() {
        ERL[] ret = null;
        try {
            Type[] t = this.getField(2);  
            ret = new ERL[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (ERL)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * ERR-2: "Error Location" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ERL getErrorLocation(int rep) { 
        ERL ret = null;
        try {
            Type t = this.getField(2, rep);
            ret = (ERL)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * ERR-2: "Error Location" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ERL getErr2_ErrorLocation(int rep) { 
        ERL ret = null;
        try {
            Type t = this.getField(2, rep);
            ret = (ERL)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * ERR-2: "Error Location" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ERL insertErrorLocation(int rep) throws HL7Exception { 
        return (ERL) super.insertRepetition(2, rep);
    }



    /**
     * Inserts a repetition of
     * ERR-2: "Error Location" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ERL insertErr2_ErrorLocation(int rep) throws HL7Exception { 
        return (ERL) super.insertRepetition(2, rep);
    }


    /**
     * Removes a repetition of
     * ERR-2: "Error Location" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ERL removeErrorLocation(int rep) throws HL7Exception { 
        return (ERL) super.removeRepetition(2, rep);
    }


    /**
     * Removes a repetition of
     * ERR-2: "Error Location" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ERL removeErr2_ErrorLocation(int rep) throws HL7Exception { 
        return (ERL) super.removeRepetition(2, rep);
    }




    /**
     * Returns
     * ERR-3: "HL7 Error Code" - creates it if necessary
     */
    public CWE getHL7ErrorCode() { 
        CWE ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ERR-3: "HL7 Error Code" - creates it if necessary
     */
    public CWE getErr3_HL7ErrorCode() { 
        CWE ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * ERR-4: "Severity" - creates it if necessary
     */
    public ID getSeverity() { 
        ID ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ERR-4: "Severity" - creates it if necessary
     */
    public ID getErr4_Severity() { 
        ID ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * ERR-5: "Application Error Code" - creates it if necessary
     */
    public CWE getApplicationErrorCode() { 
        CWE ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ERR-5: "Application Error Code" - creates it if necessary
     */
    public CWE getErr5_ApplicationErrorCode() { 
        CWE ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Application Error Parameter (ERR-6).
     */
    public ST[] getApplicationErrorParameter() {
        ST[] ret = null;
        try {
            Type[] t = this.getField(6);  
            ret = new ST[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (ST)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * ERR-6: "Application Error Parameter" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ST getApplicationErrorParameter(int rep) { 
        ST ret = null;
        try {
            Type t = this.getField(6, rep);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * ERR-6: "Application Error Parameter" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ST getErr6_ApplicationErrorParameter(int rep) { 
        ST ret = null;
        try {
            Type t = this.getField(6, rep);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * ERR-6: "Application Error Parameter" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST insertApplicationErrorParameter(int rep) throws HL7Exception { 
        return (ST) super.insertRepetition(6, rep);
    }



    /**
     * Inserts a repetition of
     * ERR-6: "Application Error Parameter" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST insertErr6_ApplicationErrorParameter(int rep) throws HL7Exception { 
        return (ST) super.insertRepetition(6, rep);
    }


    /**
     * Removes a repetition of
     * ERR-6: "Application Error Parameter" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST removeApplicationErrorParameter(int rep) throws HL7Exception { 
        return (ST) super.removeRepetition(6, rep);
    }


    /**
     * Removes a repetition of
     * ERR-6: "Application Error Parameter" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST removeErr6_ApplicationErrorParameter(int rep) throws HL7Exception { 
        return (ST) super.removeRepetition(6, rep);
    }




    /**
     * Returns
     * ERR-7: "Diagnostic Information" - creates it if necessary
     */
    public TX getDiagnosticInformation() { 
        TX ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (TX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ERR-7: "Diagnostic Information" - creates it if necessary
     */
    public TX getErr7_DiagnosticInformation() { 
        TX ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (TX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * ERR-8: "User Message" - creates it if necessary
     */
    public TX getUserMessage() { 
        TX ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (TX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ERR-8: "User Message" - creates it if necessary
     */
    public TX getErr8_UserMessage() { 
        TX ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (TX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Inform Person Indicator (ERR-9).
     */
    public IS[] getInformPersonIndicator() {
        IS[] ret = null;
        try {
            Type[] t = this.getField(9);  
            ret = new IS[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (IS)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * ERR-9: "Inform Person Indicator" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public IS getInformPersonIndicator(int rep) { 
        IS ret = null;
        try {
            Type t = this.getField(9, rep);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * ERR-9: "Inform Person Indicator" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public IS getErr9_InformPersonIndicator(int rep) { 
        IS ret = null;
        try {
            Type t = this.getField(9, rep);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * ERR-9: "Inform Person Indicator" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public IS insertInformPersonIndicator(int rep) throws HL7Exception { 
        return (IS) super.insertRepetition(9, rep);
    }



    /**
     * Inserts a repetition of
     * ERR-9: "Inform Person Indicator" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public IS insertErr9_InformPersonIndicator(int rep) throws HL7Exception { 
        return (IS) super.insertRepetition(9, rep);
    }


    /**
     * Removes a repetition of
     * ERR-9: "Inform Person Indicator" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public IS removeInformPersonIndicator(int rep) throws HL7Exception { 
        return (IS) super.removeRepetition(9, rep);
    }


    /**
     * Removes a repetition of
     * ERR-9: "Inform Person Indicator" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public IS removeErr9_InformPersonIndicator(int rep) throws HL7Exception { 
        return (IS) super.removeRepetition(9, rep);
    }




    /**
     * Returns
     * ERR-10: "Override Type" - creates it if necessary
     */
    public CWE getOverrideType() { 
        CWE ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ERR-10: "Override Type" - creates it if necessary
     */
    public CWE getErr10_OverrideType() { 
        CWE ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Override Reason Code (ERR-11).
     */
    public CWE[] getOverrideReasonCode() {
        CWE[] ret = null;
        try {
            Type[] t = this.getField(11);  
            ret = new CWE[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CWE)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * ERR-11: "Override Reason Code" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CWE getOverrideReasonCode(int rep) { 
        CWE ret = null;
        try {
            Type t = this.getField(11, rep);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * ERR-11: "Override Reason Code" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CWE getErr11_OverrideReasonCode(int rep) { 
        CWE ret = null;
        try {
            Type t = this.getField(11, rep);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * ERR-11: "Override Reason Code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE insertOverrideReasonCode(int rep) throws HL7Exception { 
        return (CWE) super.insertRepetition(11, rep);
    }



    /**
     * Inserts a repetition of
     * ERR-11: "Override Reason Code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE insertErr11_OverrideReasonCode(int rep) throws HL7Exception { 
        return (CWE) super.insertRepetition(11, rep);
    }


    /**
     * Removes a repetition of
     * ERR-11: "Override Reason Code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE removeOverrideReasonCode(int rep) throws HL7Exception { 
        return (CWE) super.removeRepetition(11, rep);
    }


    /**
     * Removes a repetition of
     * ERR-11: "Override Reason Code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE removeErr11_OverrideReasonCode(int rep) throws HL7Exception { 
        return (CWE) super.removeRepetition(11, rep);
    }



    /**
     * Returns all repetitions of Help Desk Contact Point (ERR-12).
     */
    public XTN[] getHelpDeskContactPoint() {
        XTN[] ret = null;
        try {
            Type[] t = this.getField(12);  
            ret = new XTN[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (XTN)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * ERR-12: "Help Desk Contact Point" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XTN getHelpDeskContactPoint(int rep) { 
        XTN ret = null;
        try {
            Type t = this.getField(12, rep);
            ret = (XTN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * ERR-12: "Help Desk Contact Point" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XTN getErr12_HelpDeskContactPoint(int rep) { 
        XTN ret = null;
        try {
            Type t = this.getField(12, rep);
            ret = (XTN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * ERR-12: "Help Desk Contact Point" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN insertHelpDeskContactPoint(int rep) throws HL7Exception { 
        return (XTN) super.insertRepetition(12, rep);
    }



    /**
     * Inserts a repetition of
     * ERR-12: "Help Desk Contact Point" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN insertErr12_HelpDeskContactPoint(int rep) throws HL7Exception { 
        return (XTN) super.insertRepetition(12, rep);
    }


    /**
     * Removes a repetition of
     * ERR-12: "Help Desk Contact Point" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN removeHelpDeskContactPoint(int rep) throws HL7Exception { 
        return (XTN) super.removeRepetition(12, rep);
    }


    /**
     * Removes a repetition of
     * ERR-12: "Help Desk Contact Point" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN removeErr12_HelpDeskContactPoint(int rep) throws HL7Exception { 
        return (XTN) super.removeRepetition(12, rep);
    }






    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new ELD(getMessage());
          case 1: return new ERL(getMessage());
          case 2: return new CWE(getMessage());
          case 3: return new ID(getMessage(), new Integer( 516 ));
          case 4: return new CWE(getMessage());
          case 5: return new ST(getMessage());
          case 6: return new TX(getMessage());
          case 7: return new TX(getMessage());
          case 8: return new IS(getMessage(), new Integer( 517 ));
          case 9: return new CWE(getMessage());
          case 10: return new CWE(getMessage());
          case 11: return new XTN(getMessage());
          default: return null;
       }
   }


}

