/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v26.segment;

// import ca.uhn.hl7v2.model.v26.group.*;
import ca.uhn.hl7v2.model.v26.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 IPC message segment (Imaging Procedure Control Segment). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>IPC-1: Accession Identifier (EI) <b> </b>
     * <li>IPC-2: Requested Procedure ID (EI) <b> </b>
     * <li>IPC-3: Study Instance UID (EI) <b> </b>
     * <li>IPC-4: Scheduled Procedure Step ID (EI) <b> </b>
     * <li>IPC-5: Modality (CWE) <b>optional </b>
     * <li>IPC-6: Protocol Code (CWE) <b>optional repeating</b>
     * <li>IPC-7: Scheduled Station Name (EI) <b>optional </b>
     * <li>IPC-8: Scheduled Procedure Step Location (CWE) <b>optional repeating</b>
     * <li>IPC-9: Scheduled Station AE Title (ST) <b>optional </b>
 * </ul>
 */
public class IPC extends AbstractSegment {

    /** 
     * Creates a new IPC segment
     */
    public IPC(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(EI.class, true, 1, 427, new Object[]{ getMessage(), new Integer(0) }, "Accession Identifier");
                                  this.add(EI.class, true, 1, 22, new Object[]{ getMessage(), new Integer(0) }, "Requested Procedure ID");
                                  this.add(EI.class, true, 1, 70, new Object[]{ getMessage(), new Integer(0) }, "Study Instance UID");
                                  this.add(EI.class, true, 1, 22, new Object[]{ getMessage(), new Integer(0) }, "Scheduled Procedure Step ID");
                                  this.add(CWE.class, false, 1, 16, new Object[]{ getMessage(), new Integer(9999) }, "Modality");
                                  this.add(CWE.class, false, 0, 250, new Object[]{ getMessage(), new Integer(9999) }, "Protocol Code");
                                  this.add(EI.class, false, 1, 22, new Object[]{ getMessage(), new Integer(0) }, "Scheduled Station Name");
                                  this.add(CWE.class, false, 0, 250, new Object[]{ getMessage(), new Integer(9999) }, "Scheduled Procedure Step Location");
                                  this.add(ST.class, false, 1, 16, new Object[]{ getMessage(), new Integer(0) }, "Scheduled Station AE Title");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating IPC - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * IPC-1: "Accession Identifier" - creates it if necessary
     */
    public EI getAccessionIdentifier() { 
        EI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IPC-1: "Accession Identifier" - creates it if necessary
     */
    public EI getIpc1_AccessionIdentifier() { 
        EI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IPC-2: "Requested Procedure ID" - creates it if necessary
     */
    public EI getRequestedProcedureID() { 
        EI ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IPC-2: "Requested Procedure ID" - creates it if necessary
     */
    public EI getIpc2_RequestedProcedureID() { 
        EI ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IPC-3: "Study Instance UID" - creates it if necessary
     */
    public EI getStudyInstanceUID() { 
        EI ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IPC-3: "Study Instance UID" - creates it if necessary
     */
    public EI getIpc3_StudyInstanceUID() { 
        EI ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IPC-4: "Scheduled Procedure Step ID" - creates it if necessary
     */
    public EI getScheduledProcedureStepID() { 
        EI ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IPC-4: "Scheduled Procedure Step ID" - creates it if necessary
     */
    public EI getIpc4_ScheduledProcedureStepID() { 
        EI ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IPC-5: "Modality" - creates it if necessary
     */
    public CWE getModality() { 
        CWE ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IPC-5: "Modality" - creates it if necessary
     */
    public CWE getIpc5_Modality() { 
        CWE ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Protocol Code (IPC-6).
     */
    public CWE[] getProtocolCode() {
        CWE[] ret = null;
        try {
            Type[] t = this.getField(6);  
            ret = new CWE[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CWE)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * IPC-6: "Protocol Code" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CWE getProtocolCode(int rep) { 
        CWE ret = null;
        try {
            Type t = this.getField(6, rep);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * IPC-6: "Protocol Code" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CWE getIpc6_ProtocolCode(int rep) { 
        CWE ret = null;
        try {
            Type t = this.getField(6, rep);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * IPC-6: "Protocol Code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE insertProtocolCode(int rep) throws HL7Exception { 
        return (CWE) super.insertRepetition(6, rep);
    }



    /**
     * Inserts a repetition of
     * IPC-6: "Protocol Code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE insertIpc6_ProtocolCode(int rep) throws HL7Exception { 
        return (CWE) super.insertRepetition(6, rep);
    }


    /**
     * Removes a repetition of
     * IPC-6: "Protocol Code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE removeProtocolCode(int rep) throws HL7Exception { 
        return (CWE) super.removeRepetition(6, rep);
    }


    /**
     * Removes a repetition of
     * IPC-6: "Protocol Code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE removeIpc6_ProtocolCode(int rep) throws HL7Exception { 
        return (CWE) super.removeRepetition(6, rep);
    }




    /**
     * Returns
     * IPC-7: "Scheduled Station Name" - creates it if necessary
     */
    public EI getScheduledStationName() { 
        EI ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IPC-7: "Scheduled Station Name" - creates it if necessary
     */
    public EI getIpc7_ScheduledStationName() { 
        EI ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Scheduled Procedure Step Location (IPC-8).
     */
    public CWE[] getScheduledProcedureStepLocation() {
        CWE[] ret = null;
        try {
            Type[] t = this.getField(8);  
            ret = new CWE[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CWE)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * IPC-8: "Scheduled Procedure Step Location" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CWE getScheduledProcedureStepLocation(int rep) { 
        CWE ret = null;
        try {
            Type t = this.getField(8, rep);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * IPC-8: "Scheduled Procedure Step Location" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CWE getIpc8_ScheduledProcedureStepLocation(int rep) { 
        CWE ret = null;
        try {
            Type t = this.getField(8, rep);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * IPC-8: "Scheduled Procedure Step Location" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE insertScheduledProcedureStepLocation(int rep) throws HL7Exception { 
        return (CWE) super.insertRepetition(8, rep);
    }



    /**
     * Inserts a repetition of
     * IPC-8: "Scheduled Procedure Step Location" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE insertIpc8_ScheduledProcedureStepLocation(int rep) throws HL7Exception { 
        return (CWE) super.insertRepetition(8, rep);
    }


    /**
     * Removes a repetition of
     * IPC-8: "Scheduled Procedure Step Location" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE removeScheduledProcedureStepLocation(int rep) throws HL7Exception { 
        return (CWE) super.removeRepetition(8, rep);
    }


    /**
     * Removes a repetition of
     * IPC-8: "Scheduled Procedure Step Location" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE removeIpc8_ScheduledProcedureStepLocation(int rep) throws HL7Exception { 
        return (CWE) super.removeRepetition(8, rep);
    }




    /**
     * Returns
     * IPC-9: "Scheduled Station AE Title" - creates it if necessary
     */
    public ST getScheduledStationAETitle() { 
        ST ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IPC-9: "Scheduled Station AE Title" - creates it if necessary
     */
    public ST getIpc9_ScheduledStationAETitle() { 
        ST ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new EI(getMessage());
          case 1: return new EI(getMessage());
          case 2: return new EI(getMessage());
          case 3: return new EI(getMessage());
          case 4: return new CWE(getMessage());
          case 5: return new CWE(getMessage());
          case 6: return new EI(getMessage());
          case 7: return new CWE(getMessage());
          case 8: return new ST(getMessage());
          default: return null;
       }
   }


}

