/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v26.segment;

// import ca.uhn.hl7v2.model.v26.group.*;
import ca.uhn.hl7v2.model.v26.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 ITM message segment (Material Item). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>ITM-1: Item Identifier (EI) <b> </b>
     * <li>ITM-2: Item Description (ST) <b>optional </b>
     * <li>ITM-3: Item Status (CWE) <b>optional </b>
     * <li>ITM-4: Item Type (CWE) <b>optional </b>
     * <li>ITM-5: Item Category (CWE) <b>optional </b>
     * <li>ITM-6: Subject to Expiration Indicator (CNE) <b>optional </b>
     * <li>ITM-7: Manufacturer Identifier (EI) <b>optional </b>
     * <li>ITM-8: Manufacturer Name (ST) <b>optional </b>
     * <li>ITM-9: Manufacturer Catalog Number (ST) <b>optional </b>
     * <li>ITM-10: Manufacturer Labeler Identification Code (CWE) <b>optional </b>
     * <li>ITM-11: Patient Chargeable Indicator (CNE) <b>optional </b>
     * <li>ITM-12: Transaction Code (CWE) <b>optional </b>
     * <li>ITM-13: Transaction amount - unit (CP) <b>optional </b>
     * <li>ITM-14: Stocked Item Indicator (CNE) <b>optional </b>
     * <li>ITM-15: Supply Risk Codes (CWE) <b>optional </b>
     * <li>ITM-16: Approving Regulatory Agency (XON) <b>optional repeating</b>
     * <li>ITM-17: Latex Indicator (CNE) <b>optional </b>
     * <li>ITM-18: Ruling Act (CWE) <b>optional repeating</b>
     * <li>ITM-19: Item Natural Account Code (IS) <b>optional </b>
     * <li>ITM-20: Approved To Buy Quantity (NM) <b>optional </b>
     * <li>ITM-21: Approved To Buy Price (MO) <b>optional </b>
     * <li>ITM-22: Taxable Item Indicator (CNE) <b>optional </b>
     * <li>ITM-23: Freight Charge Indicator (CNE) <b>optional </b>
     * <li>ITM-24: Item Set Indicator (CNE) <b>optional </b>
     * <li>ITM-25: Item Set Identifier (EI) <b>optional </b>
     * <li>ITM-26: Track Department Usage Indicator (CNE) <b>optional </b>
     * <li>ITM-27: Procedure Code (CNE) <b>optional </b>
     * <li>ITM-28: Procedure Code Modifier (CNE) <b>optional repeating</b>
     * <li>ITM-29: Special Handling Code (CWE) <b>optional </b>
 * </ul>
 */
public class ITM extends AbstractSegment {

    /** 
     * Creates a new ITM segment
     */
    public ITM(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(EI.class, true, 1, 250, new Object[]{ getMessage(), new Integer(0) }, "Item Identifier");
                                  this.add(ST.class, false, 1, 999, new Object[]{ getMessage(), new Integer(0) }, "Item Description");
                                  this.add(CWE.class, false, 1, 250, new Object[]{ getMessage(), new Integer(776) }, "Item Status");
                                  this.add(CWE.class, false, 1, 250, new Object[]{ getMessage(), new Integer(778) }, "Item Type");
                                  this.add(CWE.class, false, 1, 250, new Object[]{ getMessage(), new Integer(0) }, "Item Category");
                                  this.add(CNE.class, false, 1, 4, new Object[]{ getMessage(), new Integer(532) }, "Subject to Expiration Indicator");
                                  this.add(EI.class, false, 1, 250, new Object[]{ getMessage(), new Integer(0) }, "Manufacturer Identifier");
                                  this.add(ST.class, false, 1, 999, new Object[]{ getMessage(), new Integer(0) }, "Manufacturer Name");
                                  this.add(ST.class, false, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "Manufacturer Catalog Number");
                                  this.add(CWE.class, false, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "Manufacturer Labeler Identification Code");
                                  this.add(CNE.class, false, 1, 4, new Object[]{ getMessage(), new Integer(532) }, "Patient Chargeable Indicator");
                                  this.add(CWE.class, false, 1, 250, new Object[]{ getMessage(), new Integer(132) }, "Transaction Code");
                                  this.add(CP.class, false, 1, 12, new Object[]{ getMessage(), new Integer(0) }, "Transaction amount - unit");
                                  this.add(CNE.class, false, 1, 4, new Object[]{ getMessage(), new Integer(532) }, "Stocked Item Indicator");
                                  this.add(CWE.class, false, 1, 250, new Object[]{ getMessage(), new Integer(871) }, "Supply Risk Codes");
                                  this.add(XON.class, false, 0, 250, new Object[]{ getMessage(), new Integer(790) }, "Approving Regulatory Agency");
                                  this.add(CNE.class, false, 1, 4, new Object[]{ getMessage(), new Integer(532) }, "Latex Indicator");
                                  this.add(CWE.class, false, 0, 250, new Object[]{ getMessage(), new Integer(793) }, "Ruling Act");
                                  this.add(IS.class, false, 1, 30, new Object[]{ getMessage() }, "Item Natural Account Code");
                                  this.add(NM.class, false, 1, 6, new Object[]{ getMessage(), new Integer(0) }, "Approved To Buy Quantity");
                                  this.add(MO.class, false, 1, 10, new Object[]{ getMessage(), new Integer(0) }, "Approved To Buy Price");
                                  this.add(CNE.class, false, 1, 4, new Object[]{ getMessage(), new Integer(532) }, "Taxable Item Indicator");
                                  this.add(CNE.class, false, 1, 4, new Object[]{ getMessage(), new Integer(532) }, "Freight Charge Indicator");
                                  this.add(CNE.class, false, 1, 4, new Object[]{ getMessage(), new Integer(532) }, "Item Set Indicator");
                                  this.add(EI.class, false, 1, 250, new Object[]{ getMessage(), new Integer(0) }, "Item Set Identifier");
                                  this.add(CNE.class, false, 1, 4, new Object[]{ getMessage(), new Integer(532) }, "Track Department Usage Indicator");
                                  this.add(CNE.class, false, 1, 705, new Object[]{ getMessage(), new Integer(88) }, "Procedure Code");
                                  this.add(CNE.class, false, 0, 705, new Object[]{ getMessage(), new Integer(340) }, "Procedure Code Modifier");
                                  this.add(CWE.class, false, 1, 705, new Object[]{ getMessage(), new Integer(376) }, "Special Handling Code");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating ITM - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * ITM-1: "Item Identifier" - creates it if necessary
     */
    public EI getItemIdentifier() { 
        EI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ITM-1: "Item Identifier" - creates it if necessary
     */
    public EI getItm1_ItemIdentifier() { 
        EI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * ITM-2: "Item Description" - creates it if necessary
     */
    public ST getItemDescription() { 
        ST ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ITM-2: "Item Description" - creates it if necessary
     */
    public ST getItm2_ItemDescription() { 
        ST ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * ITM-3: "Item Status" - creates it if necessary
     */
    public CWE getItemStatus() { 
        CWE ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ITM-3: "Item Status" - creates it if necessary
     */
    public CWE getItm3_ItemStatus() { 
        CWE ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * ITM-4: "Item Type" - creates it if necessary
     */
    public CWE getItemType() { 
        CWE ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ITM-4: "Item Type" - creates it if necessary
     */
    public CWE getItm4_ItemType() { 
        CWE ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * ITM-5: "Item Category" - creates it if necessary
     */
    public CWE getItemCategory() { 
        CWE ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ITM-5: "Item Category" - creates it if necessary
     */
    public CWE getItm5_ItemCategory() { 
        CWE ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * ITM-6: "Subject to Expiration Indicator" - creates it if necessary
     */
    public CNE getSubjectToExpirationIndicator() { 
        CNE ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ITM-6: "Subject to Expiration Indicator" - creates it if necessary
     */
    public CNE getItm6_SubjectToExpirationIndicator() { 
        CNE ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * ITM-7: "Manufacturer Identifier" - creates it if necessary
     */
    public EI getManufacturerIdentifier() { 
        EI ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ITM-7: "Manufacturer Identifier" - creates it if necessary
     */
    public EI getItm7_ManufacturerIdentifier() { 
        EI ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * ITM-8: "Manufacturer Name" - creates it if necessary
     */
    public ST getManufacturerName() { 
        ST ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ITM-8: "Manufacturer Name" - creates it if necessary
     */
    public ST getItm8_ManufacturerName() { 
        ST ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * ITM-9: "Manufacturer Catalog Number" - creates it if necessary
     */
    public ST getManufacturerCatalogNumber() { 
        ST ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ITM-9: "Manufacturer Catalog Number" - creates it if necessary
     */
    public ST getItm9_ManufacturerCatalogNumber() { 
        ST ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * ITM-10: "Manufacturer Labeler Identification Code" - creates it if necessary
     */
    public CWE getManufacturerLabelerIdentificationCode() { 
        CWE ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ITM-10: "Manufacturer Labeler Identification Code" - creates it if necessary
     */
    public CWE getItm10_ManufacturerLabelerIdentificationCode() { 
        CWE ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * ITM-11: "Patient Chargeable Indicator" - creates it if necessary
     */
    public CNE getPatientChargeableIndicator() { 
        CNE ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ITM-11: "Patient Chargeable Indicator" - creates it if necessary
     */
    public CNE getItm11_PatientChargeableIndicator() { 
        CNE ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * ITM-12: "Transaction Code" - creates it if necessary
     */
    public CWE getTransactionCode() { 
        CWE ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ITM-12: "Transaction Code" - creates it if necessary
     */
    public CWE getItm12_TransactionCode() { 
        CWE ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * ITM-13: "Transaction amount - unit" - creates it if necessary
     */
    public CP getTransactionAmountUnit() { 
        CP ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ITM-13: "Transaction amount - unit" - creates it if necessary
     */
    public CP getItm13_TransactionAmountUnit() { 
        CP ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * ITM-14: "Stocked Item Indicator" - creates it if necessary
     */
    public CNE getStockedItemIndicator() { 
        CNE ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ITM-14: "Stocked Item Indicator" - creates it if necessary
     */
    public CNE getItm14_StockedItemIndicator() { 
        CNE ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * ITM-15: "Supply Risk Codes" - creates it if necessary
     */
    public CWE getSupplyRiskCodes() { 
        CWE ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ITM-15: "Supply Risk Codes" - creates it if necessary
     */
    public CWE getItm15_SupplyRiskCodes() { 
        CWE ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Approving Regulatory Agency (ITM-16).
     */
    public XON[] getApprovingRegulatoryAgency() {
        XON[] ret = null;
        try {
            Type[] t = this.getField(16);  
            ret = new XON[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (XON)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * ITM-16: "Approving Regulatory Agency" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XON getApprovingRegulatoryAgency(int rep) { 
        XON ret = null;
        try {
            Type t = this.getField(16, rep);
            ret = (XON)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * ITM-16: "Approving Regulatory Agency" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XON getItm16_ApprovingRegulatoryAgency(int rep) { 
        XON ret = null;
        try {
            Type t = this.getField(16, rep);
            ret = (XON)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * ITM-16: "Approving Regulatory Agency" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XON insertApprovingRegulatoryAgency(int rep) throws HL7Exception { 
        return (XON) super.insertRepetition(16, rep);
    }



    /**
     * Inserts a repetition of
     * ITM-16: "Approving Regulatory Agency" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XON insertItm16_ApprovingRegulatoryAgency(int rep) throws HL7Exception { 
        return (XON) super.insertRepetition(16, rep);
    }


    /**
     * Removes a repetition of
     * ITM-16: "Approving Regulatory Agency" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XON removeApprovingRegulatoryAgency(int rep) throws HL7Exception { 
        return (XON) super.removeRepetition(16, rep);
    }


    /**
     * Removes a repetition of
     * ITM-16: "Approving Regulatory Agency" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XON removeItm16_ApprovingRegulatoryAgency(int rep) throws HL7Exception { 
        return (XON) super.removeRepetition(16, rep);
    }




    /**
     * Returns
     * ITM-17: "Latex Indicator" - creates it if necessary
     */
    public CNE getLatexIndicator() { 
        CNE ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ITM-17: "Latex Indicator" - creates it if necessary
     */
    public CNE getItm17_LatexIndicator() { 
        CNE ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Ruling Act (ITM-18).
     */
    public CWE[] getRulingAct() {
        CWE[] ret = null;
        try {
            Type[] t = this.getField(18);  
            ret = new CWE[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CWE)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * ITM-18: "Ruling Act" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CWE getRulingAct(int rep) { 
        CWE ret = null;
        try {
            Type t = this.getField(18, rep);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * ITM-18: "Ruling Act" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CWE getItm18_RulingAct(int rep) { 
        CWE ret = null;
        try {
            Type t = this.getField(18, rep);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * ITM-18: "Ruling Act" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE insertRulingAct(int rep) throws HL7Exception { 
        return (CWE) super.insertRepetition(18, rep);
    }



    /**
     * Inserts a repetition of
     * ITM-18: "Ruling Act" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE insertItm18_RulingAct(int rep) throws HL7Exception { 
        return (CWE) super.insertRepetition(18, rep);
    }


    /**
     * Removes a repetition of
     * ITM-18: "Ruling Act" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE removeRulingAct(int rep) throws HL7Exception { 
        return (CWE) super.removeRepetition(18, rep);
    }


    /**
     * Removes a repetition of
     * ITM-18: "Ruling Act" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE removeItm18_RulingAct(int rep) throws HL7Exception { 
        return (CWE) super.removeRepetition(18, rep);
    }




    /**
     * Returns
     * ITM-19: "Item Natural Account Code" - creates it if necessary
     */
    public IS getItemNaturalAccountCode() { 
        IS ret = null;
        try {
            Type t = this.getField(19, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ITM-19: "Item Natural Account Code" - creates it if necessary
     */
    public IS getItm19_ItemNaturalAccountCode() { 
        IS ret = null;
        try {
            Type t = this.getField(19, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * ITM-20: "Approved To Buy Quantity" - creates it if necessary
     */
    public NM getApprovedToBuyQuantity() { 
        NM ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ITM-20: "Approved To Buy Quantity" - creates it if necessary
     */
    public NM getItm20_ApprovedToBuyQuantity() { 
        NM ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * ITM-21: "Approved To Buy Price" - creates it if necessary
     */
    public MO getApprovedToBuyPrice() { 
        MO ret = null;
        try {
            Type t = this.getField(21, 0);
            ret = (MO)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ITM-21: "Approved To Buy Price" - creates it if necessary
     */
    public MO getItm21_ApprovedToBuyPrice() { 
        MO ret = null;
        try {
            Type t = this.getField(21, 0);
            ret = (MO)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * ITM-22: "Taxable Item Indicator" - creates it if necessary
     */
    public CNE getTaxableItemIndicator() { 
        CNE ret = null;
        try {
            Type t = this.getField(22, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ITM-22: "Taxable Item Indicator" - creates it if necessary
     */
    public CNE getItm22_TaxableItemIndicator() { 
        CNE ret = null;
        try {
            Type t = this.getField(22, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * ITM-23: "Freight Charge Indicator" - creates it if necessary
     */
    public CNE getFreightChargeIndicator() { 
        CNE ret = null;
        try {
            Type t = this.getField(23, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ITM-23: "Freight Charge Indicator" - creates it if necessary
     */
    public CNE getItm23_FreightChargeIndicator() { 
        CNE ret = null;
        try {
            Type t = this.getField(23, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * ITM-24: "Item Set Indicator" - creates it if necessary
     */
    public CNE getItemSetIndicator() { 
        CNE ret = null;
        try {
            Type t = this.getField(24, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ITM-24: "Item Set Indicator" - creates it if necessary
     */
    public CNE getItm24_ItemSetIndicator() { 
        CNE ret = null;
        try {
            Type t = this.getField(24, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * ITM-25: "Item Set Identifier" - creates it if necessary
     */
    public EI getItemSetIdentifier() { 
        EI ret = null;
        try {
            Type t = this.getField(25, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ITM-25: "Item Set Identifier" - creates it if necessary
     */
    public EI getItm25_ItemSetIdentifier() { 
        EI ret = null;
        try {
            Type t = this.getField(25, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * ITM-26: "Track Department Usage Indicator" - creates it if necessary
     */
    public CNE getTrackDepartmentUsageIndicator() { 
        CNE ret = null;
        try {
            Type t = this.getField(26, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ITM-26: "Track Department Usage Indicator" - creates it if necessary
     */
    public CNE getItm26_TrackDepartmentUsageIndicator() { 
        CNE ret = null;
        try {
            Type t = this.getField(26, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * ITM-27: "Procedure Code" - creates it if necessary
     */
    public CNE getProcedureCode() { 
        CNE ret = null;
        try {
            Type t = this.getField(27, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ITM-27: "Procedure Code" - creates it if necessary
     */
    public CNE getItm27_ProcedureCode() { 
        CNE ret = null;
        try {
            Type t = this.getField(27, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Procedure Code Modifier (ITM-28).
     */
    public CNE[] getProcedureCodeModifier() {
        CNE[] ret = null;
        try {
            Type[] t = this.getField(28);  
            ret = new CNE[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CNE)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * ITM-28: "Procedure Code Modifier" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CNE getProcedureCodeModifier(int rep) { 
        CNE ret = null;
        try {
            Type t = this.getField(28, rep);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * ITM-28: "Procedure Code Modifier" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CNE getItm28_ProcedureCodeModifier(int rep) { 
        CNE ret = null;
        try {
            Type t = this.getField(28, rep);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * ITM-28: "Procedure Code Modifier" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CNE insertProcedureCodeModifier(int rep) throws HL7Exception { 
        return (CNE) super.insertRepetition(28, rep);
    }



    /**
     * Inserts a repetition of
     * ITM-28: "Procedure Code Modifier" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CNE insertItm28_ProcedureCodeModifier(int rep) throws HL7Exception { 
        return (CNE) super.insertRepetition(28, rep);
    }


    /**
     * Removes a repetition of
     * ITM-28: "Procedure Code Modifier" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CNE removeProcedureCodeModifier(int rep) throws HL7Exception { 
        return (CNE) super.removeRepetition(28, rep);
    }


    /**
     * Removes a repetition of
     * ITM-28: "Procedure Code Modifier" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CNE removeItm28_ProcedureCodeModifier(int rep) throws HL7Exception { 
        return (CNE) super.removeRepetition(28, rep);
    }




    /**
     * Returns
     * ITM-29: "Special Handling Code" - creates it if necessary
     */
    public CWE getSpecialHandlingCode() { 
        CWE ret = null;
        try {
            Type t = this.getField(29, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ITM-29: "Special Handling Code" - creates it if necessary
     */
    public CWE getItm29_SpecialHandlingCode() { 
        CWE ret = null;
        try {
            Type t = this.getField(29, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new EI(getMessage());
          case 1: return new ST(getMessage());
          case 2: return new CWE(getMessage());
          case 3: return new CWE(getMessage());
          case 4: return new CWE(getMessage());
          case 5: return new CNE(getMessage());
          case 6: return new EI(getMessage());
          case 7: return new ST(getMessage());
          case 8: return new ST(getMessage());
          case 9: return new CWE(getMessage());
          case 10: return new CNE(getMessage());
          case 11: return new CWE(getMessage());
          case 12: return new CP(getMessage());
          case 13: return new CNE(getMessage());
          case 14: return new CWE(getMessage());
          case 15: return new XON(getMessage());
          case 16: return new CNE(getMessage());
          case 17: return new CWE(getMessage());
          case 18: return new IS(getMessage(), new Integer( 320 ));
          case 19: return new NM(getMessage());
          case 20: return new MO(getMessage());
          case 21: return new CNE(getMessage());
          case 22: return new CNE(getMessage());
          case 23: return new CNE(getMessage());
          case 24: return new EI(getMessage());
          case 25: return new CNE(getMessage());
          case 26: return new CNE(getMessage());
          case 27: return new CNE(getMessage());
          case 28: return new CWE(getMessage());
          default: return null;
       }
   }


}

