/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v26.segment;

// import ca.uhn.hl7v2.model.v26.group.*;
import ca.uhn.hl7v2.model.v26.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 PID message segment (Patient Identification). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>PID-1: Set ID - PID (SI) <b>optional </b>
     * <li>PID-2: Patient ID (CX) <b>optional </b>
     * <li>PID-3: Patient Identifier List (CX) <b> repeating</b>
     * <li>PID-4: Alternate Patient ID - PID (CX) <b>optional repeating</b>
     * <li>PID-5: Patient Name (XPN) <b> repeating</b>
     * <li>PID-6: Mother's Maiden Name (XPN) <b>optional repeating</b>
     * <li>PID-7: Date/Time of Birth (DTM) <b>optional </b>
     * <li>PID-8: Administrative Sex (IS) <b>optional </b>
     * <li>PID-9: Patient Alias (XPN) <b>optional repeating</b>
     * <li>PID-10: Race (CWE) <b>optional repeating</b>
     * <li>PID-11: Patient Address (XAD) <b>optional repeating</b>
     * <li>PID-12: County Code (IS) <b>optional </b>
     * <li>PID-13: Phone Number - Home (XTN) <b>optional repeating</b>
     * <li>PID-14: Phone Number - Business (XTN) <b>optional repeating</b>
     * <li>PID-15: Primary Language (CWE) <b>optional </b>
     * <li>PID-16: Marital Status (CWE) <b>optional </b>
     * <li>PID-17: Religion (CWE) <b>optional </b>
     * <li>PID-18: Patient Account Number (CX) <b>optional </b>
     * <li>PID-19: SSN Number - Patient (ST) <b>optional </b>
     * <li>PID-20: Driver's License Number - Patient (DLN) <b>optional </b>
     * <li>PID-21: Mother's Identifier (CX) <b>optional repeating</b>
     * <li>PID-22: Ethnic Group (CWE) <b>optional repeating</b>
     * <li>PID-23: Birth Place (ST) <b>optional </b>
     * <li>PID-24: Multiple Birth Indicator (ID) <b>optional </b>
     * <li>PID-25: Birth Order (NM) <b>optional </b>
     * <li>PID-26: Citizenship (CWE) <b>optional repeating</b>
     * <li>PID-27: Veterans Military Status (CWE) <b>optional </b>
     * <li>PID-28: Nationality (CWE) <b>optional </b>
     * <li>PID-29: Patient Death Date and Time (DTM) <b>optional </b>
     * <li>PID-30: Patient Death Indicator (ID) <b>optional </b>
     * <li>PID-31: Identity Unknown Indicator (ID) <b>optional </b>
     * <li>PID-32: Identity Reliability Code (IS) <b>optional repeating</b>
     * <li>PID-33: Last Update Date/Time (DTM) <b>optional </b>
     * <li>PID-34: Last Update Facility (HD) <b>optional </b>
     * <li>PID-35: Species Code (CWE) <b>optional </b>
     * <li>PID-36: Breed Code (CWE) <b>optional </b>
     * <li>PID-37: Strain (ST) <b>optional </b>
     * <li>PID-38: Production Class Code (CWE) <b>optional </b>
     * <li>PID-39: Tribal Citizenship (CWE) <b>optional repeating</b>
 * </ul>
 */
public class PID extends AbstractSegment {

    /** 
     * Creates a new PID segment
     */
    public PID(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(SI.class, false, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "Set ID - PID");
                                  this.add(CX.class, false, 1, 0, new Object[]{ getMessage(), new Integer(0) }, "Patient ID");
                                  this.add(CX.class, true, 0, 250, new Object[]{ getMessage(), new Integer(0) }, "Patient Identifier List");
                                  this.add(CX.class, false, 0, 0, new Object[]{ getMessage(), new Integer(0) }, "Alternate Patient ID - PID");
                                  this.add(XPN.class, true, 0, 250, new Object[]{ getMessage(), new Integer(200) }, "Patient Name");
                                  this.add(XPN.class, false, 0, 250, new Object[]{ getMessage(), new Integer(0) }, "Mother's Maiden Name");
                                  this.add(DTM.class, false, 1, 24, new Object[]{ getMessage(), new Integer(0) }, "Date/Time of Birth");
                                  this.add(IS.class, false, 1, 1, new Object[]{ getMessage() }, "Administrative Sex");
                                  this.add(XPN.class, false, 0, 0, new Object[]{ getMessage(), new Integer(0) }, "Patient Alias");
                                  this.add(CWE.class, false, 0, 705, new Object[]{ getMessage(), new Integer(5) }, "Race");
                                  this.add(XAD.class, false, 0, 250, new Object[]{ getMessage(), new Integer(0) }, "Patient Address");
                                  this.add(IS.class, false, 1, 0, new Object[]{ getMessage() }, "County Code");
                                  this.add(XTN.class, false, 0, 250, new Object[]{ getMessage(), new Integer(0) }, "Phone Number - Home");
                                  this.add(XTN.class, false, 0, 250, new Object[]{ getMessage(), new Integer(0) }, "Phone Number - Business");
                                  this.add(CWE.class, false, 1, 705, new Object[]{ getMessage(), new Integer(296) }, "Primary Language");
                                  this.add(CWE.class, false, 1, 705, new Object[]{ getMessage(), new Integer(2) }, "Marital Status");
                                  this.add(CWE.class, false, 1, 705, new Object[]{ getMessage(), new Integer(6) }, "Religion");
                                  this.add(CX.class, false, 1, 250, new Object[]{ getMessage(), new Integer(0) }, "Patient Account Number");
                                  this.add(ST.class, false, 1, 0, new Object[]{ getMessage(), new Integer(0) }, "SSN Number - Patient");
                                  this.add(DLN.class, false, 1, 0, new Object[]{ getMessage(), new Integer(0) }, "Driver's License Number - Patient");
                                  this.add(CX.class, false, 0, 250, new Object[]{ getMessage(), new Integer(0) }, "Mother's Identifier");
                                  this.add(CWE.class, false, 0, 705, new Object[]{ getMessage(), new Integer(189) }, "Ethnic Group");
                                  this.add(ST.class, false, 1, 250, new Object[]{ getMessage(), new Integer(0) }, "Birth Place");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "Multiple Birth Indicator");
                                  this.add(NM.class, false, 1, 2, new Object[]{ getMessage(), new Integer(0) }, "Birth Order");
                                  this.add(CWE.class, false, 0, 705, new Object[]{ getMessage(), new Integer(171) }, "Citizenship");
                                  this.add(CWE.class, false, 1, 705, new Object[]{ getMessage(), new Integer(172) }, "Veterans Military Status");
                                  this.add(CWE.class, false, 1, 0, new Object[]{ getMessage(), new Integer(212) }, "Nationality");
                                  this.add(DTM.class, false, 1, 24, new Object[]{ getMessage(), new Integer(0) }, "Patient Death Date and Time");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "Patient Death Indicator");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "Identity Unknown Indicator");
                                  this.add(IS.class, false, 0, 20, new Object[]{ getMessage() }, "Identity Reliability Code");
                                  this.add(DTM.class, false, 1, 24, new Object[]{ getMessage(), new Integer(0) }, "Last Update Date/Time");
                                  this.add(HD.class, false, 1, 241, new Object[]{ getMessage(), new Integer(0) }, "Last Update Facility");
                                  this.add(CWE.class, false, 1, 705, new Object[]{ getMessage(), new Integer(446) }, "Species Code");
                                  this.add(CWE.class, false, 1, 705, new Object[]{ getMessage(), new Integer(447) }, "Breed Code");
                                  this.add(ST.class, false, 1, 80, new Object[]{ getMessage(), new Integer(0) }, "Strain");
                                  this.add(CWE.class, false, 1, 705, new Object[]{ getMessage(), new Integer(429) }, "Production Class Code");
                                  this.add(CWE.class, false, 0, 705, new Object[]{ getMessage(), new Integer(171) }, "Tribal Citizenship");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating PID - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * PID-1: "Set ID - PID" - creates it if necessary
     */
    public SI getSetIDPID() { 
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PID-1: "Set ID - PID" - creates it if necessary
     */
    public SI getPid1_SetIDPID() { 
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PID-2: "Patient ID" - creates it if necessary
     */
    public CX getPatientID() { 
        CX ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (CX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PID-2: "Patient ID" - creates it if necessary
     */
    public CX getPid2_PatientID() { 
        CX ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (CX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Patient Identifier List (PID-3).
     */
    public CX[] getPatientIdentifierList() {
        CX[] ret = null;
        try {
            Type[] t = this.getField(3);  
            ret = new CX[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CX)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PID-3: "Patient Identifier List" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CX getPatientIdentifierList(int rep) { 
        CX ret = null;
        try {
            Type t = this.getField(3, rep);
            ret = (CX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PID-3: "Patient Identifier List" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CX getPid3_PatientIdentifierList(int rep) { 
        CX ret = null;
        try {
            Type t = this.getField(3, rep);
            ret = (CX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * PID-3: "Patient Identifier List" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CX insertPatientIdentifierList(int rep) throws HL7Exception { 
        return (CX) super.insertRepetition(3, rep);
    }



    /**
     * Inserts a repetition of
     * PID-3: "Patient Identifier List" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CX insertPid3_PatientIdentifierList(int rep) throws HL7Exception { 
        return (CX) super.insertRepetition(3, rep);
    }


    /**
     * Removes a repetition of
     * PID-3: "Patient Identifier List" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CX removePatientIdentifierList(int rep) throws HL7Exception { 
        return (CX) super.removeRepetition(3, rep);
    }


    /**
     * Removes a repetition of
     * PID-3: "Patient Identifier List" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CX removePid3_PatientIdentifierList(int rep) throws HL7Exception { 
        return (CX) super.removeRepetition(3, rep);
    }



    /**
     * Returns all repetitions of Alternate Patient ID - PID (PID-4).
     */
    public CX[] getAlternatePatientIDPID() {
        CX[] ret = null;
        try {
            Type[] t = this.getField(4);  
            ret = new CX[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CX)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PID-4: "Alternate Patient ID - PID" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CX getAlternatePatientIDPID(int rep) { 
        CX ret = null;
        try {
            Type t = this.getField(4, rep);
            ret = (CX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PID-4: "Alternate Patient ID - PID" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CX getPid4_AlternatePatientIDPID(int rep) { 
        CX ret = null;
        try {
            Type t = this.getField(4, rep);
            ret = (CX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * PID-4: "Alternate Patient ID - PID" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CX insertAlternatePatientIDPID(int rep) throws HL7Exception { 
        return (CX) super.insertRepetition(4, rep);
    }



    /**
     * Inserts a repetition of
     * PID-4: "Alternate Patient ID - PID" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CX insertPid4_AlternatePatientIDPID(int rep) throws HL7Exception { 
        return (CX) super.insertRepetition(4, rep);
    }


    /**
     * Removes a repetition of
     * PID-4: "Alternate Patient ID - PID" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CX removeAlternatePatientIDPID(int rep) throws HL7Exception { 
        return (CX) super.removeRepetition(4, rep);
    }


    /**
     * Removes a repetition of
     * PID-4: "Alternate Patient ID - PID" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CX removePid4_AlternatePatientIDPID(int rep) throws HL7Exception { 
        return (CX) super.removeRepetition(4, rep);
    }



    /**
     * Returns all repetitions of Patient Name (PID-5).
     */
    public XPN[] getPatientName() {
        XPN[] ret = null;
        try {
            Type[] t = this.getField(5);  
            ret = new XPN[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (XPN)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PID-5: "Patient Name" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XPN getPatientName(int rep) { 
        XPN ret = null;
        try {
            Type t = this.getField(5, rep);
            ret = (XPN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PID-5: "Patient Name" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XPN getPid5_PatientName(int rep) { 
        XPN ret = null;
        try {
            Type t = this.getField(5, rep);
            ret = (XPN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * PID-5: "Patient Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XPN insertPatientName(int rep) throws HL7Exception { 
        return (XPN) super.insertRepetition(5, rep);
    }



    /**
     * Inserts a repetition of
     * PID-5: "Patient Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XPN insertPid5_PatientName(int rep) throws HL7Exception { 
        return (XPN) super.insertRepetition(5, rep);
    }


    /**
     * Removes a repetition of
     * PID-5: "Patient Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XPN removePatientName(int rep) throws HL7Exception { 
        return (XPN) super.removeRepetition(5, rep);
    }


    /**
     * Removes a repetition of
     * PID-5: "Patient Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XPN removePid5_PatientName(int rep) throws HL7Exception { 
        return (XPN) super.removeRepetition(5, rep);
    }



    /**
     * Returns all repetitions of Mother's Maiden Name (PID-6).
     */
    public XPN[] getMotherSMaidenName() {
        XPN[] ret = null;
        try {
            Type[] t = this.getField(6);  
            ret = new XPN[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (XPN)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PID-6: "Mother's Maiden Name" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XPN getMotherSMaidenName(int rep) { 
        XPN ret = null;
        try {
            Type t = this.getField(6, rep);
            ret = (XPN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PID-6: "Mother's Maiden Name" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XPN getPid6_MotherSMaidenName(int rep) { 
        XPN ret = null;
        try {
            Type t = this.getField(6, rep);
            ret = (XPN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * PID-6: "Mother's Maiden Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XPN insertMotherSMaidenName(int rep) throws HL7Exception { 
        return (XPN) super.insertRepetition(6, rep);
    }



    /**
     * Inserts a repetition of
     * PID-6: "Mother's Maiden Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XPN insertPid6_MotherSMaidenName(int rep) throws HL7Exception { 
        return (XPN) super.insertRepetition(6, rep);
    }


    /**
     * Removes a repetition of
     * PID-6: "Mother's Maiden Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XPN removeMotherSMaidenName(int rep) throws HL7Exception { 
        return (XPN) super.removeRepetition(6, rep);
    }


    /**
     * Removes a repetition of
     * PID-6: "Mother's Maiden Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XPN removePid6_MotherSMaidenName(int rep) throws HL7Exception { 
        return (XPN) super.removeRepetition(6, rep);
    }




    /**
     * Returns
     * PID-7: "Date/Time of Birth" - creates it if necessary
     */
    public DTM getDateTimeOfBirth() { 
        DTM ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PID-7: "Date/Time of Birth" - creates it if necessary
     */
    public DTM getPid7_DateTimeOfBirth() { 
        DTM ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PID-8: "Administrative Sex" - creates it if necessary
     */
    public IS getAdministrativeSex() { 
        IS ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PID-8: "Administrative Sex" - creates it if necessary
     */
    public IS getPid8_AdministrativeSex() { 
        IS ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Patient Alias (PID-9).
     */
    public XPN[] getPatientAlias() {
        XPN[] ret = null;
        try {
            Type[] t = this.getField(9);  
            ret = new XPN[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (XPN)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PID-9: "Patient Alias" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XPN getPatientAlias(int rep) { 
        XPN ret = null;
        try {
            Type t = this.getField(9, rep);
            ret = (XPN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PID-9: "Patient Alias" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XPN getPid9_PatientAlias(int rep) { 
        XPN ret = null;
        try {
            Type t = this.getField(9, rep);
            ret = (XPN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * PID-9: "Patient Alias" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XPN insertPatientAlias(int rep) throws HL7Exception { 
        return (XPN) super.insertRepetition(9, rep);
    }



    /**
     * Inserts a repetition of
     * PID-9: "Patient Alias" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XPN insertPid9_PatientAlias(int rep) throws HL7Exception { 
        return (XPN) super.insertRepetition(9, rep);
    }


    /**
     * Removes a repetition of
     * PID-9: "Patient Alias" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XPN removePatientAlias(int rep) throws HL7Exception { 
        return (XPN) super.removeRepetition(9, rep);
    }


    /**
     * Removes a repetition of
     * PID-9: "Patient Alias" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XPN removePid9_PatientAlias(int rep) throws HL7Exception { 
        return (XPN) super.removeRepetition(9, rep);
    }



    /**
     * Returns all repetitions of Race (PID-10).
     */
    public CWE[] getRace() {
        CWE[] ret = null;
        try {
            Type[] t = this.getField(10);  
            ret = new CWE[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CWE)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PID-10: "Race" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CWE getRace(int rep) { 
        CWE ret = null;
        try {
            Type t = this.getField(10, rep);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PID-10: "Race" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CWE getPid10_Race(int rep) { 
        CWE ret = null;
        try {
            Type t = this.getField(10, rep);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * PID-10: "Race" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE insertRace(int rep) throws HL7Exception { 
        return (CWE) super.insertRepetition(10, rep);
    }



    /**
     * Inserts a repetition of
     * PID-10: "Race" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE insertPid10_Race(int rep) throws HL7Exception { 
        return (CWE) super.insertRepetition(10, rep);
    }


    /**
     * Removes a repetition of
     * PID-10: "Race" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE removeRace(int rep) throws HL7Exception { 
        return (CWE) super.removeRepetition(10, rep);
    }


    /**
     * Removes a repetition of
     * PID-10: "Race" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE removePid10_Race(int rep) throws HL7Exception { 
        return (CWE) super.removeRepetition(10, rep);
    }



    /**
     * Returns all repetitions of Patient Address (PID-11).
     */
    public XAD[] getPatientAddress() {
        XAD[] ret = null;
        try {
            Type[] t = this.getField(11);  
            ret = new XAD[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (XAD)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PID-11: "Patient Address" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XAD getPatientAddress(int rep) { 
        XAD ret = null;
        try {
            Type t = this.getField(11, rep);
            ret = (XAD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PID-11: "Patient Address" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XAD getPid11_PatientAddress(int rep) { 
        XAD ret = null;
        try {
            Type t = this.getField(11, rep);
            ret = (XAD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * PID-11: "Patient Address" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XAD insertPatientAddress(int rep) throws HL7Exception { 
        return (XAD) super.insertRepetition(11, rep);
    }



    /**
     * Inserts a repetition of
     * PID-11: "Patient Address" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XAD insertPid11_PatientAddress(int rep) throws HL7Exception { 
        return (XAD) super.insertRepetition(11, rep);
    }


    /**
     * Removes a repetition of
     * PID-11: "Patient Address" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XAD removePatientAddress(int rep) throws HL7Exception { 
        return (XAD) super.removeRepetition(11, rep);
    }


    /**
     * Removes a repetition of
     * PID-11: "Patient Address" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XAD removePid11_PatientAddress(int rep) throws HL7Exception { 
        return (XAD) super.removeRepetition(11, rep);
    }




    /**
     * Returns
     * PID-12: "County Code" - creates it if necessary
     */
    public IS getCountyCode() { 
        IS ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PID-12: "County Code" - creates it if necessary
     */
    public IS getPid12_CountyCode() { 
        IS ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Phone Number - Home (PID-13).
     */
    public XTN[] getPhoneNumberHome() {
        XTN[] ret = null;
        try {
            Type[] t = this.getField(13);  
            ret = new XTN[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (XTN)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PID-13: "Phone Number - Home" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XTN getPhoneNumberHome(int rep) { 
        XTN ret = null;
        try {
            Type t = this.getField(13, rep);
            ret = (XTN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PID-13: "Phone Number - Home" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XTN getPid13_PhoneNumberHome(int rep) { 
        XTN ret = null;
        try {
            Type t = this.getField(13, rep);
            ret = (XTN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * PID-13: "Phone Number - Home" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN insertPhoneNumberHome(int rep) throws HL7Exception { 
        return (XTN) super.insertRepetition(13, rep);
    }



    /**
     * Inserts a repetition of
     * PID-13: "Phone Number - Home" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN insertPid13_PhoneNumberHome(int rep) throws HL7Exception { 
        return (XTN) super.insertRepetition(13, rep);
    }


    /**
     * Removes a repetition of
     * PID-13: "Phone Number - Home" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN removePhoneNumberHome(int rep) throws HL7Exception { 
        return (XTN) super.removeRepetition(13, rep);
    }


    /**
     * Removes a repetition of
     * PID-13: "Phone Number - Home" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN removePid13_PhoneNumberHome(int rep) throws HL7Exception { 
        return (XTN) super.removeRepetition(13, rep);
    }



    /**
     * Returns all repetitions of Phone Number - Business (PID-14).
     */
    public XTN[] getPhoneNumberBusiness() {
        XTN[] ret = null;
        try {
            Type[] t = this.getField(14);  
            ret = new XTN[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (XTN)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PID-14: "Phone Number - Business" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XTN getPhoneNumberBusiness(int rep) { 
        XTN ret = null;
        try {
            Type t = this.getField(14, rep);
            ret = (XTN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PID-14: "Phone Number - Business" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XTN getPid14_PhoneNumberBusiness(int rep) { 
        XTN ret = null;
        try {
            Type t = this.getField(14, rep);
            ret = (XTN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * PID-14: "Phone Number - Business" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN insertPhoneNumberBusiness(int rep) throws HL7Exception { 
        return (XTN) super.insertRepetition(14, rep);
    }



    /**
     * Inserts a repetition of
     * PID-14: "Phone Number - Business" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN insertPid14_PhoneNumberBusiness(int rep) throws HL7Exception { 
        return (XTN) super.insertRepetition(14, rep);
    }


    /**
     * Removes a repetition of
     * PID-14: "Phone Number - Business" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN removePhoneNumberBusiness(int rep) throws HL7Exception { 
        return (XTN) super.removeRepetition(14, rep);
    }


    /**
     * Removes a repetition of
     * PID-14: "Phone Number - Business" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN removePid14_PhoneNumberBusiness(int rep) throws HL7Exception { 
        return (XTN) super.removeRepetition(14, rep);
    }




    /**
     * Returns
     * PID-15: "Primary Language" - creates it if necessary
     */
    public CWE getPrimaryLanguage() { 
        CWE ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PID-15: "Primary Language" - creates it if necessary
     */
    public CWE getPid15_PrimaryLanguage() { 
        CWE ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PID-16: "Marital Status" - creates it if necessary
     */
    public CWE getMaritalStatus() { 
        CWE ret = null;
        try {
            Type t = this.getField(16, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PID-16: "Marital Status" - creates it if necessary
     */
    public CWE getPid16_MaritalStatus() { 
        CWE ret = null;
        try {
            Type t = this.getField(16, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PID-17: "Religion" - creates it if necessary
     */
    public CWE getReligion() { 
        CWE ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PID-17: "Religion" - creates it if necessary
     */
    public CWE getPid17_Religion() { 
        CWE ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PID-18: "Patient Account Number" - creates it if necessary
     */
    public CX getPatientAccountNumber() { 
        CX ret = null;
        try {
            Type t = this.getField(18, 0);
            ret = (CX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PID-18: "Patient Account Number" - creates it if necessary
     */
    public CX getPid18_PatientAccountNumber() { 
        CX ret = null;
        try {
            Type t = this.getField(18, 0);
            ret = (CX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PID-19: "SSN Number - Patient" - creates it if necessary
     */
    public ST getSSNNumberPatient() { 
        ST ret = null;
        try {
            Type t = this.getField(19, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PID-19: "SSN Number - Patient" - creates it if necessary
     */
    public ST getPid19_SSNNumberPatient() { 
        ST ret = null;
        try {
            Type t = this.getField(19, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PID-20: "Driver's License Number - Patient" - creates it if necessary
     */
    public DLN getDriverSLicenseNumberPatient() { 
        DLN ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (DLN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PID-20: "Driver's License Number - Patient" - creates it if necessary
     */
    public DLN getPid20_DriverSLicenseNumberPatient() { 
        DLN ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (DLN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Mother's Identifier (PID-21).
     */
    public CX[] getMotherSIdentifier() {
        CX[] ret = null;
        try {
            Type[] t = this.getField(21);  
            ret = new CX[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CX)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PID-21: "Mother's Identifier" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CX getMotherSIdentifier(int rep) { 
        CX ret = null;
        try {
            Type t = this.getField(21, rep);
            ret = (CX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PID-21: "Mother's Identifier" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CX getPid21_MotherSIdentifier(int rep) { 
        CX ret = null;
        try {
            Type t = this.getField(21, rep);
            ret = (CX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * PID-21: "Mother's Identifier" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CX insertMotherSIdentifier(int rep) throws HL7Exception { 
        return (CX) super.insertRepetition(21, rep);
    }



    /**
     * Inserts a repetition of
     * PID-21: "Mother's Identifier" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CX insertPid21_MotherSIdentifier(int rep) throws HL7Exception { 
        return (CX) super.insertRepetition(21, rep);
    }


    /**
     * Removes a repetition of
     * PID-21: "Mother's Identifier" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CX removeMotherSIdentifier(int rep) throws HL7Exception { 
        return (CX) super.removeRepetition(21, rep);
    }


    /**
     * Removes a repetition of
     * PID-21: "Mother's Identifier" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CX removePid21_MotherSIdentifier(int rep) throws HL7Exception { 
        return (CX) super.removeRepetition(21, rep);
    }



    /**
     * Returns all repetitions of Ethnic Group (PID-22).
     */
    public CWE[] getEthnicGroup() {
        CWE[] ret = null;
        try {
            Type[] t = this.getField(22);  
            ret = new CWE[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CWE)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PID-22: "Ethnic Group" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CWE getEthnicGroup(int rep) { 
        CWE ret = null;
        try {
            Type t = this.getField(22, rep);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PID-22: "Ethnic Group" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CWE getPid22_EthnicGroup(int rep) { 
        CWE ret = null;
        try {
            Type t = this.getField(22, rep);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * PID-22: "Ethnic Group" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE insertEthnicGroup(int rep) throws HL7Exception { 
        return (CWE) super.insertRepetition(22, rep);
    }



    /**
     * Inserts a repetition of
     * PID-22: "Ethnic Group" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE insertPid22_EthnicGroup(int rep) throws HL7Exception { 
        return (CWE) super.insertRepetition(22, rep);
    }


    /**
     * Removes a repetition of
     * PID-22: "Ethnic Group" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE removeEthnicGroup(int rep) throws HL7Exception { 
        return (CWE) super.removeRepetition(22, rep);
    }


    /**
     * Removes a repetition of
     * PID-22: "Ethnic Group" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE removePid22_EthnicGroup(int rep) throws HL7Exception { 
        return (CWE) super.removeRepetition(22, rep);
    }




    /**
     * Returns
     * PID-23: "Birth Place" - creates it if necessary
     */
    public ST getBirthPlace() { 
        ST ret = null;
        try {
            Type t = this.getField(23, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PID-23: "Birth Place" - creates it if necessary
     */
    public ST getPid23_BirthPlace() { 
        ST ret = null;
        try {
            Type t = this.getField(23, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PID-24: "Multiple Birth Indicator" - creates it if necessary
     */
    public ID getMultipleBirthIndicator() { 
        ID ret = null;
        try {
            Type t = this.getField(24, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PID-24: "Multiple Birth Indicator" - creates it if necessary
     */
    public ID getPid24_MultipleBirthIndicator() { 
        ID ret = null;
        try {
            Type t = this.getField(24, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PID-25: "Birth Order" - creates it if necessary
     */
    public NM getBirthOrder() { 
        NM ret = null;
        try {
            Type t = this.getField(25, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PID-25: "Birth Order" - creates it if necessary
     */
    public NM getPid25_BirthOrder() { 
        NM ret = null;
        try {
            Type t = this.getField(25, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Citizenship (PID-26).
     */
    public CWE[] getCitizenship() {
        CWE[] ret = null;
        try {
            Type[] t = this.getField(26);  
            ret = new CWE[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CWE)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PID-26: "Citizenship" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CWE getCitizenship(int rep) { 
        CWE ret = null;
        try {
            Type t = this.getField(26, rep);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PID-26: "Citizenship" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CWE getPid26_Citizenship(int rep) { 
        CWE ret = null;
        try {
            Type t = this.getField(26, rep);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * PID-26: "Citizenship" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE insertCitizenship(int rep) throws HL7Exception { 
        return (CWE) super.insertRepetition(26, rep);
    }



    /**
     * Inserts a repetition of
     * PID-26: "Citizenship" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE insertPid26_Citizenship(int rep) throws HL7Exception { 
        return (CWE) super.insertRepetition(26, rep);
    }


    /**
     * Removes a repetition of
     * PID-26: "Citizenship" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE removeCitizenship(int rep) throws HL7Exception { 
        return (CWE) super.removeRepetition(26, rep);
    }


    /**
     * Removes a repetition of
     * PID-26: "Citizenship" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE removePid26_Citizenship(int rep) throws HL7Exception { 
        return (CWE) super.removeRepetition(26, rep);
    }




    /**
     * Returns
     * PID-27: "Veterans Military Status" - creates it if necessary
     */
    public CWE getVeteransMilitaryStatus() { 
        CWE ret = null;
        try {
            Type t = this.getField(27, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PID-27: "Veterans Military Status" - creates it if necessary
     */
    public CWE getPid27_VeteransMilitaryStatus() { 
        CWE ret = null;
        try {
            Type t = this.getField(27, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PID-28: "Nationality" - creates it if necessary
     */
    public CWE getNationality() { 
        CWE ret = null;
        try {
            Type t = this.getField(28, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PID-28: "Nationality" - creates it if necessary
     */
    public CWE getPid28_Nationality() { 
        CWE ret = null;
        try {
            Type t = this.getField(28, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PID-29: "Patient Death Date and Time" - creates it if necessary
     */
    public DTM getPatientDeathDateAndTime() { 
        DTM ret = null;
        try {
            Type t = this.getField(29, 0);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PID-29: "Patient Death Date and Time" - creates it if necessary
     */
    public DTM getPid29_PatientDeathDateAndTime() { 
        DTM ret = null;
        try {
            Type t = this.getField(29, 0);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PID-30: "Patient Death Indicator" - creates it if necessary
     */
    public ID getPatientDeathIndicator() { 
        ID ret = null;
        try {
            Type t = this.getField(30, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PID-30: "Patient Death Indicator" - creates it if necessary
     */
    public ID getPid30_PatientDeathIndicator() { 
        ID ret = null;
        try {
            Type t = this.getField(30, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PID-31: "Identity Unknown Indicator" - creates it if necessary
     */
    public ID getIdentityUnknownIndicator() { 
        ID ret = null;
        try {
            Type t = this.getField(31, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PID-31: "Identity Unknown Indicator" - creates it if necessary
     */
    public ID getPid31_IdentityUnknownIndicator() { 
        ID ret = null;
        try {
            Type t = this.getField(31, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Identity Reliability Code (PID-32).
     */
    public IS[] getIdentityReliabilityCode() {
        IS[] ret = null;
        try {
            Type[] t = this.getField(32);  
            ret = new IS[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (IS)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PID-32: "Identity Reliability Code" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public IS getIdentityReliabilityCode(int rep) { 
        IS ret = null;
        try {
            Type t = this.getField(32, rep);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PID-32: "Identity Reliability Code" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public IS getPid32_IdentityReliabilityCode(int rep) { 
        IS ret = null;
        try {
            Type t = this.getField(32, rep);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * PID-32: "Identity Reliability Code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public IS insertIdentityReliabilityCode(int rep) throws HL7Exception { 
        return (IS) super.insertRepetition(32, rep);
    }



    /**
     * Inserts a repetition of
     * PID-32: "Identity Reliability Code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public IS insertPid32_IdentityReliabilityCode(int rep) throws HL7Exception { 
        return (IS) super.insertRepetition(32, rep);
    }


    /**
     * Removes a repetition of
     * PID-32: "Identity Reliability Code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public IS removeIdentityReliabilityCode(int rep) throws HL7Exception { 
        return (IS) super.removeRepetition(32, rep);
    }


    /**
     * Removes a repetition of
     * PID-32: "Identity Reliability Code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public IS removePid32_IdentityReliabilityCode(int rep) throws HL7Exception { 
        return (IS) super.removeRepetition(32, rep);
    }




    /**
     * Returns
     * PID-33: "Last Update Date/Time" - creates it if necessary
     */
    public DTM getLastUpdateDateTime() { 
        DTM ret = null;
        try {
            Type t = this.getField(33, 0);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PID-33: "Last Update Date/Time" - creates it if necessary
     */
    public DTM getPid33_LastUpdateDateTime() { 
        DTM ret = null;
        try {
            Type t = this.getField(33, 0);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PID-34: "Last Update Facility" - creates it if necessary
     */
    public HD getLastUpdateFacility() { 
        HD ret = null;
        try {
            Type t = this.getField(34, 0);
            ret = (HD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PID-34: "Last Update Facility" - creates it if necessary
     */
    public HD getPid34_LastUpdateFacility() { 
        HD ret = null;
        try {
            Type t = this.getField(34, 0);
            ret = (HD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PID-35: "Species Code" - creates it if necessary
     */
    public CWE getSpeciesCode() { 
        CWE ret = null;
        try {
            Type t = this.getField(35, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PID-35: "Species Code" - creates it if necessary
     */
    public CWE getPid35_SpeciesCode() { 
        CWE ret = null;
        try {
            Type t = this.getField(35, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PID-36: "Breed Code" - creates it if necessary
     */
    public CWE getBreedCode() { 
        CWE ret = null;
        try {
            Type t = this.getField(36, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PID-36: "Breed Code" - creates it if necessary
     */
    public CWE getPid36_BreedCode() { 
        CWE ret = null;
        try {
            Type t = this.getField(36, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PID-37: "Strain" - creates it if necessary
     */
    public ST getStrain() { 
        ST ret = null;
        try {
            Type t = this.getField(37, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PID-37: "Strain" - creates it if necessary
     */
    public ST getPid37_Strain() { 
        ST ret = null;
        try {
            Type t = this.getField(37, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PID-38: "Production Class Code" - creates it if necessary
     */
    public CWE getProductionClassCode() { 
        CWE ret = null;
        try {
            Type t = this.getField(38, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PID-38: "Production Class Code" - creates it if necessary
     */
    public CWE getPid38_ProductionClassCode() { 
        CWE ret = null;
        try {
            Type t = this.getField(38, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Tribal Citizenship (PID-39).
     */
    public CWE[] getTribalCitizenship() {
        CWE[] ret = null;
        try {
            Type[] t = this.getField(39);  
            ret = new CWE[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CWE)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PID-39: "Tribal Citizenship" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CWE getTribalCitizenship(int rep) { 
        CWE ret = null;
        try {
            Type t = this.getField(39, rep);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PID-39: "Tribal Citizenship" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CWE getPid39_TribalCitizenship(int rep) { 
        CWE ret = null;
        try {
            Type t = this.getField(39, rep);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * PID-39: "Tribal Citizenship" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE insertTribalCitizenship(int rep) throws HL7Exception { 
        return (CWE) super.insertRepetition(39, rep);
    }



    /**
     * Inserts a repetition of
     * PID-39: "Tribal Citizenship" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE insertPid39_TribalCitizenship(int rep) throws HL7Exception { 
        return (CWE) super.insertRepetition(39, rep);
    }


    /**
     * Removes a repetition of
     * PID-39: "Tribal Citizenship" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE removeTribalCitizenship(int rep) throws HL7Exception { 
        return (CWE) super.removeRepetition(39, rep);
    }


    /**
     * Removes a repetition of
     * PID-39: "Tribal Citizenship" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE removePid39_TribalCitizenship(int rep) throws HL7Exception { 
        return (CWE) super.removeRepetition(39, rep);
    }






    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new SI(getMessage());
          case 1: return new CX(getMessage());
          case 2: return new CX(getMessage());
          case 3: return new CX(getMessage());
          case 4: return new XPN(getMessage());
          case 5: return new XPN(getMessage());
          case 6: return new DTM(getMessage());
          case 7: return new IS(getMessage(), new Integer( 1 ));
          case 8: return new XPN(getMessage());
          case 9: return new CWE(getMessage());
          case 10: return new XAD(getMessage());
          case 11: return new IS(getMessage(), new Integer( 289 ));
          case 12: return new XTN(getMessage());
          case 13: return new XTN(getMessage());
          case 14: return new CWE(getMessage());
          case 15: return new CWE(getMessage());
          case 16: return new CWE(getMessage());
          case 17: return new CX(getMessage());
          case 18: return new ST(getMessage());
          case 19: return new DLN(getMessage());
          case 20: return new CX(getMessage());
          case 21: return new CWE(getMessage());
          case 22: return new ST(getMessage());
          case 23: return new ID(getMessage(), new Integer( 136 ));
          case 24: return new NM(getMessage());
          case 25: return new CWE(getMessage());
          case 26: return new CWE(getMessage());
          case 27: return new CWE(getMessage());
          case 28: return new DTM(getMessage());
          case 29: return new ID(getMessage(), new Integer( 136 ));
          case 30: return new ID(getMessage(), new Integer( 136 ));
          case 31: return new IS(getMessage(), new Integer( 445 ));
          case 32: return new DTM(getMessage());
          case 33: return new HD(getMessage());
          case 34: return new CWE(getMessage());
          case 35: return new CWE(getMessage());
          case 36: return new ST(getMessage());
          case 37: return new CWE(getMessage());
          case 38: return new CWE(getMessage());
          default: return null;
       }
   }


}

