/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v26.segment;

// import ca.uhn.hl7v2.model.v26.group.*;
import ca.uhn.hl7v2.model.v26.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 PKG message segment (Item Packaging). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>PKG-1: Set Id - PKG (SI) <b> </b>
     * <li>PKG-2: Packaging Units (CWE) <b>optional </b>
     * <li>PKG-3: Default Order Unit Of Measure Indicator (CNE) <b>optional </b>
     * <li>PKG-4: Package Quantity (NM) <b>optional </b>
     * <li>PKG-5: Price (CP) <b>optional </b>
     * <li>PKG-6: Future Item Price (CP) <b>optional </b>
     * <li>PKG-7: Future Item Price Effective Date (DTM) <b>optional </b>
 * </ul>
 */
public class PKG extends AbstractSegment {

    /** 
     * Creates a new PKG segment
     */
    public PKG(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(SI.class, true, 1, 2, new Object[]{ getMessage(), new Integer(0) }, "Set Id - PKG");
                                  this.add(CWE.class, false, 1, 250, new Object[]{ getMessage(), new Integer(818) }, "Packaging Units");
                                  this.add(CNE.class, false, 1, 1, new Object[]{ getMessage(), new Integer(532) }, "Default Order Unit Of Measure Indicator");
                                  this.add(NM.class, false, 1, 12, new Object[]{ getMessage(), new Integer(0) }, "Package Quantity");
                                  this.add(CP.class, false, 1, 12, new Object[]{ getMessage(), new Integer(0) }, "Price");
                                  this.add(CP.class, false, 1, 12, new Object[]{ getMessage(), new Integer(0) }, "Future Item Price");
                                  this.add(DTM.class, false, 1, 24, new Object[]{ getMessage(), new Integer(0) }, "Future Item Price Effective Date");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating PKG - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * PKG-1: "Set Id - PKG" - creates it if necessary
     */
    public SI getSetIdPKG() { 
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PKG-1: "Set Id - PKG" - creates it if necessary
     */
    public SI getPkg1_SetIdPKG() { 
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PKG-2: "Packaging Units" - creates it if necessary
     */
    public CWE getPackagingUnits() { 
        CWE ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PKG-2: "Packaging Units" - creates it if necessary
     */
    public CWE getPkg2_PackagingUnits() { 
        CWE ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PKG-3: "Default Order Unit Of Measure Indicator" - creates it if necessary
     */
    public CNE getDefaultOrderUnitOfMeasureIndicator() { 
        CNE ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PKG-3: "Default Order Unit Of Measure Indicator" - creates it if necessary
     */
    public CNE getPkg3_DefaultOrderUnitOfMeasureIndicator() { 
        CNE ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PKG-4: "Package Quantity" - creates it if necessary
     */
    public NM getPackageQuantity() { 
        NM ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PKG-4: "Package Quantity" - creates it if necessary
     */
    public NM getPkg4_PackageQuantity() { 
        NM ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PKG-5: "Price" - creates it if necessary
     */
    public CP getPrice() { 
        CP ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PKG-5: "Price" - creates it if necessary
     */
    public CP getPkg5_Price() { 
        CP ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PKG-6: "Future Item Price" - creates it if necessary
     */
    public CP getFutureItemPrice() { 
        CP ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PKG-6: "Future Item Price" - creates it if necessary
     */
    public CP getPkg6_FutureItemPrice() { 
        CP ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PKG-7: "Future Item Price Effective Date" - creates it if necessary
     */
    public DTM getFutureItemPriceEffectiveDate() { 
        DTM ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PKG-7: "Future Item Price Effective Date" - creates it if necessary
     */
    public DTM getPkg7_FutureItemPriceEffectiveDate() { 
        DTM ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new SI(getMessage());
          case 1: return new CWE(getMessage());
          case 2: return new CNE(getMessage());
          case 3: return new NM(getMessage());
          case 4: return new CP(getMessage());
          case 5: return new CP(getMessage());
          case 6: return new DTM(getMessage());
          default: return null;
       }
   }


}

