/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v26.segment;

// import ca.uhn.hl7v2.model.v26.group.*;
import ca.uhn.hl7v2.model.v26.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 PRD message segment (Provider Data). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>PRD-1: Provider Role (CWE) <b> repeating</b>
     * <li>PRD-2: Provider Name (XPN) <b>optional repeating</b>
     * <li>PRD-3: Provider Address (XAD) <b>optional repeating</b>
     * <li>PRD-4: Provider Location (PL) <b>optional </b>
     * <li>PRD-5: Provider Communication Information (XTN) <b>optional repeating</b>
     * <li>PRD-6: Preferred Method of Contact (CWE) <b>optional </b>
     * <li>PRD-7: Provider Identifiers (PLN) <b>optional repeating</b>
     * <li>PRD-8: Effective Start Date of Provider Role (DTM) <b>optional </b>
     * <li>PRD-9: Effective End Date of Provider Role (DTM) <b>optional repeating</b>
     * <li>PRD-10: Provider Organization Name and Identifier (XON) <b>optional </b>
     * <li>PRD-11: Provider Organization Address (XAD) <b>optional repeating</b>
     * <li>PRD-12: Provider Organization Location Information (PL) <b>optional repeating</b>
     * <li>PRD-13: Provider Organization Communication Information (XTN) <b>optional repeating</b>
     * <li>PRD-14: Provider Organization Method of Contact (CWE) <b>optional </b>
 * </ul>
 */
public class PRD extends AbstractSegment {

    /** 
     * Creates a new PRD segment
     */
    public PRD(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(CWE.class, true, 0, 705, new Object[]{ getMessage(), new Integer(286) }, "Provider Role");
                                  this.add(XPN.class, false, 0, 250, new Object[]{ getMessage(), new Integer(0) }, "Provider Name");
                                  this.add(XAD.class, false, 0, 250, new Object[]{ getMessage(), new Integer(0) }, "Provider Address");
                                  this.add(PL.class, false, 1, 60, new Object[]{ getMessage(), new Integer(0) }, "Provider Location");
                                  this.add(XTN.class, false, 0, 250, new Object[]{ getMessage(), new Integer(0) }, "Provider Communication Information");
                                  this.add(CWE.class, false, 1, 705, new Object[]{ getMessage(), new Integer(185) }, "Preferred Method of Contact");
                                  this.add(PLN.class, false, 0, 100, new Object[]{ getMessage(), new Integer(338) }, "Provider Identifiers");
                                  this.add(DTM.class, false, 1, 24, new Object[]{ getMessage(), new Integer(0) }, "Effective Start Date of Provider Role");
                                  this.add(DTM.class, false, 0, 24, new Object[]{ getMessage(), new Integer(0) }, "Effective End Date of Provider Role");
                                  this.add(XON.class, false, 1, 250, new Object[]{ getMessage(), new Integer(0) }, "Provider Organization Name and Identifier");
                                  this.add(XAD.class, false, 0, 60, new Object[]{ getMessage(), new Integer(0) }, "Provider Organization Address");
                                  this.add(PL.class, false, 0, 60, new Object[]{ getMessage(), new Integer(0) }, "Provider Organization Location Information");
                                  this.add(XTN.class, false, 0, 250, new Object[]{ getMessage(), new Integer(0) }, "Provider Organization Communication Information");
                                  this.add(CWE.class, false, 1, 705, new Object[]{ getMessage(), new Integer(185) }, "Provider Organization Method of Contact");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating PRD - this is probably a bug in the source code generator.", e);
       }
    }


    /**
     * Returns all repetitions of Provider Role (PRD-1).
     */
    public CWE[] getProviderRole() {
        CWE[] ret = null;
        try {
            Type[] t = this.getField(1);  
            ret = new CWE[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CWE)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PRD-1: "Provider Role" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CWE getProviderRole(int rep) { 
        CWE ret = null;
        try {
            Type t = this.getField(1, rep);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PRD-1: "Provider Role" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CWE getPrd1_ProviderRole(int rep) { 
        CWE ret = null;
        try {
            Type t = this.getField(1, rep);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * PRD-1: "Provider Role" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE insertProviderRole(int rep) throws HL7Exception { 
        return (CWE) super.insertRepetition(1, rep);
    }



    /**
     * Inserts a repetition of
     * PRD-1: "Provider Role" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE insertPrd1_ProviderRole(int rep) throws HL7Exception { 
        return (CWE) super.insertRepetition(1, rep);
    }


    /**
     * Removes a repetition of
     * PRD-1: "Provider Role" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE removeProviderRole(int rep) throws HL7Exception { 
        return (CWE) super.removeRepetition(1, rep);
    }


    /**
     * Removes a repetition of
     * PRD-1: "Provider Role" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE removePrd1_ProviderRole(int rep) throws HL7Exception { 
        return (CWE) super.removeRepetition(1, rep);
    }



    /**
     * Returns all repetitions of Provider Name (PRD-2).
     */
    public XPN[] getProviderName() {
        XPN[] ret = null;
        try {
            Type[] t = this.getField(2);  
            ret = new XPN[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (XPN)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PRD-2: "Provider Name" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XPN getProviderName(int rep) { 
        XPN ret = null;
        try {
            Type t = this.getField(2, rep);
            ret = (XPN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PRD-2: "Provider Name" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XPN getPrd2_ProviderName(int rep) { 
        XPN ret = null;
        try {
            Type t = this.getField(2, rep);
            ret = (XPN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * PRD-2: "Provider Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XPN insertProviderName(int rep) throws HL7Exception { 
        return (XPN) super.insertRepetition(2, rep);
    }



    /**
     * Inserts a repetition of
     * PRD-2: "Provider Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XPN insertPrd2_ProviderName(int rep) throws HL7Exception { 
        return (XPN) super.insertRepetition(2, rep);
    }


    /**
     * Removes a repetition of
     * PRD-2: "Provider Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XPN removeProviderName(int rep) throws HL7Exception { 
        return (XPN) super.removeRepetition(2, rep);
    }


    /**
     * Removes a repetition of
     * PRD-2: "Provider Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XPN removePrd2_ProviderName(int rep) throws HL7Exception { 
        return (XPN) super.removeRepetition(2, rep);
    }



    /**
     * Returns all repetitions of Provider Address (PRD-3).
     */
    public XAD[] getProviderAddress() {
        XAD[] ret = null;
        try {
            Type[] t = this.getField(3);  
            ret = new XAD[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (XAD)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PRD-3: "Provider Address" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XAD getProviderAddress(int rep) { 
        XAD ret = null;
        try {
            Type t = this.getField(3, rep);
            ret = (XAD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PRD-3: "Provider Address" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XAD getPrd3_ProviderAddress(int rep) { 
        XAD ret = null;
        try {
            Type t = this.getField(3, rep);
            ret = (XAD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * PRD-3: "Provider Address" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XAD insertProviderAddress(int rep) throws HL7Exception { 
        return (XAD) super.insertRepetition(3, rep);
    }



    /**
     * Inserts a repetition of
     * PRD-3: "Provider Address" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XAD insertPrd3_ProviderAddress(int rep) throws HL7Exception { 
        return (XAD) super.insertRepetition(3, rep);
    }


    /**
     * Removes a repetition of
     * PRD-3: "Provider Address" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XAD removeProviderAddress(int rep) throws HL7Exception { 
        return (XAD) super.removeRepetition(3, rep);
    }


    /**
     * Removes a repetition of
     * PRD-3: "Provider Address" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XAD removePrd3_ProviderAddress(int rep) throws HL7Exception { 
        return (XAD) super.removeRepetition(3, rep);
    }




    /**
     * Returns
     * PRD-4: "Provider Location" - creates it if necessary
     */
    public PL getProviderLocation() { 
        PL ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (PL)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PRD-4: "Provider Location" - creates it if necessary
     */
    public PL getPrd4_ProviderLocation() { 
        PL ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (PL)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Provider Communication Information (PRD-5).
     */
    public XTN[] getProviderCommunicationInformation() {
        XTN[] ret = null;
        try {
            Type[] t = this.getField(5);  
            ret = new XTN[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (XTN)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PRD-5: "Provider Communication Information" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XTN getProviderCommunicationInformation(int rep) { 
        XTN ret = null;
        try {
            Type t = this.getField(5, rep);
            ret = (XTN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PRD-5: "Provider Communication Information" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XTN getPrd5_ProviderCommunicationInformation(int rep) { 
        XTN ret = null;
        try {
            Type t = this.getField(5, rep);
            ret = (XTN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * PRD-5: "Provider Communication Information" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN insertProviderCommunicationInformation(int rep) throws HL7Exception { 
        return (XTN) super.insertRepetition(5, rep);
    }



    /**
     * Inserts a repetition of
     * PRD-5: "Provider Communication Information" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN insertPrd5_ProviderCommunicationInformation(int rep) throws HL7Exception { 
        return (XTN) super.insertRepetition(5, rep);
    }


    /**
     * Removes a repetition of
     * PRD-5: "Provider Communication Information" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN removeProviderCommunicationInformation(int rep) throws HL7Exception { 
        return (XTN) super.removeRepetition(5, rep);
    }


    /**
     * Removes a repetition of
     * PRD-5: "Provider Communication Information" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN removePrd5_ProviderCommunicationInformation(int rep) throws HL7Exception { 
        return (XTN) super.removeRepetition(5, rep);
    }




    /**
     * Returns
     * PRD-6: "Preferred Method of Contact" - creates it if necessary
     */
    public CWE getPreferredMethodOfContact() { 
        CWE ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PRD-6: "Preferred Method of Contact" - creates it if necessary
     */
    public CWE getPrd6_PreferredMethodOfContact() { 
        CWE ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Provider Identifiers (PRD-7).
     */
    public PLN[] getProviderIdentifiers() {
        PLN[] ret = null;
        try {
            Type[] t = this.getField(7);  
            ret = new PLN[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (PLN)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PRD-7: "Provider Identifiers" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public PLN getProviderIdentifiers(int rep) { 
        PLN ret = null;
        try {
            Type t = this.getField(7, rep);
            ret = (PLN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PRD-7: "Provider Identifiers" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public PLN getPrd7_ProviderIdentifiers(int rep) { 
        PLN ret = null;
        try {
            Type t = this.getField(7, rep);
            ret = (PLN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * PRD-7: "Provider Identifiers" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public PLN insertProviderIdentifiers(int rep) throws HL7Exception { 
        return (PLN) super.insertRepetition(7, rep);
    }



    /**
     * Inserts a repetition of
     * PRD-7: "Provider Identifiers" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public PLN insertPrd7_ProviderIdentifiers(int rep) throws HL7Exception { 
        return (PLN) super.insertRepetition(7, rep);
    }


    /**
     * Removes a repetition of
     * PRD-7: "Provider Identifiers" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public PLN removeProviderIdentifiers(int rep) throws HL7Exception { 
        return (PLN) super.removeRepetition(7, rep);
    }


    /**
     * Removes a repetition of
     * PRD-7: "Provider Identifiers" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public PLN removePrd7_ProviderIdentifiers(int rep) throws HL7Exception { 
        return (PLN) super.removeRepetition(7, rep);
    }




    /**
     * Returns
     * PRD-8: "Effective Start Date of Provider Role" - creates it if necessary
     */
    public DTM getEffectiveStartDateOfProviderRole() { 
        DTM ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PRD-8: "Effective Start Date of Provider Role" - creates it if necessary
     */
    public DTM getPrd8_EffectiveStartDateOfProviderRole() { 
        DTM ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Effective End Date of Provider Role (PRD-9).
     */
    public DTM[] getEffectiveEndDateOfProviderRole() {
        DTM[] ret = null;
        try {
            Type[] t = this.getField(9);  
            ret = new DTM[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (DTM)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PRD-9: "Effective End Date of Provider Role" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public DTM getEffectiveEndDateOfProviderRole(int rep) { 
        DTM ret = null;
        try {
            Type t = this.getField(9, rep);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PRD-9: "Effective End Date of Provider Role" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public DTM getPrd9_EffectiveEndDateOfProviderRole(int rep) { 
        DTM ret = null;
        try {
            Type t = this.getField(9, rep);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * PRD-9: "Effective End Date of Provider Role" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public DTM insertEffectiveEndDateOfProviderRole(int rep) throws HL7Exception { 
        return (DTM) super.insertRepetition(9, rep);
    }



    /**
     * Inserts a repetition of
     * PRD-9: "Effective End Date of Provider Role" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public DTM insertPrd9_EffectiveEndDateOfProviderRole(int rep) throws HL7Exception { 
        return (DTM) super.insertRepetition(9, rep);
    }


    /**
     * Removes a repetition of
     * PRD-9: "Effective End Date of Provider Role" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public DTM removeEffectiveEndDateOfProviderRole(int rep) throws HL7Exception { 
        return (DTM) super.removeRepetition(9, rep);
    }


    /**
     * Removes a repetition of
     * PRD-9: "Effective End Date of Provider Role" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public DTM removePrd9_EffectiveEndDateOfProviderRole(int rep) throws HL7Exception { 
        return (DTM) super.removeRepetition(9, rep);
    }




    /**
     * Returns
     * PRD-10: "Provider Organization Name and Identifier" - creates it if necessary
     */
    public XON getProviderOrganizationNameAndIdentifier() { 
        XON ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (XON)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PRD-10: "Provider Organization Name and Identifier" - creates it if necessary
     */
    public XON getPrd10_ProviderOrganizationNameAndIdentifier() { 
        XON ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (XON)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Provider Organization Address (PRD-11).
     */
    public XAD[] getProviderOrganizationAddress() {
        XAD[] ret = null;
        try {
            Type[] t = this.getField(11);  
            ret = new XAD[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (XAD)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PRD-11: "Provider Organization Address" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XAD getProviderOrganizationAddress(int rep) { 
        XAD ret = null;
        try {
            Type t = this.getField(11, rep);
            ret = (XAD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PRD-11: "Provider Organization Address" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XAD getPrd11_ProviderOrganizationAddress(int rep) { 
        XAD ret = null;
        try {
            Type t = this.getField(11, rep);
            ret = (XAD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * PRD-11: "Provider Organization Address" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XAD insertProviderOrganizationAddress(int rep) throws HL7Exception { 
        return (XAD) super.insertRepetition(11, rep);
    }



    /**
     * Inserts a repetition of
     * PRD-11: "Provider Organization Address" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XAD insertPrd11_ProviderOrganizationAddress(int rep) throws HL7Exception { 
        return (XAD) super.insertRepetition(11, rep);
    }


    /**
     * Removes a repetition of
     * PRD-11: "Provider Organization Address" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XAD removeProviderOrganizationAddress(int rep) throws HL7Exception { 
        return (XAD) super.removeRepetition(11, rep);
    }


    /**
     * Removes a repetition of
     * PRD-11: "Provider Organization Address" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XAD removePrd11_ProviderOrganizationAddress(int rep) throws HL7Exception { 
        return (XAD) super.removeRepetition(11, rep);
    }



    /**
     * Returns all repetitions of Provider Organization Location Information (PRD-12).
     */
    public PL[] getProviderOrganizationLocationInformation() {
        PL[] ret = null;
        try {
            Type[] t = this.getField(12);  
            ret = new PL[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (PL)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PRD-12: "Provider Organization Location Information" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public PL getProviderOrganizationLocationInformation(int rep) { 
        PL ret = null;
        try {
            Type t = this.getField(12, rep);
            ret = (PL)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PRD-12: "Provider Organization Location Information" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public PL getPrd12_ProviderOrganizationLocationInformation(int rep) { 
        PL ret = null;
        try {
            Type t = this.getField(12, rep);
            ret = (PL)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * PRD-12: "Provider Organization Location Information" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public PL insertProviderOrganizationLocationInformation(int rep) throws HL7Exception { 
        return (PL) super.insertRepetition(12, rep);
    }



    /**
     * Inserts a repetition of
     * PRD-12: "Provider Organization Location Information" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public PL insertPrd12_ProviderOrganizationLocationInformation(int rep) throws HL7Exception { 
        return (PL) super.insertRepetition(12, rep);
    }


    /**
     * Removes a repetition of
     * PRD-12: "Provider Organization Location Information" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public PL removeProviderOrganizationLocationInformation(int rep) throws HL7Exception { 
        return (PL) super.removeRepetition(12, rep);
    }


    /**
     * Removes a repetition of
     * PRD-12: "Provider Organization Location Information" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public PL removePrd12_ProviderOrganizationLocationInformation(int rep) throws HL7Exception { 
        return (PL) super.removeRepetition(12, rep);
    }



    /**
     * Returns all repetitions of Provider Organization Communication Information (PRD-13).
     */
    public XTN[] getProviderOrganizationCommunicationInformation() {
        XTN[] ret = null;
        try {
            Type[] t = this.getField(13);  
            ret = new XTN[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (XTN)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PRD-13: "Provider Organization Communication Information" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XTN getProviderOrganizationCommunicationInformation(int rep) { 
        XTN ret = null;
        try {
            Type t = this.getField(13, rep);
            ret = (XTN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PRD-13: "Provider Organization Communication Information" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XTN getPrd13_ProviderOrganizationCommunicationInformation(int rep) { 
        XTN ret = null;
        try {
            Type t = this.getField(13, rep);
            ret = (XTN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * PRD-13: "Provider Organization Communication Information" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN insertProviderOrganizationCommunicationInformation(int rep) throws HL7Exception { 
        return (XTN) super.insertRepetition(13, rep);
    }



    /**
     * Inserts a repetition of
     * PRD-13: "Provider Organization Communication Information" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN insertPrd13_ProviderOrganizationCommunicationInformation(int rep) throws HL7Exception { 
        return (XTN) super.insertRepetition(13, rep);
    }


    /**
     * Removes a repetition of
     * PRD-13: "Provider Organization Communication Information" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN removeProviderOrganizationCommunicationInformation(int rep) throws HL7Exception { 
        return (XTN) super.removeRepetition(13, rep);
    }


    /**
     * Removes a repetition of
     * PRD-13: "Provider Organization Communication Information" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN removePrd13_ProviderOrganizationCommunicationInformation(int rep) throws HL7Exception { 
        return (XTN) super.removeRepetition(13, rep);
    }




    /**
     * Returns
     * PRD-14: "Provider Organization Method of Contact" - creates it if necessary
     */
    public CWE getProviderOrganizationMethodOfContact() { 
        CWE ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PRD-14: "Provider Organization Method of Contact" - creates it if necessary
     */
    public CWE getPrd14_ProviderOrganizationMethodOfContact() { 
        CWE ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new CWE(getMessage());
          case 1: return new XPN(getMessage());
          case 2: return new XAD(getMessage());
          case 3: return new PL(getMessage());
          case 4: return new XTN(getMessage());
          case 5: return new CWE(getMessage());
          case 6: return new PLN(getMessage());
          case 7: return new DTM(getMessage());
          case 8: return new DTM(getMessage());
          case 9: return new XON(getMessage());
          case 10: return new XAD(getMessage());
          case 11: return new PL(getMessage());
          case 12: return new XTN(getMessage());
          case 13: return new CWE(getMessage());
          default: return null;
       }
   }


}

