/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v26.segment;

// import ca.uhn.hl7v2.model.v26.group.*;
import ca.uhn.hl7v2.model.v26.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 PSG message segment (Product/Service Group). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>PSG-1: Provider Product/Service Group Number (EI) <b> </b>
     * <li>PSG-2: Payer Product/Service Group Number (EI) <b>optional </b>
     * <li>PSG-3: Product/Service Group Sequence Number (SI) <b> </b>
     * <li>PSG-4: Adjudicate as Group (ID) <b> </b>
     * <li>PSG-5: Product/Service Group Billed Amount (CP) <b> </b>
     * <li>PSG-6: Product/Service Group Description (ST) <b> </b>
 * </ul>
 */
public class PSG extends AbstractSegment {

    /** 
     * Creates a new PSG segment
     */
    public PSG(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(EI.class, true, 1, 73, new Object[]{ getMessage(), new Integer(0) }, "Provider Product/Service Group Number");
                                  this.add(EI.class, false, 1, 73, new Object[]{ getMessage(), new Integer(0) }, "Payer Product/Service Group Number");
                                  this.add(SI.class, true, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "Product/Service Group Sequence Number");
                                  this.add(ID.class, true, 1, 1, new Object[]{ getMessage() }, "Adjudicate as Group");
                                  this.add(CP.class, true, 1, 254, new Object[]{ getMessage(), new Integer(0) }, "Product/Service Group Billed Amount");
                                  this.add(ST.class, true, 1, 254, new Object[]{ getMessage(), new Integer(0) }, "Product/Service Group Description");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating PSG - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * PSG-1: "Provider Product/Service Group Number" - creates it if necessary
     */
    public EI getProviderProductServiceGroupNumber() { 
        EI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSG-1: "Provider Product/Service Group Number" - creates it if necessary
     */
    public EI getPsg1_ProviderProductServiceGroupNumber() { 
        EI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSG-2: "Payer Product/Service Group Number" - creates it if necessary
     */
    public EI getPayerProductServiceGroupNumber() { 
        EI ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSG-2: "Payer Product/Service Group Number" - creates it if necessary
     */
    public EI getPsg2_PayerProductServiceGroupNumber() { 
        EI ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSG-3: "Product/Service Group Sequence Number" - creates it if necessary
     */
    public SI getProductServiceGroupSequenceNumber() { 
        SI ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSG-3: "Product/Service Group Sequence Number" - creates it if necessary
     */
    public SI getPsg3_ProductServiceGroupSequenceNumber() { 
        SI ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSG-4: "Adjudicate as Group" - creates it if necessary
     */
    public ID getAdjudicateAsGroup() { 
        ID ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSG-4: "Adjudicate as Group" - creates it if necessary
     */
    public ID getPsg4_AdjudicateAsGroup() { 
        ID ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSG-5: "Product/Service Group Billed Amount" - creates it if necessary
     */
    public CP getProductServiceGroupBilledAmount() { 
        CP ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSG-5: "Product/Service Group Billed Amount" - creates it if necessary
     */
    public CP getPsg5_ProductServiceGroupBilledAmount() { 
        CP ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSG-6: "Product/Service Group Description" - creates it if necessary
     */
    public ST getProductServiceGroupDescription() { 
        ST ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSG-6: "Product/Service Group Description" - creates it if necessary
     */
    public ST getPsg6_ProductServiceGroupDescription() { 
        ST ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new EI(getMessage());
          case 1: return new EI(getMessage());
          case 2: return new SI(getMessage());
          case 3: return new ID(getMessage(), new Integer( 136 ));
          case 4: return new CP(getMessage());
          case 5: return new ST(getMessage());
          default: return null;
       }
   }


}

