/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v26.segment;

// import ca.uhn.hl7v2.model.v26.group.*;
import ca.uhn.hl7v2.model.v26.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 QRD message segment (Original-Style Query Definition). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>QRD-1: Query Date/Time (DTM) <b> </b>
     * <li>QRD-2: Query Format Code (ID) <b> </b>
     * <li>QRD-3: Query Priority (ID) <b> </b>
     * <li>QRD-4: Query ID (ST) <b> </b>
     * <li>QRD-5: Deferred Response Type (ID) <b>optional </b>
     * <li>QRD-6: Deferred Response Date/Time (DTM) <b>optional </b>
     * <li>QRD-7: Quantity Limited Request (CQ) <b> </b>
     * <li>QRD-8: Who Subject Filter (XCN) <b> repeating</b>
     * <li>QRD-9: What Subject Filter (CWE) <b> repeating</b>
     * <li>QRD-10: What Department Data Code (CWE) <b> repeating</b>
     * <li>QRD-11: What Data Code Value Qual. (VR) <b>optional repeating</b>
     * <li>QRD-12: Query Results Level (ID) <b>optional </b>
 * </ul>
 */
public class QRD extends AbstractSegment {

    /** 
     * Creates a new QRD segment
     */
    public QRD(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(DTM.class, true, 1, 24, new Object[]{ getMessage(), new Integer(0) }, "Query Date/Time");
                                  this.add(ID.class, true, 1, 1, new Object[]{ getMessage() }, "Query Format Code");
                                  this.add(ID.class, true, 1, 1, new Object[]{ getMessage() }, "Query Priority");
                                  this.add(ST.class, true, 1, 10, new Object[]{ getMessage(), new Integer(0) }, "Query ID");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "Deferred Response Type");
                                  this.add(DTM.class, false, 1, 24, new Object[]{ getMessage(), new Integer(0) }, "Deferred Response Date/Time");
                                  this.add(CQ.class, true, 1, 10, new Object[]{ getMessage(), new Integer(126) }, "Quantity Limited Request");
                                  this.add(XCN.class, true, 0, 250, new Object[]{ getMessage(), new Integer(0) }, "Who Subject Filter");
                                  this.add(CWE.class, true, 0, 250, new Object[]{ getMessage(), new Integer(48) }, "What Subject Filter");
                                  this.add(CWE.class, true, 0, 250, new Object[]{ getMessage(), new Integer(0) }, "What Department Data Code");
                                  this.add(VR.class, false, 0, 20, new Object[]{ getMessage(), new Integer(0) }, "What Data Code Value Qual.");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "Query Results Level");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating QRD - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * QRD-1: "Query Date/Time" - creates it if necessary
     */
    public DTM getQueryDateTime() { 
        DTM ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * QRD-1: "Query Date/Time" - creates it if necessary
     */
    public DTM getQrd1_QueryDateTime() { 
        DTM ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * QRD-2: "Query Format Code" - creates it if necessary
     */
    public ID getQueryFormatCode() { 
        ID ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * QRD-2: "Query Format Code" - creates it if necessary
     */
    public ID getQrd2_QueryFormatCode() { 
        ID ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * QRD-3: "Query Priority" - creates it if necessary
     */
    public ID getQueryPriority() { 
        ID ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * QRD-3: "Query Priority" - creates it if necessary
     */
    public ID getQrd3_QueryPriority() { 
        ID ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * QRD-4: "Query ID" - creates it if necessary
     */
    public ST getQueryID() { 
        ST ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * QRD-4: "Query ID" - creates it if necessary
     */
    public ST getQrd4_QueryID() { 
        ST ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * QRD-5: "Deferred Response Type" - creates it if necessary
     */
    public ID getDeferredResponseType() { 
        ID ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * QRD-5: "Deferred Response Type" - creates it if necessary
     */
    public ID getQrd5_DeferredResponseType() { 
        ID ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * QRD-6: "Deferred Response Date/Time" - creates it if necessary
     */
    public DTM getDeferredResponseDateTime() { 
        DTM ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * QRD-6: "Deferred Response Date/Time" - creates it if necessary
     */
    public DTM getQrd6_DeferredResponseDateTime() { 
        DTM ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * QRD-7: "Quantity Limited Request" - creates it if necessary
     */
    public CQ getQuantityLimitedRequest() { 
        CQ ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (CQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * QRD-7: "Quantity Limited Request" - creates it if necessary
     */
    public CQ getQrd7_QuantityLimitedRequest() { 
        CQ ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (CQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Who Subject Filter (QRD-8).
     */
    public XCN[] getWhoSubjectFilter() {
        XCN[] ret = null;
        try {
            Type[] t = this.getField(8);  
            ret = new XCN[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (XCN)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * QRD-8: "Who Subject Filter" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XCN getWhoSubjectFilter(int rep) { 
        XCN ret = null;
        try {
            Type t = this.getField(8, rep);
            ret = (XCN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * QRD-8: "Who Subject Filter" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XCN getQrd8_WhoSubjectFilter(int rep) { 
        XCN ret = null;
        try {
            Type t = this.getField(8, rep);
            ret = (XCN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * QRD-8: "Who Subject Filter" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XCN insertWhoSubjectFilter(int rep) throws HL7Exception { 
        return (XCN) super.insertRepetition(8, rep);
    }



    /**
     * Inserts a repetition of
     * QRD-8: "Who Subject Filter" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XCN insertQrd8_WhoSubjectFilter(int rep) throws HL7Exception { 
        return (XCN) super.insertRepetition(8, rep);
    }


    /**
     * Removes a repetition of
     * QRD-8: "Who Subject Filter" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XCN removeWhoSubjectFilter(int rep) throws HL7Exception { 
        return (XCN) super.removeRepetition(8, rep);
    }


    /**
     * Removes a repetition of
     * QRD-8: "Who Subject Filter" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XCN removeQrd8_WhoSubjectFilter(int rep) throws HL7Exception { 
        return (XCN) super.removeRepetition(8, rep);
    }



    /**
     * Returns all repetitions of What Subject Filter (QRD-9).
     */
    public CWE[] getWhatSubjectFilter() {
        CWE[] ret = null;
        try {
            Type[] t = this.getField(9);  
            ret = new CWE[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CWE)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * QRD-9: "What Subject Filter" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CWE getWhatSubjectFilter(int rep) { 
        CWE ret = null;
        try {
            Type t = this.getField(9, rep);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * QRD-9: "What Subject Filter" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CWE getQrd9_WhatSubjectFilter(int rep) { 
        CWE ret = null;
        try {
            Type t = this.getField(9, rep);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * QRD-9: "What Subject Filter" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE insertWhatSubjectFilter(int rep) throws HL7Exception { 
        return (CWE) super.insertRepetition(9, rep);
    }



    /**
     * Inserts a repetition of
     * QRD-9: "What Subject Filter" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE insertQrd9_WhatSubjectFilter(int rep) throws HL7Exception { 
        return (CWE) super.insertRepetition(9, rep);
    }


    /**
     * Removes a repetition of
     * QRD-9: "What Subject Filter" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE removeWhatSubjectFilter(int rep) throws HL7Exception { 
        return (CWE) super.removeRepetition(9, rep);
    }


    /**
     * Removes a repetition of
     * QRD-9: "What Subject Filter" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE removeQrd9_WhatSubjectFilter(int rep) throws HL7Exception { 
        return (CWE) super.removeRepetition(9, rep);
    }



    /**
     * Returns all repetitions of What Department Data Code (QRD-10).
     */
    public CWE[] getWhatDepartmentDataCode() {
        CWE[] ret = null;
        try {
            Type[] t = this.getField(10);  
            ret = new CWE[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CWE)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * QRD-10: "What Department Data Code" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CWE getWhatDepartmentDataCode(int rep) { 
        CWE ret = null;
        try {
            Type t = this.getField(10, rep);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * QRD-10: "What Department Data Code" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CWE getQrd10_WhatDepartmentDataCode(int rep) { 
        CWE ret = null;
        try {
            Type t = this.getField(10, rep);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * QRD-10: "What Department Data Code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE insertWhatDepartmentDataCode(int rep) throws HL7Exception { 
        return (CWE) super.insertRepetition(10, rep);
    }



    /**
     * Inserts a repetition of
     * QRD-10: "What Department Data Code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE insertQrd10_WhatDepartmentDataCode(int rep) throws HL7Exception { 
        return (CWE) super.insertRepetition(10, rep);
    }


    /**
     * Removes a repetition of
     * QRD-10: "What Department Data Code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE removeWhatDepartmentDataCode(int rep) throws HL7Exception { 
        return (CWE) super.removeRepetition(10, rep);
    }


    /**
     * Removes a repetition of
     * QRD-10: "What Department Data Code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE removeQrd10_WhatDepartmentDataCode(int rep) throws HL7Exception { 
        return (CWE) super.removeRepetition(10, rep);
    }



    /**
     * Returns all repetitions of What Data Code Value Qual. (QRD-11).
     */
    public VR[] getWhatDataCodeValueQual() {
        VR[] ret = null;
        try {
            Type[] t = this.getField(11);  
            ret = new VR[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (VR)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * QRD-11: "What Data Code Value Qual." - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public VR getWhatDataCodeValueQual(int rep) { 
        VR ret = null;
        try {
            Type t = this.getField(11, rep);
            ret = (VR)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * QRD-11: "What Data Code Value Qual." - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public VR getQrd11_WhatDataCodeValueQual(int rep) { 
        VR ret = null;
        try {
            Type t = this.getField(11, rep);
            ret = (VR)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * QRD-11: "What Data Code Value Qual." at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public VR insertWhatDataCodeValueQual(int rep) throws HL7Exception { 
        return (VR) super.insertRepetition(11, rep);
    }



    /**
     * Inserts a repetition of
     * QRD-11: "What Data Code Value Qual." at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public VR insertQrd11_WhatDataCodeValueQual(int rep) throws HL7Exception { 
        return (VR) super.insertRepetition(11, rep);
    }


    /**
     * Removes a repetition of
     * QRD-11: "What Data Code Value Qual." at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public VR removeWhatDataCodeValueQual(int rep) throws HL7Exception { 
        return (VR) super.removeRepetition(11, rep);
    }


    /**
     * Removes a repetition of
     * QRD-11: "What Data Code Value Qual." at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public VR removeQrd11_WhatDataCodeValueQual(int rep) throws HL7Exception { 
        return (VR) super.removeRepetition(11, rep);
    }




    /**
     * Returns
     * QRD-12: "Query Results Level" - creates it if necessary
     */
    public ID getQueryResultsLevel() { 
        ID ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * QRD-12: "Query Results Level" - creates it if necessary
     */
    public ID getQrd12_QueryResultsLevel() { 
        ID ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new DTM(getMessage());
          case 1: return new ID(getMessage(), new Integer( 106 ));
          case 2: return new ID(getMessage(), new Integer( 91 ));
          case 3: return new ST(getMessage());
          case 4: return new ID(getMessage(), new Integer( 107 ));
          case 5: return new DTM(getMessage());
          case 6: return new CQ(getMessage());
          case 7: return new XCN(getMessage());
          case 8: return new CWE(getMessage());
          case 9: return new CWE(getMessage());
          case 10: return new VR(getMessage());
          case 11: return new ID(getMessage(), new Integer( 108 ));
          default: return null;
       }
   }


}

