/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v26.segment;

// import ca.uhn.hl7v2.model.v26.group.*;
import ca.uhn.hl7v2.model.v26.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 RCP message segment (Response Control Parameter). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>RCP-1: Query Priority (ID) <b>optional </b>
     * <li>RCP-2: Quantity Limited Request (CQ) <b>optional </b>
     * <li>RCP-3: Response Modality (CNE) <b>optional </b>
     * <li>RCP-4: Execution and Delivery Time (DTM) <b>optional </b>
     * <li>RCP-5: Modify Indicator (ID) <b>optional </b>
     * <li>RCP-6: Sort-by Field (SRT) <b>optional repeating</b>
     * <li>RCP-7: Segment group inclusion (ID) <b>optional repeating</b>
 * </ul>
 */
public class RCP extends AbstractSegment {

    /** 
     * Creates a new RCP segment
     */
    public RCP(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "Query Priority");
                                  this.add(CQ.class, false, 1, 10, new Object[]{ getMessage(), new Integer(126) }, "Quantity Limited Request");
                                  this.add(CNE.class, false, 1, 250, new Object[]{ getMessage(), new Integer(394) }, "Response Modality");
                                  this.add(DTM.class, false, 1, 24, new Object[]{ getMessage(), new Integer(0) }, "Execution and Delivery Time");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "Modify Indicator");
                                  this.add(SRT.class, false, 0, 512, new Object[]{ getMessage(), new Integer(0) }, "Sort-by Field");
                                  this.add(ID.class, false, 0, 256, new Object[]{ getMessage() }, "Segment group inclusion");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating RCP - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * RCP-1: "Query Priority" - creates it if necessary
     */
    public ID getQueryPriority() { 
        ID ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RCP-1: "Query Priority" - creates it if necessary
     */
    public ID getRcp1_QueryPriority() { 
        ID ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RCP-2: "Quantity Limited Request" - creates it if necessary
     */
    public CQ getQuantityLimitedRequest() { 
        CQ ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (CQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RCP-2: "Quantity Limited Request" - creates it if necessary
     */
    public CQ getRcp2_QuantityLimitedRequest() { 
        CQ ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (CQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RCP-3: "Response Modality" - creates it if necessary
     */
    public CNE getResponseModality() { 
        CNE ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RCP-3: "Response Modality" - creates it if necessary
     */
    public CNE getRcp3_ResponseModality() { 
        CNE ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RCP-4: "Execution and Delivery Time" - creates it if necessary
     */
    public DTM getExecutionAndDeliveryTime() { 
        DTM ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RCP-4: "Execution and Delivery Time" - creates it if necessary
     */
    public DTM getRcp4_ExecutionAndDeliveryTime() { 
        DTM ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RCP-5: "Modify Indicator" - creates it if necessary
     */
    public ID getModifyIndicator() { 
        ID ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RCP-5: "Modify Indicator" - creates it if necessary
     */
    public ID getRcp5_ModifyIndicator() { 
        ID ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Sort-by Field (RCP-6).
     */
    public SRT[] getSortByField() {
        SRT[] ret = null;
        try {
            Type[] t = this.getField(6);  
            ret = new SRT[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (SRT)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * RCP-6: "Sort-by Field" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public SRT getSortByField(int rep) { 
        SRT ret = null;
        try {
            Type t = this.getField(6, rep);
            ret = (SRT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * RCP-6: "Sort-by Field" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public SRT getRcp6_SortByField(int rep) { 
        SRT ret = null;
        try {
            Type t = this.getField(6, rep);
            ret = (SRT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * RCP-6: "Sort-by Field" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public SRT insertSortByField(int rep) throws HL7Exception { 
        return (SRT) super.insertRepetition(6, rep);
    }



    /**
     * Inserts a repetition of
     * RCP-6: "Sort-by Field" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public SRT insertRcp6_SortByField(int rep) throws HL7Exception { 
        return (SRT) super.insertRepetition(6, rep);
    }


    /**
     * Removes a repetition of
     * RCP-6: "Sort-by Field" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public SRT removeSortByField(int rep) throws HL7Exception { 
        return (SRT) super.removeRepetition(6, rep);
    }


    /**
     * Removes a repetition of
     * RCP-6: "Sort-by Field" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public SRT removeRcp6_SortByField(int rep) throws HL7Exception { 
        return (SRT) super.removeRepetition(6, rep);
    }



    /**
     * Returns all repetitions of Segment group inclusion (RCP-7).
     */
    public ID[] getSegmentGroupInclusion() {
        ID[] ret = null;
        try {
            Type[] t = this.getField(7);  
            ret = new ID[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (ID)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * RCP-7: "Segment group inclusion" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ID getSegmentGroupInclusion(int rep) { 
        ID ret = null;
        try {
            Type t = this.getField(7, rep);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * RCP-7: "Segment group inclusion" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ID getRcp7_SegmentGroupInclusion(int rep) { 
        ID ret = null;
        try {
            Type t = this.getField(7, rep);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * RCP-7: "Segment group inclusion" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ID insertSegmentGroupInclusion(int rep) throws HL7Exception { 
        return (ID) super.insertRepetition(7, rep);
    }



    /**
     * Inserts a repetition of
     * RCP-7: "Segment group inclusion" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ID insertRcp7_SegmentGroupInclusion(int rep) throws HL7Exception { 
        return (ID) super.insertRepetition(7, rep);
    }


    /**
     * Removes a repetition of
     * RCP-7: "Segment group inclusion" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ID removeSegmentGroupInclusion(int rep) throws HL7Exception { 
        return (ID) super.removeRepetition(7, rep);
    }


    /**
     * Removes a repetition of
     * RCP-7: "Segment group inclusion" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ID removeRcp7_SegmentGroupInclusion(int rep) throws HL7Exception { 
        return (ID) super.removeRepetition(7, rep);
    }






    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new ID(getMessage(), new Integer( 91 ));
          case 1: return new CQ(getMessage());
          case 2: return new CNE(getMessage());
          case 3: return new DTM(getMessage());
          case 4: return new ID(getMessage(), new Integer( 395 ));
          case 5: return new SRT(getMessage());
          case 6: return new ID(getMessage(), new Integer( 391 ));
          default: return null;
       }
   }


}

