/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v26.segment;

// import ca.uhn.hl7v2.model.v26.group.*;
import ca.uhn.hl7v2.model.v26.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 RQD message segment (Requisition Detail). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>RQD-1: Requisition Line Number (SI) <b>optional </b>
     * <li>RQD-2: Item Code - Internal (CWE) <b>optional </b>
     * <li>RQD-3: Item Code - External (CWE) <b>optional </b>
     * <li>RQD-4: Hospital Item Code (CWE) <b>optional </b>
     * <li>RQD-5: Requisition Quantity (NM) <b>optional </b>
     * <li>RQD-6: Requisition Unit of Measure (CWE) <b>optional </b>
     * <li>RQD-7: Cost Center Account Number (IS) <b>optional </b>
     * <li>RQD-8: Item Natural Account Code (IS) <b>optional </b>
     * <li>RQD-9: Deliver To ID (CWE) <b>optional </b>
     * <li>RQD-10: Date Needed (DT) <b>optional </b>
 * </ul>
 */
public class RQD extends AbstractSegment {

    /** 
     * Creates a new RQD segment
     */
    public RQD(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(SI.class, false, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "Requisition Line Number");
                                  this.add(CWE.class, false, 1, 250, new Object[]{ getMessage(), new Integer(9999) }, "Item Code - Internal");
                                  this.add(CWE.class, false, 1, 250, new Object[]{ getMessage(), new Integer(9999) }, "Item Code - External");
                                  this.add(CWE.class, false, 1, 250, new Object[]{ getMessage(), new Integer(9999) }, "Hospital Item Code");
                                  this.add(NM.class, false, 1, 6, new Object[]{ getMessage(), new Integer(0) }, "Requisition Quantity");
                                  this.add(CWE.class, false, 1, 250, new Object[]{ getMessage(), new Integer(9999) }, "Requisition Unit of Measure");
                                  this.add(IS.class, false, 1, 30, new Object[]{ getMessage() }, "Cost Center Account Number");
                                  this.add(IS.class, false, 1, 30, new Object[]{ getMessage() }, "Item Natural Account Code");
                                  this.add(CWE.class, false, 1, 250, new Object[]{ getMessage(), new Integer(9999) }, "Deliver To ID");
                                  this.add(DT.class, false, 1, 8, new Object[]{ getMessage(), new Integer(0) }, "Date Needed");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating RQD - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * RQD-1: "Requisition Line Number" - creates it if necessary
     */
    public SI getRequisitionLineNumber() { 
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RQD-1: "Requisition Line Number" - creates it if necessary
     */
    public SI getRqd1_RequisitionLineNumber() { 
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RQD-2: "Item Code - Internal" - creates it if necessary
     */
    public CWE getItemCodeInternal() { 
        CWE ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RQD-2: "Item Code - Internal" - creates it if necessary
     */
    public CWE getRqd2_ItemCodeInternal() { 
        CWE ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RQD-3: "Item Code - External" - creates it if necessary
     */
    public CWE getItemCodeExternal() { 
        CWE ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RQD-3: "Item Code - External" - creates it if necessary
     */
    public CWE getRqd3_ItemCodeExternal() { 
        CWE ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RQD-4: "Hospital Item Code" - creates it if necessary
     */
    public CWE getHospitalItemCode() { 
        CWE ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RQD-4: "Hospital Item Code" - creates it if necessary
     */
    public CWE getRqd4_HospitalItemCode() { 
        CWE ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RQD-5: "Requisition Quantity" - creates it if necessary
     */
    public NM getRequisitionQuantity() { 
        NM ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RQD-5: "Requisition Quantity" - creates it if necessary
     */
    public NM getRqd5_RequisitionQuantity() { 
        NM ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RQD-6: "Requisition Unit of Measure" - creates it if necessary
     */
    public CWE getRequisitionUnitOfMeasure() { 
        CWE ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RQD-6: "Requisition Unit of Measure" - creates it if necessary
     */
    public CWE getRqd6_RequisitionUnitOfMeasure() { 
        CWE ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RQD-7: "Cost Center Account Number" - creates it if necessary
     */
    public IS getCostCenterAccountNumber() { 
        IS ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RQD-7: "Cost Center Account Number" - creates it if necessary
     */
    public IS getRqd7_CostCenterAccountNumber() { 
        IS ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RQD-8: "Item Natural Account Code" - creates it if necessary
     */
    public IS getItemNaturalAccountCode() { 
        IS ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RQD-8: "Item Natural Account Code" - creates it if necessary
     */
    public IS getRqd8_ItemNaturalAccountCode() { 
        IS ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RQD-9: "Deliver To ID" - creates it if necessary
     */
    public CWE getDeliverToID() { 
        CWE ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RQD-9: "Deliver To ID" - creates it if necessary
     */
    public CWE getRqd9_DeliverToID() { 
        CWE ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RQD-10: "Date Needed" - creates it if necessary
     */
    public DT getDateNeeded() { 
        DT ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RQD-10: "Date Needed" - creates it if necessary
     */
    public DT getRqd10_DateNeeded() { 
        DT ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new SI(getMessage());
          case 1: return new CWE(getMessage());
          case 2: return new CWE(getMessage());
          case 3: return new CWE(getMessage());
          case 4: return new NM(getMessage());
          case 5: return new CWE(getMessage());
          case 6: return new IS(getMessage(), new Integer( 319 ));
          case 7: return new IS(getMessage(), new Integer( 320 ));
          case 8: return new CWE(getMessage());
          case 9: return new DT(getMessage());
          default: return null;
       }
   }


}

