/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v26.segment;

// import ca.uhn.hl7v2.model.v26.group.*;
import ca.uhn.hl7v2.model.v26.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 SAC message segment (Specimen Container detail). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>SAC-1: External Accession Identifier (EI) <b>optional </b>
     * <li>SAC-2: Accession Identifier (EI) <b>optional </b>
     * <li>SAC-3: Container Identifier (EI) <b>optional </b>
     * <li>SAC-4: Primary (Parent) Container Identifier (EI) <b>optional </b>
     * <li>SAC-5: Equipment Container Identifier (EI) <b>optional </b>
     * <li>SAC-6: Specimen Source (SPS) <b>optional </b>
     * <li>SAC-7: Registration Date/Time (DTM) <b>optional </b>
     * <li>SAC-8: Container Status (CWE) <b>optional </b>
     * <li>SAC-9: Carrier Type (CWE) <b>optional </b>
     * <li>SAC-10: Carrier Identifier (EI) <b>optional </b>
     * <li>SAC-11: Position in Carrier (NA) <b>optional </b>
     * <li>SAC-12: Tray Type - SAC (CWE) <b>optional </b>
     * <li>SAC-13: Tray Identifier (EI) <b>optional </b>
     * <li>SAC-14: Position in Tray (NA) <b>optional </b>
     * <li>SAC-15: Location (CWE) <b>optional repeating</b>
     * <li>SAC-16: Container Height (NM) <b>optional </b>
     * <li>SAC-17: Container Diameter (NM) <b>optional </b>
     * <li>SAC-18: Barrier Delta (NM) <b>optional </b>
     * <li>SAC-19: Bottom Delta (NM) <b>optional </b>
     * <li>SAC-20: Container Height/Diameter/Delta Units (CWE) <b>optional </b>
     * <li>SAC-21: Container Volume (NM) <b>optional </b>
     * <li>SAC-22: Available Specimen Volume (NM) <b>optional </b>
     * <li>SAC-23: Initial Specimen Volume (NM) <b>optional </b>
     * <li>SAC-24: Volume Units (CWE) <b>optional </b>
     * <li>SAC-25: Separator Type (CWE) <b>optional </b>
     * <li>SAC-26: Cap Type (CWE) <b>optional </b>
     * <li>SAC-27: Additive (CWE) <b>optional repeating</b>
     * <li>SAC-28: Specimen Component (CWE) <b>optional </b>
     * <li>SAC-29: Dilution Factor (SN) <b>optional </b>
     * <li>SAC-30: Treatment (CWE) <b>optional </b>
     * <li>SAC-31: Temperature (SN) <b>optional </b>
     * <li>SAC-32: Hemolysis Index (NM) <b>optional </b>
     * <li>SAC-33: Hemolysis Index Units (CWE) <b>optional </b>
     * <li>SAC-34: Lipemia Index (NM) <b>optional </b>
     * <li>SAC-35: Lipemia Index Units (CWE) <b>optional </b>
     * <li>SAC-36: Icterus Index (NM) <b>optional </b>
     * <li>SAC-37: Icterus Index Units (CWE) <b>optional </b>
     * <li>SAC-38: Fibrin Index (NM) <b>optional </b>
     * <li>SAC-39: Fibrin Index Units (CWE) <b>optional </b>
     * <li>SAC-40: System Induced Contaminants (CWE) <b>optional repeating</b>
     * <li>SAC-41: Drug Interference (CWE) <b>optional repeating</b>
     * <li>SAC-42: Artificial Blood (CWE) <b>optional </b>
     * <li>SAC-43: Special Handling Code (CWE) <b>optional repeating</b>
     * <li>SAC-44: Other Environmental Factors (CWE) <b>optional repeating</b>
 * </ul>
 */
public class SAC extends AbstractSegment {

    /** 
     * Creates a new SAC segment
     */
    public SAC(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(EI.class, false, 1, 427, new Object[]{ getMessage(), new Integer(0) }, "External Accession Identifier");
                                  this.add(EI.class, false, 1, 427, new Object[]{ getMessage(), new Integer(0) }, "Accession Identifier");
                                  this.add(EI.class, false, 1, 427, new Object[]{ getMessage(), new Integer(0) }, "Container Identifier");
                                  this.add(EI.class, false, 1, 427, new Object[]{ getMessage(), new Integer(0) }, "Primary (Parent) Container Identifier");
                                  this.add(EI.class, false, 1, 427, new Object[]{ getMessage(), new Integer(0) }, "Equipment Container Identifier");
                                  this.add(SPS.class, false, 1, 0, new Object[]{ getMessage(), new Integer(0) }, "Specimen Source");
                                  this.add(DTM.class, false, 1, 24, new Object[]{ getMessage(), new Integer(0) }, "Registration Date/Time");
                                  this.add(CWE.class, false, 1, 705, new Object[]{ getMessage(), new Integer(370) }, "Container Status");
                                  this.add(CWE.class, false, 1, 705, new Object[]{ getMessage(), new Integer(378) }, "Carrier Type");
                                  this.add(EI.class, false, 1, 705, new Object[]{ getMessage(), new Integer(0) }, "Carrier Identifier");
                                  this.add(NA.class, false, 1, 80, new Object[]{ getMessage(), new Integer(0) }, "Position in Carrier");
                                  this.add(CWE.class, false, 1, 705, new Object[]{ getMessage(), new Integer(379) }, "Tray Type - SAC");
                                  this.add(EI.class, false, 1, 427, new Object[]{ getMessage(), new Integer(0) }, "Tray Identifier");
                                  this.add(NA.class, false, 1, 80, new Object[]{ getMessage(), new Integer(0) }, "Position in Tray");
                                  this.add(CWE.class, false, 0, 705, new Object[]{ getMessage(), new Integer(9999) }, "Location");
                                  this.add(NM.class, false, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "Container Height");
                                  this.add(NM.class, false, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "Container Diameter");
                                  this.add(NM.class, false, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "Barrier Delta");
                                  this.add(NM.class, false, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "Bottom Delta");
                                  this.add(CWE.class, false, 1, 705, new Object[]{ getMessage(), new Integer(9999) }, "Container Height/Diameter/Delta Units");
                                  this.add(NM.class, false, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "Container Volume");
                                  this.add(NM.class, false, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "Available Specimen Volume");
                                  this.add(NM.class, false, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "Initial Specimen Volume");
                                  this.add(CWE.class, false, 1, 705, new Object[]{ getMessage(), new Integer(9999) }, "Volume Units");
                                  this.add(CWE.class, false, 1, 705, new Object[]{ getMessage(), new Integer(380) }, "Separator Type");
                                  this.add(CWE.class, false, 1, 705, new Object[]{ getMessage(), new Integer(381) }, "Cap Type");
                                  this.add(CWE.class, false, 0, 705, new Object[]{ getMessage(), new Integer(371) }, "Additive");
                                  this.add(CWE.class, false, 1, 705, new Object[]{ getMessage(), new Integer(372) }, "Specimen Component");
                                  this.add(SN.class, false, 1, 36, new Object[]{ getMessage(), new Integer(0) }, "Dilution Factor");
                                  this.add(CWE.class, false, 1, 705, new Object[]{ getMessage(), new Integer(373) }, "Treatment");
                                  this.add(SN.class, false, 1, 36, new Object[]{ getMessage(), new Integer(0) }, "Temperature");
                                  this.add(NM.class, false, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "Hemolysis Index");
                                  this.add(CWE.class, false, 1, 705, new Object[]{ getMessage(), new Integer(9999) }, "Hemolysis Index Units");
                                  this.add(NM.class, false, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "Lipemia Index");
                                  this.add(CWE.class, false, 1, 705, new Object[]{ getMessage(), new Integer(9999) }, "Lipemia Index Units");
                                  this.add(NM.class, false, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "Icterus Index");
                                  this.add(CWE.class, false, 1, 705, new Object[]{ getMessage(), new Integer(9999) }, "Icterus Index Units");
                                  this.add(NM.class, false, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "Fibrin Index");
                                  this.add(CWE.class, false, 1, 705, new Object[]{ getMessage(), new Integer(9999) }, "Fibrin Index Units");
                                  this.add(CWE.class, false, 0, 705, new Object[]{ getMessage(), new Integer(374) }, "System Induced Contaminants");
                                  this.add(CWE.class, false, 0, 705, new Object[]{ getMessage(), new Integer(382) }, "Drug Interference");
                                  this.add(CWE.class, false, 1, 705, new Object[]{ getMessage(), new Integer(375) }, "Artificial Blood");
                                  this.add(CWE.class, false, 0, 705, new Object[]{ getMessage(), new Integer(376) }, "Special Handling Code");
                                  this.add(CWE.class, false, 0, 705, new Object[]{ getMessage(), new Integer(377) }, "Other Environmental Factors");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating SAC - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * SAC-1: "External Accession Identifier" - creates it if necessary
     */
    public EI getExternalAccessionIdentifier() { 
        EI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SAC-1: "External Accession Identifier" - creates it if necessary
     */
    public EI getSac1_ExternalAccessionIdentifier() { 
        EI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SAC-2: "Accession Identifier" - creates it if necessary
     */
    public EI getAccessionIdentifier() { 
        EI ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SAC-2: "Accession Identifier" - creates it if necessary
     */
    public EI getSac2_AccessionIdentifier() { 
        EI ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SAC-3: "Container Identifier" - creates it if necessary
     */
    public EI getContainerIdentifier() { 
        EI ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SAC-3: "Container Identifier" - creates it if necessary
     */
    public EI getSac3_ContainerIdentifier() { 
        EI ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SAC-4: "Primary (Parent) Container Identifier" - creates it if necessary
     */
    public EI getPrimaryParentContainerIdentifier() { 
        EI ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SAC-4: "Primary (Parent) Container Identifier" - creates it if necessary
     */
    public EI getSac4_PrimaryParentContainerIdentifier() { 
        EI ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SAC-5: "Equipment Container Identifier" - creates it if necessary
     */
    public EI getEquipmentContainerIdentifier() { 
        EI ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SAC-5: "Equipment Container Identifier" - creates it if necessary
     */
    public EI getSac5_EquipmentContainerIdentifier() { 
        EI ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SAC-6: "Specimen Source" - creates it if necessary
     */
    public SPS getSpecimenSource() { 
        SPS ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (SPS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SAC-6: "Specimen Source" - creates it if necessary
     */
    public SPS getSac6_SpecimenSource() { 
        SPS ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (SPS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SAC-7: "Registration Date/Time" - creates it if necessary
     */
    public DTM getRegistrationDateTime() { 
        DTM ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SAC-7: "Registration Date/Time" - creates it if necessary
     */
    public DTM getSac7_RegistrationDateTime() { 
        DTM ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SAC-8: "Container Status" - creates it if necessary
     */
    public CWE getContainerStatus() { 
        CWE ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SAC-8: "Container Status" - creates it if necessary
     */
    public CWE getSac8_ContainerStatus() { 
        CWE ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SAC-9: "Carrier Type" - creates it if necessary
     */
    public CWE getCarrierType() { 
        CWE ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SAC-9: "Carrier Type" - creates it if necessary
     */
    public CWE getSac9_CarrierType() { 
        CWE ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SAC-10: "Carrier Identifier" - creates it if necessary
     */
    public EI getCarrierIdentifier() { 
        EI ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SAC-10: "Carrier Identifier" - creates it if necessary
     */
    public EI getSac10_CarrierIdentifier() { 
        EI ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SAC-11: "Position in Carrier" - creates it if necessary
     */
    public NA getPositionInCarrier() { 
        NA ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (NA)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SAC-11: "Position in Carrier" - creates it if necessary
     */
    public NA getSac11_PositionInCarrier() { 
        NA ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (NA)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SAC-12: "Tray Type - SAC" - creates it if necessary
     */
    public CWE getTrayTypeSAC() { 
        CWE ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SAC-12: "Tray Type - SAC" - creates it if necessary
     */
    public CWE getSac12_TrayTypeSAC() { 
        CWE ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SAC-13: "Tray Identifier" - creates it if necessary
     */
    public EI getTrayIdentifier() { 
        EI ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SAC-13: "Tray Identifier" - creates it if necessary
     */
    public EI getSac13_TrayIdentifier() { 
        EI ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SAC-14: "Position in Tray" - creates it if necessary
     */
    public NA getPositionInTray() { 
        NA ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (NA)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SAC-14: "Position in Tray" - creates it if necessary
     */
    public NA getSac14_PositionInTray() { 
        NA ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (NA)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Location (SAC-15).
     */
    public CWE[] getLocation() {
        CWE[] ret = null;
        try {
            Type[] t = this.getField(15);  
            ret = new CWE[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CWE)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * SAC-15: "Location" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CWE getLocation(int rep) { 
        CWE ret = null;
        try {
            Type t = this.getField(15, rep);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * SAC-15: "Location" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CWE getSac15_Location(int rep) { 
        CWE ret = null;
        try {
            Type t = this.getField(15, rep);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * SAC-15: "Location" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE insertLocation(int rep) throws HL7Exception { 
        return (CWE) super.insertRepetition(15, rep);
    }



    /**
     * Inserts a repetition of
     * SAC-15: "Location" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE insertSac15_Location(int rep) throws HL7Exception { 
        return (CWE) super.insertRepetition(15, rep);
    }


    /**
     * Removes a repetition of
     * SAC-15: "Location" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE removeLocation(int rep) throws HL7Exception { 
        return (CWE) super.removeRepetition(15, rep);
    }


    /**
     * Removes a repetition of
     * SAC-15: "Location" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE removeSac15_Location(int rep) throws HL7Exception { 
        return (CWE) super.removeRepetition(15, rep);
    }




    /**
     * Returns
     * SAC-16: "Container Height" - creates it if necessary
     */
    public NM getContainerHeight() { 
        NM ret = null;
        try {
            Type t = this.getField(16, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SAC-16: "Container Height" - creates it if necessary
     */
    public NM getSac16_ContainerHeight() { 
        NM ret = null;
        try {
            Type t = this.getField(16, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SAC-17: "Container Diameter" - creates it if necessary
     */
    public NM getContainerDiameter() { 
        NM ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SAC-17: "Container Diameter" - creates it if necessary
     */
    public NM getSac17_ContainerDiameter() { 
        NM ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SAC-18: "Barrier Delta" - creates it if necessary
     */
    public NM getBarrierDelta() { 
        NM ret = null;
        try {
            Type t = this.getField(18, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SAC-18: "Barrier Delta" - creates it if necessary
     */
    public NM getSac18_BarrierDelta() { 
        NM ret = null;
        try {
            Type t = this.getField(18, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SAC-19: "Bottom Delta" - creates it if necessary
     */
    public NM getBottomDelta() { 
        NM ret = null;
        try {
            Type t = this.getField(19, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SAC-19: "Bottom Delta" - creates it if necessary
     */
    public NM getSac19_BottomDelta() { 
        NM ret = null;
        try {
            Type t = this.getField(19, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SAC-20: "Container Height/Diameter/Delta Units" - creates it if necessary
     */
    public CWE getContainerHeightDiameterDeltaUnits() { 
        CWE ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SAC-20: "Container Height/Diameter/Delta Units" - creates it if necessary
     */
    public CWE getSac20_ContainerHeightDiameterDeltaUnits() { 
        CWE ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SAC-21: "Container Volume" - creates it if necessary
     */
    public NM getContainerVolume() { 
        NM ret = null;
        try {
            Type t = this.getField(21, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SAC-21: "Container Volume" - creates it if necessary
     */
    public NM getSac21_ContainerVolume() { 
        NM ret = null;
        try {
            Type t = this.getField(21, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SAC-22: "Available Specimen Volume" - creates it if necessary
     */
    public NM getAvailableSpecimenVolume() { 
        NM ret = null;
        try {
            Type t = this.getField(22, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SAC-22: "Available Specimen Volume" - creates it if necessary
     */
    public NM getSac22_AvailableSpecimenVolume() { 
        NM ret = null;
        try {
            Type t = this.getField(22, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SAC-23: "Initial Specimen Volume" - creates it if necessary
     */
    public NM getInitialSpecimenVolume() { 
        NM ret = null;
        try {
            Type t = this.getField(23, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SAC-23: "Initial Specimen Volume" - creates it if necessary
     */
    public NM getSac23_InitialSpecimenVolume() { 
        NM ret = null;
        try {
            Type t = this.getField(23, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SAC-24: "Volume Units" - creates it if necessary
     */
    public CWE getVolumeUnits() { 
        CWE ret = null;
        try {
            Type t = this.getField(24, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SAC-24: "Volume Units" - creates it if necessary
     */
    public CWE getSac24_VolumeUnits() { 
        CWE ret = null;
        try {
            Type t = this.getField(24, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SAC-25: "Separator Type" - creates it if necessary
     */
    public CWE getSeparatorType() { 
        CWE ret = null;
        try {
            Type t = this.getField(25, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SAC-25: "Separator Type" - creates it if necessary
     */
    public CWE getSac25_SeparatorType() { 
        CWE ret = null;
        try {
            Type t = this.getField(25, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SAC-26: "Cap Type" - creates it if necessary
     */
    public CWE getCapType() { 
        CWE ret = null;
        try {
            Type t = this.getField(26, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SAC-26: "Cap Type" - creates it if necessary
     */
    public CWE getSac26_CapType() { 
        CWE ret = null;
        try {
            Type t = this.getField(26, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Additive (SAC-27).
     */
    public CWE[] getAdditive() {
        CWE[] ret = null;
        try {
            Type[] t = this.getField(27);  
            ret = new CWE[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CWE)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * SAC-27: "Additive" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CWE getAdditive(int rep) { 
        CWE ret = null;
        try {
            Type t = this.getField(27, rep);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * SAC-27: "Additive" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CWE getSac27_Additive(int rep) { 
        CWE ret = null;
        try {
            Type t = this.getField(27, rep);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * SAC-27: "Additive" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE insertAdditive(int rep) throws HL7Exception { 
        return (CWE) super.insertRepetition(27, rep);
    }



    /**
     * Inserts a repetition of
     * SAC-27: "Additive" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE insertSac27_Additive(int rep) throws HL7Exception { 
        return (CWE) super.insertRepetition(27, rep);
    }


    /**
     * Removes a repetition of
     * SAC-27: "Additive" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE removeAdditive(int rep) throws HL7Exception { 
        return (CWE) super.removeRepetition(27, rep);
    }


    /**
     * Removes a repetition of
     * SAC-27: "Additive" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE removeSac27_Additive(int rep) throws HL7Exception { 
        return (CWE) super.removeRepetition(27, rep);
    }




    /**
     * Returns
     * SAC-28: "Specimen Component" - creates it if necessary
     */
    public CWE getSpecimenComponent() { 
        CWE ret = null;
        try {
            Type t = this.getField(28, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SAC-28: "Specimen Component" - creates it if necessary
     */
    public CWE getSac28_SpecimenComponent() { 
        CWE ret = null;
        try {
            Type t = this.getField(28, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SAC-29: "Dilution Factor" - creates it if necessary
     */
    public SN getDilutionFactor() { 
        SN ret = null;
        try {
            Type t = this.getField(29, 0);
            ret = (SN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SAC-29: "Dilution Factor" - creates it if necessary
     */
    public SN getSac29_DilutionFactor() { 
        SN ret = null;
        try {
            Type t = this.getField(29, 0);
            ret = (SN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SAC-30: "Treatment" - creates it if necessary
     */
    public CWE getTreatment() { 
        CWE ret = null;
        try {
            Type t = this.getField(30, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SAC-30: "Treatment" - creates it if necessary
     */
    public CWE getSac30_Treatment() { 
        CWE ret = null;
        try {
            Type t = this.getField(30, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SAC-31: "Temperature" - creates it if necessary
     */
    public SN getTemperature() { 
        SN ret = null;
        try {
            Type t = this.getField(31, 0);
            ret = (SN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SAC-31: "Temperature" - creates it if necessary
     */
    public SN getSac31_Temperature() { 
        SN ret = null;
        try {
            Type t = this.getField(31, 0);
            ret = (SN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SAC-32: "Hemolysis Index" - creates it if necessary
     */
    public NM getHemolysisIndex() { 
        NM ret = null;
        try {
            Type t = this.getField(32, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SAC-32: "Hemolysis Index" - creates it if necessary
     */
    public NM getSac32_HemolysisIndex() { 
        NM ret = null;
        try {
            Type t = this.getField(32, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SAC-33: "Hemolysis Index Units" - creates it if necessary
     */
    public CWE getHemolysisIndexUnits() { 
        CWE ret = null;
        try {
            Type t = this.getField(33, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SAC-33: "Hemolysis Index Units" - creates it if necessary
     */
    public CWE getSac33_HemolysisIndexUnits() { 
        CWE ret = null;
        try {
            Type t = this.getField(33, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SAC-34: "Lipemia Index" - creates it if necessary
     */
    public NM getLipemiaIndex() { 
        NM ret = null;
        try {
            Type t = this.getField(34, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SAC-34: "Lipemia Index" - creates it if necessary
     */
    public NM getSac34_LipemiaIndex() { 
        NM ret = null;
        try {
            Type t = this.getField(34, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SAC-35: "Lipemia Index Units" - creates it if necessary
     */
    public CWE getLipemiaIndexUnits() { 
        CWE ret = null;
        try {
            Type t = this.getField(35, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SAC-35: "Lipemia Index Units" - creates it if necessary
     */
    public CWE getSac35_LipemiaIndexUnits() { 
        CWE ret = null;
        try {
            Type t = this.getField(35, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SAC-36: "Icterus Index" - creates it if necessary
     */
    public NM getIcterusIndex() { 
        NM ret = null;
        try {
            Type t = this.getField(36, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SAC-36: "Icterus Index" - creates it if necessary
     */
    public NM getSac36_IcterusIndex() { 
        NM ret = null;
        try {
            Type t = this.getField(36, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SAC-37: "Icterus Index Units" - creates it if necessary
     */
    public CWE getIcterusIndexUnits() { 
        CWE ret = null;
        try {
            Type t = this.getField(37, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SAC-37: "Icterus Index Units" - creates it if necessary
     */
    public CWE getSac37_IcterusIndexUnits() { 
        CWE ret = null;
        try {
            Type t = this.getField(37, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SAC-38: "Fibrin Index" - creates it if necessary
     */
    public NM getFibrinIndex() { 
        NM ret = null;
        try {
            Type t = this.getField(38, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SAC-38: "Fibrin Index" - creates it if necessary
     */
    public NM getSac38_FibrinIndex() { 
        NM ret = null;
        try {
            Type t = this.getField(38, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SAC-39: "Fibrin Index Units" - creates it if necessary
     */
    public CWE getFibrinIndexUnits() { 
        CWE ret = null;
        try {
            Type t = this.getField(39, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SAC-39: "Fibrin Index Units" - creates it if necessary
     */
    public CWE getSac39_FibrinIndexUnits() { 
        CWE ret = null;
        try {
            Type t = this.getField(39, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of System Induced Contaminants (SAC-40).
     */
    public CWE[] getSystemInducedContaminants() {
        CWE[] ret = null;
        try {
            Type[] t = this.getField(40);  
            ret = new CWE[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CWE)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * SAC-40: "System Induced Contaminants" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CWE getSystemInducedContaminants(int rep) { 
        CWE ret = null;
        try {
            Type t = this.getField(40, rep);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * SAC-40: "System Induced Contaminants" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CWE getSac40_SystemInducedContaminants(int rep) { 
        CWE ret = null;
        try {
            Type t = this.getField(40, rep);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * SAC-40: "System Induced Contaminants" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE insertSystemInducedContaminants(int rep) throws HL7Exception { 
        return (CWE) super.insertRepetition(40, rep);
    }



    /**
     * Inserts a repetition of
     * SAC-40: "System Induced Contaminants" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE insertSac40_SystemInducedContaminants(int rep) throws HL7Exception { 
        return (CWE) super.insertRepetition(40, rep);
    }


    /**
     * Removes a repetition of
     * SAC-40: "System Induced Contaminants" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE removeSystemInducedContaminants(int rep) throws HL7Exception { 
        return (CWE) super.removeRepetition(40, rep);
    }


    /**
     * Removes a repetition of
     * SAC-40: "System Induced Contaminants" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE removeSac40_SystemInducedContaminants(int rep) throws HL7Exception { 
        return (CWE) super.removeRepetition(40, rep);
    }



    /**
     * Returns all repetitions of Drug Interference (SAC-41).
     */
    public CWE[] getDrugInterference() {
        CWE[] ret = null;
        try {
            Type[] t = this.getField(41);  
            ret = new CWE[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CWE)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * SAC-41: "Drug Interference" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CWE getDrugInterference(int rep) { 
        CWE ret = null;
        try {
            Type t = this.getField(41, rep);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * SAC-41: "Drug Interference" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CWE getSac41_DrugInterference(int rep) { 
        CWE ret = null;
        try {
            Type t = this.getField(41, rep);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * SAC-41: "Drug Interference" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE insertDrugInterference(int rep) throws HL7Exception { 
        return (CWE) super.insertRepetition(41, rep);
    }



    /**
     * Inserts a repetition of
     * SAC-41: "Drug Interference" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE insertSac41_DrugInterference(int rep) throws HL7Exception { 
        return (CWE) super.insertRepetition(41, rep);
    }


    /**
     * Removes a repetition of
     * SAC-41: "Drug Interference" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE removeDrugInterference(int rep) throws HL7Exception { 
        return (CWE) super.removeRepetition(41, rep);
    }


    /**
     * Removes a repetition of
     * SAC-41: "Drug Interference" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE removeSac41_DrugInterference(int rep) throws HL7Exception { 
        return (CWE) super.removeRepetition(41, rep);
    }




    /**
     * Returns
     * SAC-42: "Artificial Blood" - creates it if necessary
     */
    public CWE getArtificialBlood() { 
        CWE ret = null;
        try {
            Type t = this.getField(42, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SAC-42: "Artificial Blood" - creates it if necessary
     */
    public CWE getSac42_ArtificialBlood() { 
        CWE ret = null;
        try {
            Type t = this.getField(42, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Special Handling Code (SAC-43).
     */
    public CWE[] getSpecialHandlingCode() {
        CWE[] ret = null;
        try {
            Type[] t = this.getField(43);  
            ret = new CWE[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CWE)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * SAC-43: "Special Handling Code" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CWE getSpecialHandlingCode(int rep) { 
        CWE ret = null;
        try {
            Type t = this.getField(43, rep);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * SAC-43: "Special Handling Code" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CWE getSac43_SpecialHandlingCode(int rep) { 
        CWE ret = null;
        try {
            Type t = this.getField(43, rep);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * SAC-43: "Special Handling Code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE insertSpecialHandlingCode(int rep) throws HL7Exception { 
        return (CWE) super.insertRepetition(43, rep);
    }



    /**
     * Inserts a repetition of
     * SAC-43: "Special Handling Code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE insertSac43_SpecialHandlingCode(int rep) throws HL7Exception { 
        return (CWE) super.insertRepetition(43, rep);
    }


    /**
     * Removes a repetition of
     * SAC-43: "Special Handling Code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE removeSpecialHandlingCode(int rep) throws HL7Exception { 
        return (CWE) super.removeRepetition(43, rep);
    }


    /**
     * Removes a repetition of
     * SAC-43: "Special Handling Code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE removeSac43_SpecialHandlingCode(int rep) throws HL7Exception { 
        return (CWE) super.removeRepetition(43, rep);
    }



    /**
     * Returns all repetitions of Other Environmental Factors (SAC-44).
     */
    public CWE[] getOtherEnvironmentalFactors() {
        CWE[] ret = null;
        try {
            Type[] t = this.getField(44);  
            ret = new CWE[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CWE)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * SAC-44: "Other Environmental Factors" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CWE getOtherEnvironmentalFactors(int rep) { 
        CWE ret = null;
        try {
            Type t = this.getField(44, rep);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * SAC-44: "Other Environmental Factors" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CWE getSac44_OtherEnvironmentalFactors(int rep) { 
        CWE ret = null;
        try {
            Type t = this.getField(44, rep);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * SAC-44: "Other Environmental Factors" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE insertOtherEnvironmentalFactors(int rep) throws HL7Exception { 
        return (CWE) super.insertRepetition(44, rep);
    }



    /**
     * Inserts a repetition of
     * SAC-44: "Other Environmental Factors" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE insertSac44_OtherEnvironmentalFactors(int rep) throws HL7Exception { 
        return (CWE) super.insertRepetition(44, rep);
    }


    /**
     * Removes a repetition of
     * SAC-44: "Other Environmental Factors" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE removeOtherEnvironmentalFactors(int rep) throws HL7Exception { 
        return (CWE) super.removeRepetition(44, rep);
    }


    /**
     * Removes a repetition of
     * SAC-44: "Other Environmental Factors" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE removeSac44_OtherEnvironmentalFactors(int rep) throws HL7Exception { 
        return (CWE) super.removeRepetition(44, rep);
    }






    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new EI(getMessage());
          case 1: return new EI(getMessage());
          case 2: return new EI(getMessage());
          case 3: return new EI(getMessage());
          case 4: return new EI(getMessage());
          case 5: return new SPS(getMessage());
          case 6: return new DTM(getMessage());
          case 7: return new CWE(getMessage());
          case 8: return new CWE(getMessage());
          case 9: return new EI(getMessage());
          case 10: return new NA(getMessage());
          case 11: return new CWE(getMessage());
          case 12: return new EI(getMessage());
          case 13: return new NA(getMessage());
          case 14: return new CWE(getMessage());
          case 15: return new NM(getMessage());
          case 16: return new NM(getMessage());
          case 17: return new NM(getMessage());
          case 18: return new NM(getMessage());
          case 19: return new CWE(getMessage());
          case 20: return new NM(getMessage());
          case 21: return new NM(getMessage());
          case 22: return new NM(getMessage());
          case 23: return new CWE(getMessage());
          case 24: return new CWE(getMessage());
          case 25: return new CWE(getMessage());
          case 26: return new CWE(getMessage());
          case 27: return new CWE(getMessage());
          case 28: return new SN(getMessage());
          case 29: return new CWE(getMessage());
          case 30: return new SN(getMessage());
          case 31: return new NM(getMessage());
          case 32: return new CWE(getMessage());
          case 33: return new NM(getMessage());
          case 34: return new CWE(getMessage());
          case 35: return new NM(getMessage());
          case 36: return new CWE(getMessage());
          case 37: return new NM(getMessage());
          case 38: return new CWE(getMessage());
          case 39: return new CWE(getMessage());
          case 40: return new CWE(getMessage());
          case 41: return new CWE(getMessage());
          case 42: return new CWE(getMessage());
          case 43: return new CWE(getMessage());
          default: return null;
       }
   }


}

