/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v26.segment;

// import ca.uhn.hl7v2.model.v26.group.*;
import ca.uhn.hl7v2.model.v26.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 SCD message segment (Anti-Microbial Cycle Data). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>SCD-1: Cycle Start Time (TM) <b>optional </b>
     * <li>SCD-2: Cycle Count (NM) <b>optional </b>
     * <li>SCD-3: Temp Max (CQ) <b>optional </b>
     * <li>SCD-4: Temp Min (CQ) <b>optional </b>
     * <li>SCD-5: Load Number (NM) <b>optional </b>
     * <li>SCD-6: Condition Time (CQ) <b>optional </b>
     * <li>SCD-7: Sterilize Time (CQ) <b>optional </b>
     * <li>SCD-8: Exhaust Time (CQ) <b>optional </b>
     * <li>SCD-9: Total Cycle Time (CQ) <b>optional </b>
     * <li>SCD-10: Device Status (CWE) <b>optional </b>
     * <li>SCD-11: Cycle Start Date/Time (DTM) <b>optional </b>
     * <li>SCD-12: Dry Time (CQ) <b>optional </b>
     * <li>SCD-13: Leak Rate (CQ) <b>optional </b>
     * <li>SCD-14: Control Temperature (CQ) <b>optional </b>
     * <li>SCD-15: Sterilizer Temperature (CQ) <b>optional </b>
     * <li>SCD-16: Cycle Complete Time (TM) <b>optional </b>
     * <li>SCD-17: Under Temperature (CQ) <b>optional </b>
     * <li>SCD-18: Over Temperature (CQ) <b>optional </b>
     * <li>SCD-19: Abort Cycle (CNE) <b>optional </b>
     * <li>SCD-20: Alarm (CNE) <b>optional </b>
     * <li>SCD-21: Long in Charge Phase (CNE) <b>optional </b>
     * <li>SCD-22: Long in Exhaust Phase (CNE) <b>optional </b>
     * <li>SCD-23: Long in Fast Exhaust Phase (CNE) <b>optional </b>
     * <li>SCD-24: Reset (CNE) <b>optional </b>
     * <li>SCD-25: Operator - Unload (XCN) <b>optional </b>
     * <li>SCD-26: Door Open (CNE) <b>optional </b>
     * <li>SCD-27: Reading Failure (CNE) <b>optional </b>
     * <li>SCD-28: Cycle Type (CWE) <b>optional </b>
     * <li>SCD-29: Thermal Rinse Time (CQ) <b>optional </b>
     * <li>SCD-30: Wash Time (CQ) <b>optional </b>
     * <li>SCD-31: Injection Rate (CQ) <b>optional </b>
     * <li>SCD-32: Procedure Code (CNE) <b>optional </b>
     * <li>SCD-33: Patient Identifier List (CX) <b>optional repeating</b>
     * <li>SCD-34: Attending Doctor (XCN) <b>optional </b>
     * <li>SCD-35: Dilution Factor (SN) <b>optional </b>
     * <li>SCD-36: Fill Time (CQ) <b>optional </b>
     * <li>SCD-37: Inlet Temperature (CQ) <b>optional </b>
 * </ul>
 */
public class SCD extends AbstractSegment {

    /** 
     * Creates a new SCD segment
     */
    public SCD(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(TM.class, false, 1, 16, new Object[]{ getMessage(), new Integer(0) }, "Cycle Start Time");
                                  this.add(NM.class, false, 1, 16, new Object[]{ getMessage(), new Integer(0) }, "Cycle Count");
                                  this.add(CQ.class, false, 1, 36, new Object[]{ getMessage(), new Integer(0) }, "Temp Max");
                                  this.add(CQ.class, false, 1, 36, new Object[]{ getMessage(), new Integer(0) }, "Temp Min");
                                  this.add(NM.class, false, 1, 16, new Object[]{ getMessage(), new Integer(0) }, "Load Number");
                                  this.add(CQ.class, false, 1, 16, new Object[]{ getMessage(), new Integer(0) }, "Condition Time");
                                  this.add(CQ.class, false, 1, 16, new Object[]{ getMessage(), new Integer(0) }, "Sterilize Time");
                                  this.add(CQ.class, false, 1, 16, new Object[]{ getMessage(), new Integer(0) }, "Exhaust Time");
                                  this.add(CQ.class, false, 1, 16, new Object[]{ getMessage(), new Integer(0) }, "Total Cycle Time");
                                  this.add(CWE.class, false, 1, 4, new Object[]{ getMessage(), new Integer(682) }, "Device Status");
                                  this.add(DTM.class, false, 1, 24, new Object[]{ getMessage(), new Integer(0) }, "Cycle Start Date/Time");
                                  this.add(CQ.class, false, 1, 16, new Object[]{ getMessage(), new Integer(0) }, "Dry Time");
                                  this.add(CQ.class, false, 1, 16, new Object[]{ getMessage(), new Integer(0) }, "Leak Rate");
                                  this.add(CQ.class, false, 1, 36, new Object[]{ getMessage(), new Integer(0) }, "Control Temperature");
                                  this.add(CQ.class, false, 1, 36, new Object[]{ getMessage(), new Integer(0) }, "Sterilizer Temperature");
                                  this.add(TM.class, false, 1, 16, new Object[]{ getMessage(), new Integer(0) }, "Cycle Complete Time");
                                  this.add(CQ.class, false, 1, 36, new Object[]{ getMessage(), new Integer(0) }, "Under Temperature");
                                  this.add(CQ.class, false, 1, 36, new Object[]{ getMessage(), new Integer(0) }, "Over Temperature");
                                  this.add(CNE.class, false, 1, 4, new Object[]{ getMessage(), new Integer(532) }, "Abort Cycle");
                                  this.add(CNE.class, false, 1, 4, new Object[]{ getMessage(), new Integer(532) }, "Alarm");
                                  this.add(CNE.class, false, 1, 4, new Object[]{ getMessage(), new Integer(532) }, "Long in Charge Phase");
                                  this.add(CNE.class, false, 1, 4, new Object[]{ getMessage(), new Integer(532) }, "Long in Exhaust Phase");
                                  this.add(CNE.class, false, 1, 4, new Object[]{ getMessage(), new Integer(532) }, "Long in Fast Exhaust Phase");
                                  this.add(CNE.class, false, 1, 4, new Object[]{ getMessage(), new Integer(532) }, "Reset");
                                  this.add(XCN.class, false, 1, 15, new Object[]{ getMessage(), new Integer(0) }, "Operator - Unload");
                                  this.add(CNE.class, false, 1, 4, new Object[]{ getMessage(), new Integer(532) }, "Door Open");
                                  this.add(CNE.class, false, 1, 4, new Object[]{ getMessage(), new Integer(532) }, "Reading Failure");
                                  this.add(CWE.class, false, 1, 3, new Object[]{ getMessage(), new Integer(702) }, "Cycle Type");
                                  this.add(CQ.class, false, 1, 16, new Object[]{ getMessage(), new Integer(0) }, "Thermal Rinse Time");
                                  this.add(CQ.class, false, 1, 16, new Object[]{ getMessage(), new Integer(0) }, "Wash Time");
                                  this.add(CQ.class, false, 1, 16, new Object[]{ getMessage(), new Integer(0) }, "Injection Rate");
                                  this.add(CNE.class, false, 1, 705, new Object[]{ getMessage(), new Integer(88) }, "Procedure Code");
                                  this.add(CX.class, false, 0, 250, new Object[]{ getMessage(), new Integer(0) }, "Patient Identifier List");
                                  this.add(XCN.class, false, 1, 250, new Object[]{ getMessage(), new Integer(10) }, "Attending Doctor");
                                  this.add(SN.class, false, 1, 36, new Object[]{ getMessage(), new Integer(0) }, "Dilution Factor");
                                  this.add(CQ.class, false, 1, 16, new Object[]{ getMessage(), new Integer(0) }, "Fill Time");
                                  this.add(CQ.class, false, 1, 36, new Object[]{ getMessage(), new Integer(0) }, "Inlet Temperature");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating SCD - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * SCD-1: "Cycle Start Time" - creates it if necessary
     */
    public TM getCycleStartTime() { 
        TM ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (TM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SCD-1: "Cycle Start Time" - creates it if necessary
     */
    public TM getScd1_CycleStartTime() { 
        TM ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (TM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SCD-2: "Cycle Count" - creates it if necessary
     */
    public NM getCycleCount() { 
        NM ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SCD-2: "Cycle Count" - creates it if necessary
     */
    public NM getScd2_CycleCount() { 
        NM ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SCD-3: "Temp Max" - creates it if necessary
     */
    public CQ getTempMax() { 
        CQ ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SCD-3: "Temp Max" - creates it if necessary
     */
    public CQ getScd3_TempMax() { 
        CQ ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SCD-4: "Temp Min" - creates it if necessary
     */
    public CQ getTempMin() { 
        CQ ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (CQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SCD-4: "Temp Min" - creates it if necessary
     */
    public CQ getScd4_TempMin() { 
        CQ ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (CQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SCD-5: "Load Number" - creates it if necessary
     */
    public NM getLoadNumber() { 
        NM ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SCD-5: "Load Number" - creates it if necessary
     */
    public NM getScd5_LoadNumber() { 
        NM ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SCD-6: "Condition Time" - creates it if necessary
     */
    public CQ getConditionTime() { 
        CQ ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (CQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SCD-6: "Condition Time" - creates it if necessary
     */
    public CQ getScd6_ConditionTime() { 
        CQ ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (CQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SCD-7: "Sterilize Time" - creates it if necessary
     */
    public CQ getSterilizeTime() { 
        CQ ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (CQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SCD-7: "Sterilize Time" - creates it if necessary
     */
    public CQ getScd7_SterilizeTime() { 
        CQ ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (CQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SCD-8: "Exhaust Time" - creates it if necessary
     */
    public CQ getExhaustTime() { 
        CQ ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (CQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SCD-8: "Exhaust Time" - creates it if necessary
     */
    public CQ getScd8_ExhaustTime() { 
        CQ ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (CQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SCD-9: "Total Cycle Time" - creates it if necessary
     */
    public CQ getTotalCycleTime() { 
        CQ ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (CQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SCD-9: "Total Cycle Time" - creates it if necessary
     */
    public CQ getScd9_TotalCycleTime() { 
        CQ ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (CQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SCD-10: "Device Status" - creates it if necessary
     */
    public CWE getDeviceStatus() { 
        CWE ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SCD-10: "Device Status" - creates it if necessary
     */
    public CWE getScd10_DeviceStatus() { 
        CWE ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SCD-11: "Cycle Start Date/Time" - creates it if necessary
     */
    public DTM getCycleStartDateTime() { 
        DTM ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SCD-11: "Cycle Start Date/Time" - creates it if necessary
     */
    public DTM getScd11_CycleStartDateTime() { 
        DTM ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SCD-12: "Dry Time" - creates it if necessary
     */
    public CQ getDryTime() { 
        CQ ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (CQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SCD-12: "Dry Time" - creates it if necessary
     */
    public CQ getScd12_DryTime() { 
        CQ ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (CQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SCD-13: "Leak Rate" - creates it if necessary
     */
    public CQ getLeakRate() { 
        CQ ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (CQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SCD-13: "Leak Rate" - creates it if necessary
     */
    public CQ getScd13_LeakRate() { 
        CQ ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (CQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SCD-14: "Control Temperature" - creates it if necessary
     */
    public CQ getControlTemperature() { 
        CQ ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (CQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SCD-14: "Control Temperature" - creates it if necessary
     */
    public CQ getScd14_ControlTemperature() { 
        CQ ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (CQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SCD-15: "Sterilizer Temperature" - creates it if necessary
     */
    public CQ getSterilizerTemperature() { 
        CQ ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (CQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SCD-15: "Sterilizer Temperature" - creates it if necessary
     */
    public CQ getScd15_SterilizerTemperature() { 
        CQ ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (CQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SCD-16: "Cycle Complete Time" - creates it if necessary
     */
    public TM getCycleCompleteTime() { 
        TM ret = null;
        try {
            Type t = this.getField(16, 0);
            ret = (TM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SCD-16: "Cycle Complete Time" - creates it if necessary
     */
    public TM getScd16_CycleCompleteTime() { 
        TM ret = null;
        try {
            Type t = this.getField(16, 0);
            ret = (TM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SCD-17: "Under Temperature" - creates it if necessary
     */
    public CQ getUnderTemperature() { 
        CQ ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (CQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SCD-17: "Under Temperature" - creates it if necessary
     */
    public CQ getScd17_UnderTemperature() { 
        CQ ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (CQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SCD-18: "Over Temperature" - creates it if necessary
     */
    public CQ getOverTemperature() { 
        CQ ret = null;
        try {
            Type t = this.getField(18, 0);
            ret = (CQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SCD-18: "Over Temperature" - creates it if necessary
     */
    public CQ getScd18_OverTemperature() { 
        CQ ret = null;
        try {
            Type t = this.getField(18, 0);
            ret = (CQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SCD-19: "Abort Cycle" - creates it if necessary
     */
    public CNE getAbortCycle() { 
        CNE ret = null;
        try {
            Type t = this.getField(19, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SCD-19: "Abort Cycle" - creates it if necessary
     */
    public CNE getScd19_AbortCycle() { 
        CNE ret = null;
        try {
            Type t = this.getField(19, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SCD-20: "Alarm" - creates it if necessary
     */
    public CNE getAlarm() { 
        CNE ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SCD-20: "Alarm" - creates it if necessary
     */
    public CNE getScd20_Alarm() { 
        CNE ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SCD-21: "Long in Charge Phase" - creates it if necessary
     */
    public CNE getLongInChargePhase() { 
        CNE ret = null;
        try {
            Type t = this.getField(21, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SCD-21: "Long in Charge Phase" - creates it if necessary
     */
    public CNE getScd21_LongInChargePhase() { 
        CNE ret = null;
        try {
            Type t = this.getField(21, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SCD-22: "Long in Exhaust Phase" - creates it if necessary
     */
    public CNE getLongInExhaustPhase() { 
        CNE ret = null;
        try {
            Type t = this.getField(22, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SCD-22: "Long in Exhaust Phase" - creates it if necessary
     */
    public CNE getScd22_LongInExhaustPhase() { 
        CNE ret = null;
        try {
            Type t = this.getField(22, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SCD-23: "Long in Fast Exhaust Phase" - creates it if necessary
     */
    public CNE getLongInFastExhaustPhase() { 
        CNE ret = null;
        try {
            Type t = this.getField(23, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SCD-23: "Long in Fast Exhaust Phase" - creates it if necessary
     */
    public CNE getScd23_LongInFastExhaustPhase() { 
        CNE ret = null;
        try {
            Type t = this.getField(23, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SCD-24: "Reset" - creates it if necessary
     */
    public CNE getReset() { 
        CNE ret = null;
        try {
            Type t = this.getField(24, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SCD-24: "Reset" - creates it if necessary
     */
    public CNE getScd24_Reset() { 
        CNE ret = null;
        try {
            Type t = this.getField(24, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SCD-25: "Operator - Unload" - creates it if necessary
     */
    public XCN getOperatorUnload() { 
        XCN ret = null;
        try {
            Type t = this.getField(25, 0);
            ret = (XCN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SCD-25: "Operator - Unload" - creates it if necessary
     */
    public XCN getScd25_OperatorUnload() { 
        XCN ret = null;
        try {
            Type t = this.getField(25, 0);
            ret = (XCN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SCD-26: "Door Open" - creates it if necessary
     */
    public CNE getDoorOpen() { 
        CNE ret = null;
        try {
            Type t = this.getField(26, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SCD-26: "Door Open" - creates it if necessary
     */
    public CNE getScd26_DoorOpen() { 
        CNE ret = null;
        try {
            Type t = this.getField(26, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SCD-27: "Reading Failure" - creates it if necessary
     */
    public CNE getReadingFailure() { 
        CNE ret = null;
        try {
            Type t = this.getField(27, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SCD-27: "Reading Failure" - creates it if necessary
     */
    public CNE getScd27_ReadingFailure() { 
        CNE ret = null;
        try {
            Type t = this.getField(27, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SCD-28: "Cycle Type" - creates it if necessary
     */
    public CWE getCycleType() { 
        CWE ret = null;
        try {
            Type t = this.getField(28, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SCD-28: "Cycle Type" - creates it if necessary
     */
    public CWE getScd28_CycleType() { 
        CWE ret = null;
        try {
            Type t = this.getField(28, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SCD-29: "Thermal Rinse Time" - creates it if necessary
     */
    public CQ getThermalRinseTime() { 
        CQ ret = null;
        try {
            Type t = this.getField(29, 0);
            ret = (CQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SCD-29: "Thermal Rinse Time" - creates it if necessary
     */
    public CQ getScd29_ThermalRinseTime() { 
        CQ ret = null;
        try {
            Type t = this.getField(29, 0);
            ret = (CQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SCD-30: "Wash Time" - creates it if necessary
     */
    public CQ getWashTime() { 
        CQ ret = null;
        try {
            Type t = this.getField(30, 0);
            ret = (CQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SCD-30: "Wash Time" - creates it if necessary
     */
    public CQ getScd30_WashTime() { 
        CQ ret = null;
        try {
            Type t = this.getField(30, 0);
            ret = (CQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SCD-31: "Injection Rate" - creates it if necessary
     */
    public CQ getInjectionRate() { 
        CQ ret = null;
        try {
            Type t = this.getField(31, 0);
            ret = (CQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SCD-31: "Injection Rate" - creates it if necessary
     */
    public CQ getScd31_InjectionRate() { 
        CQ ret = null;
        try {
            Type t = this.getField(31, 0);
            ret = (CQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SCD-32: "Procedure Code" - creates it if necessary
     */
    public CNE getProcedureCode() { 
        CNE ret = null;
        try {
            Type t = this.getField(32, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SCD-32: "Procedure Code" - creates it if necessary
     */
    public CNE getScd32_ProcedureCode() { 
        CNE ret = null;
        try {
            Type t = this.getField(32, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Patient Identifier List (SCD-33).
     */
    public CX[] getPatientIdentifierList() {
        CX[] ret = null;
        try {
            Type[] t = this.getField(33);  
            ret = new CX[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CX)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * SCD-33: "Patient Identifier List" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CX getPatientIdentifierList(int rep) { 
        CX ret = null;
        try {
            Type t = this.getField(33, rep);
            ret = (CX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * SCD-33: "Patient Identifier List" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CX getScd33_PatientIdentifierList(int rep) { 
        CX ret = null;
        try {
            Type t = this.getField(33, rep);
            ret = (CX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * SCD-33: "Patient Identifier List" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CX insertPatientIdentifierList(int rep) throws HL7Exception { 
        return (CX) super.insertRepetition(33, rep);
    }



    /**
     * Inserts a repetition of
     * SCD-33: "Patient Identifier List" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CX insertScd33_PatientIdentifierList(int rep) throws HL7Exception { 
        return (CX) super.insertRepetition(33, rep);
    }


    /**
     * Removes a repetition of
     * SCD-33: "Patient Identifier List" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CX removePatientIdentifierList(int rep) throws HL7Exception { 
        return (CX) super.removeRepetition(33, rep);
    }


    /**
     * Removes a repetition of
     * SCD-33: "Patient Identifier List" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CX removeScd33_PatientIdentifierList(int rep) throws HL7Exception { 
        return (CX) super.removeRepetition(33, rep);
    }




    /**
     * Returns
     * SCD-34: "Attending Doctor" - creates it if necessary
     */
    public XCN getAttendingDoctor() { 
        XCN ret = null;
        try {
            Type t = this.getField(34, 0);
            ret = (XCN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SCD-34: "Attending Doctor" - creates it if necessary
     */
    public XCN getScd34_AttendingDoctor() { 
        XCN ret = null;
        try {
            Type t = this.getField(34, 0);
            ret = (XCN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SCD-35: "Dilution Factor" - creates it if necessary
     */
    public SN getDilutionFactor() { 
        SN ret = null;
        try {
            Type t = this.getField(35, 0);
            ret = (SN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SCD-35: "Dilution Factor" - creates it if necessary
     */
    public SN getScd35_DilutionFactor() { 
        SN ret = null;
        try {
            Type t = this.getField(35, 0);
            ret = (SN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SCD-36: "Fill Time" - creates it if necessary
     */
    public CQ getFillTime() { 
        CQ ret = null;
        try {
            Type t = this.getField(36, 0);
            ret = (CQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SCD-36: "Fill Time" - creates it if necessary
     */
    public CQ getScd36_FillTime() { 
        CQ ret = null;
        try {
            Type t = this.getField(36, 0);
            ret = (CQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SCD-37: "Inlet Temperature" - creates it if necessary
     */
    public CQ getInletTemperature() { 
        CQ ret = null;
        try {
            Type t = this.getField(37, 0);
            ret = (CQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SCD-37: "Inlet Temperature" - creates it if necessary
     */
    public CQ getScd37_InletTemperature() { 
        CQ ret = null;
        try {
            Type t = this.getField(37, 0);
            ret = (CQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new TM(getMessage());
          case 1: return new NM(getMessage());
          case 2: return new CQ(getMessage());
          case 3: return new CQ(getMessage());
          case 4: return new NM(getMessage());
          case 5: return new CQ(getMessage());
          case 6: return new CQ(getMessage());
          case 7: return new CQ(getMessage());
          case 8: return new CQ(getMessage());
          case 9: return new CWE(getMessage());
          case 10: return new DTM(getMessage());
          case 11: return new CQ(getMessage());
          case 12: return new CQ(getMessage());
          case 13: return new CQ(getMessage());
          case 14: return new CQ(getMessage());
          case 15: return new TM(getMessage());
          case 16: return new CQ(getMessage());
          case 17: return new CQ(getMessage());
          case 18: return new CNE(getMessage());
          case 19: return new CNE(getMessage());
          case 20: return new CNE(getMessage());
          case 21: return new CNE(getMessage());
          case 22: return new CNE(getMessage());
          case 23: return new CNE(getMessage());
          case 24: return new XCN(getMessage());
          case 25: return new CNE(getMessage());
          case 26: return new CNE(getMessage());
          case 27: return new CWE(getMessage());
          case 28: return new CQ(getMessage());
          case 29: return new CQ(getMessage());
          case 30: return new CQ(getMessage());
          case 31: return new CNE(getMessage());
          case 32: return new CX(getMessage());
          case 33: return new XCN(getMessage());
          case 34: return new SN(getMessage());
          case 35: return new CQ(getMessage());
          case 36: return new CQ(getMessage());
          default: return null;
       }
   }


}

