/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v26.segment;

// import ca.uhn.hl7v2.model.v26.group.*;
import ca.uhn.hl7v2.model.v26.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 SDD message segment (Sterilization Device Data). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>SDD-1: Lot Number (EI) <b>optional </b>
     * <li>SDD-2: Device Number (EI) <b>optional </b>
     * <li>SDD-3: Device Name (ST) <b>optional </b>
     * <li>SDD-4: Device Data State (IS) <b>optional </b>
     * <li>SDD-5: Load Status (IS) <b>optional </b>
     * <li>SDD-6: Control Code (NM) <b>optional </b>
     * <li>SDD-7: Operator Name (ST) <b>optional </b>
 * </ul>
 */
public class SDD extends AbstractSegment {

    /** 
     * Creates a new SDD segment
     */
    public SDD(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(EI.class, false, 1, 11, new Object[]{ getMessage(), new Integer(0) }, "Lot Number");
                                  this.add(EI.class, false, 1, 8, new Object[]{ getMessage(), new Integer(0) }, "Device Number");
                                  this.add(ST.class, false, 1, 999, new Object[]{ getMessage(), new Integer(0) }, "Device Name");
                                  this.add(IS.class, false, 1, 1, new Object[]{ getMessage() }, "Device Data State");
                                  this.add(IS.class, false, 1, 3, new Object[]{ getMessage() }, "Load Status");
                                  this.add(NM.class, false, 1, 3, new Object[]{ getMessage(), new Integer(0) }, "Control Code");
                                  this.add(ST.class, false, 1, 15, new Object[]{ getMessage(), new Integer(0) }, "Operator Name");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating SDD - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * SDD-1: "Lot Number" - creates it if necessary
     */
    public EI getLotNumber() { 
        EI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SDD-1: "Lot Number" - creates it if necessary
     */
    public EI getSdd1_LotNumber() { 
        EI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SDD-2: "Device Number" - creates it if necessary
     */
    public EI getDeviceNumber() { 
        EI ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SDD-2: "Device Number" - creates it if necessary
     */
    public EI getSdd2_DeviceNumber() { 
        EI ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SDD-3: "Device Name" - creates it if necessary
     */
    public ST getDeviceName() { 
        ST ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SDD-3: "Device Name" - creates it if necessary
     */
    public ST getSdd3_DeviceName() { 
        ST ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SDD-4: "Device Data State" - creates it if necessary
     */
    public IS getDeviceDataState() { 
        IS ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SDD-4: "Device Data State" - creates it if necessary
     */
    public IS getSdd4_DeviceDataState() { 
        IS ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SDD-5: "Load Status" - creates it if necessary
     */
    public IS getLoadStatus() { 
        IS ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SDD-5: "Load Status" - creates it if necessary
     */
    public IS getSdd5_LoadStatus() { 
        IS ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SDD-6: "Control Code" - creates it if necessary
     */
    public NM getControlCode() { 
        NM ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SDD-6: "Control Code" - creates it if necessary
     */
    public NM getSdd6_ControlCode() { 
        NM ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * SDD-7: "Operator Name" - creates it if necessary
     */
    public ST getOperatorName() { 
        ST ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * SDD-7: "Operator Name" - creates it if necessary
     */
    public ST getSdd7_OperatorName() { 
        ST ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new EI(getMessage());
          case 1: return new EI(getMessage());
          case 2: return new ST(getMessage());
          case 3: return new IS(getMessage(), new Integer( 667 ));
          case 4: return new IS(getMessage(), new Integer( 669 ));
          case 5: return new NM(getMessage());
          case 6: return new ST(getMessage());
          default: return null;
       }
   }


}

