/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v26.segment;

// import ca.uhn.hl7v2.model.v26.group.*;
import ca.uhn.hl7v2.model.v26.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 VND message segment (Purchasing Vendor). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>VND-1: Set Id - VND (SI) <b> </b>
     * <li>VND-2: Vendor Identifier (EI) <b> </b>
     * <li>VND-3: Vendor Name (ST) <b>optional </b>
     * <li>VND-4: Vendor Catalog Number (EI) <b>optional </b>
     * <li>VND-5: Primary Vendor Indicator (CNE) <b>optional </b>
 * </ul>
 */
public class VND extends AbstractSegment {

    /** 
     * Creates a new VND segment
     */
    public VND(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(SI.class, true, 1, 2, new Object[]{ getMessage(), new Integer(0) }, "Set Id - VND");
                                  this.add(EI.class, true, 1, 250, new Object[]{ getMessage(), new Integer(0) }, "Vendor Identifier");
                                  this.add(ST.class, false, 1, 999, new Object[]{ getMessage(), new Integer(0) }, "Vendor Name");
                                  this.add(EI.class, false, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "Vendor Catalog Number");
                                  this.add(CNE.class, false, 1, 1, new Object[]{ getMessage(), new Integer(532) }, "Primary Vendor Indicator");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating VND - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * VND-1: "Set Id - VND" - creates it if necessary
     */
    public SI getSetIdVND() { 
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * VND-1: "Set Id - VND" - creates it if necessary
     */
    public SI getVnd1_SetIdVND() { 
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * VND-2: "Vendor Identifier" - creates it if necessary
     */
    public EI getVendorIdentifier() { 
        EI ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * VND-2: "Vendor Identifier" - creates it if necessary
     */
    public EI getVnd2_VendorIdentifier() { 
        EI ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * VND-3: "Vendor Name" - creates it if necessary
     */
    public ST getVendorName() { 
        ST ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * VND-3: "Vendor Name" - creates it if necessary
     */
    public ST getVnd3_VendorName() { 
        ST ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * VND-4: "Vendor Catalog Number" - creates it if necessary
     */
    public EI getVendorCatalogNumber() { 
        EI ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * VND-4: "Vendor Catalog Number" - creates it if necessary
     */
    public EI getVnd4_VendorCatalogNumber() { 
        EI ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * VND-5: "Primary Vendor Indicator" - creates it if necessary
     */
    public CNE getPrimaryVendorIndicator() { 
        CNE ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * VND-5: "Primary Vendor Indicator" - creates it if necessary
     */
    public CNE getVnd5_PrimaryVendorIndicator() { 
        CNE ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new SI(getMessage());
          case 1: return new EI(getMessage());
          case 2: return new ST(getMessage());
          case 3: return new EI(getMessage());
          case 4: return new CNE(getMessage());
          default: return null;
       }
   }


}

