/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v26.group.EHC_E20_PAT_INFO;
import ca.uhn.hl7v2.model.v26.group.EHC_E20_PSL_ITEM_INFO;
import ca.uhn.hl7v2.model.v26.segment.CTD;
import ca.uhn.hl7v2.model.v26.segment.IVC;
import ca.uhn.hl7v2.model.v26.segment.LOC;
import ca.uhn.hl7v2.model.v26.segment.MSH;
import ca.uhn.hl7v2.model.v26.segment.ROL;
import ca.uhn.hl7v2.model.v26.segment.SFT;
import ca.uhn.hl7v2.model.v26.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class EHC_E20
extends AbstractMessage {
    public EHC_E20(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    public EHC_E20() {
        super((ModelClassFactory)new DefaultModelClassFactory());
        this.init((ModelClassFactory)new DefaultModelClassFactory());
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, true);
            this.add(IVC.class, true, false);
            this.add(CTD.class, true, true);
            this.add(LOC.class, false, true);
            this.add(ROL.class, false, true);
            this.add(EHC_E20_PAT_INFO.class, true, true);
            this.add(EHC_E20_PSL_ITEM_INFO.class, true, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating EHC_E20 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public MSH getMSH() {
        MSH ret = null;
        try {
            ret = (MSH)this.get("MSH");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public SFT getSFT() {
        SFT ret = null;
        try {
            ret = (SFT)this.get("SFT");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public SFT getSFT(int rep) {
        SFT ret = null;
        try {
            ret = (SFT)this.get("SFT", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getSFTReps() {
        int reps = -1;
        try {
            reps = this.getAll("SFT").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", (Structure)structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        UAC ret = null;
        try {
            ret = (UAC)this.get("UAC");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public UAC getUAC(int rep) {
        UAC ret = null;
        try {
            ret = (UAC)this.get("UAC", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getUACReps() {
        int reps = -1;
        try {
            reps = this.getAll("UAC").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertUAC(UAC structure, int rep) throws HL7Exception {
        super.insertRepetition("UAC", (Structure)structure, rep);
    }

    public UAC insertUAC(int rep) throws HL7Exception {
        return (UAC)super.insertRepetition("UAC", rep);
    }

    public UAC removeUAC(int rep) throws HL7Exception {
        return (UAC)super.removeRepetition("UAC", rep);
    }

    public IVC getIVC() {
        IVC ret = null;
        try {
            ret = (IVC)this.get("IVC");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public CTD getCTD() {
        CTD ret = null;
        try {
            ret = (CTD)this.get("CTD");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public CTD getCTD(int rep) {
        CTD ret = null;
        try {
            ret = (CTD)this.get("CTD", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getCTDReps() {
        int reps = -1;
        try {
            reps = this.getAll("CTD").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertCTD(CTD structure, int rep) throws HL7Exception {
        super.insertRepetition("CTD", (Structure)structure, rep);
    }

    public CTD insertCTD(int rep) throws HL7Exception {
        return (CTD)super.insertRepetition("CTD", rep);
    }

    public CTD removeCTD(int rep) throws HL7Exception {
        return (CTD)super.removeRepetition("CTD", rep);
    }

    public LOC getLOC() {
        LOC ret = null;
        try {
            ret = (LOC)this.get("LOC");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public LOC getLOC(int rep) {
        LOC ret = null;
        try {
            ret = (LOC)this.get("LOC", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getLOCReps() {
        int reps = -1;
        try {
            reps = this.getAll("LOC").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertLOC(LOC structure, int rep) throws HL7Exception {
        super.insertRepetition("LOC", (Structure)structure, rep);
    }

    public LOC insertLOC(int rep) throws HL7Exception {
        return (LOC)super.insertRepetition("LOC", rep);
    }

    public LOC removeLOC(int rep) throws HL7Exception {
        return (LOC)super.removeRepetition("LOC", rep);
    }

    public ROL getROL() {
        ROL ret = null;
        try {
            ret = (ROL)this.get("ROL");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ROL getROL(int rep) {
        ROL ret = null;
        try {
            ret = (ROL)this.get("ROL", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getROLReps() {
        int reps = -1;
        try {
            reps = this.getAll("ROL").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertROL(ROL structure, int rep) throws HL7Exception {
        super.insertRepetition("ROL", (Structure)structure, rep);
    }

    public ROL insertROL(int rep) throws HL7Exception {
        return (ROL)super.insertRepetition("ROL", rep);
    }

    public ROL removeROL(int rep) throws HL7Exception {
        return (ROL)super.removeRepetition("ROL", rep);
    }

    public EHC_E20_PAT_INFO getPAT_INFO() {
        EHC_E20_PAT_INFO ret = null;
        try {
            ret = (EHC_E20_PAT_INFO)this.get("PAT_INFO");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public EHC_E20_PAT_INFO getPAT_INFO(int rep) {
        EHC_E20_PAT_INFO ret = null;
        try {
            ret = (EHC_E20_PAT_INFO)this.get("PAT_INFO", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getPAT_INFOReps() {
        int reps = -1;
        try {
            reps = this.getAll("PAT_INFO").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertPAT_INFO(EHC_E20_PAT_INFO structure, int rep) throws HL7Exception {
        super.insertRepetition("PAT_INFO", (Structure)structure, rep);
    }

    public EHC_E20_PAT_INFO insertPAT_INFO(int rep) throws HL7Exception {
        return (EHC_E20_PAT_INFO)super.insertRepetition("PAT_INFO", rep);
    }

    public EHC_E20_PAT_INFO removePAT_INFO(int rep) throws HL7Exception {
        return (EHC_E20_PAT_INFO)super.removeRepetition("PAT_INFO", rep);
    }

    public EHC_E20_PSL_ITEM_INFO getPSL_ITEM_INFO() {
        EHC_E20_PSL_ITEM_INFO ret = null;
        try {
            ret = (EHC_E20_PSL_ITEM_INFO)this.get("PSL_ITEM_INFO");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public EHC_E20_PSL_ITEM_INFO getPSL_ITEM_INFO(int rep) {
        EHC_E20_PSL_ITEM_INFO ret = null;
        try {
            ret = (EHC_E20_PSL_ITEM_INFO)this.get("PSL_ITEM_INFO", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getPSL_ITEM_INFOReps() {
        int reps = -1;
        try {
            reps = this.getAll("PSL_ITEM_INFO").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertPSL_ITEM_INFO(EHC_E20_PSL_ITEM_INFO structure, int rep) throws HL7Exception {
        super.insertRepetition("PSL_ITEM_INFO", (Structure)structure, rep);
    }

    public EHC_E20_PSL_ITEM_INFO insertPSL_ITEM_INFO(int rep) throws HL7Exception {
        return (EHC_E20_PSL_ITEM_INFO)super.insertRepetition("PSL_ITEM_INFO", rep);
    }

    public EHC_E20_PSL_ITEM_INFO removePSL_ITEM_INFO(int rep) throws HL7Exception {
        return (EHC_E20_PSL_ITEM_INFO)super.removeRepetition("PSL_ITEM_INFO", rep);
    }
}

