/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v26.datatype;

import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.log.HapiLogFactory;

/**
 * <p>Represents an HL7 CP (Composite Price) data type. 
 * This type consists of the following components:</p>
 * <ul>
 * <li>Price (MO)
 * <li>Price Type (ID)
 * <li>From Value (NM)
 * <li>To Value (NM)
 * <li>Range Units (CWE)
 * <li>Range Type (ID)
 * </ul>
 */
public class CP extends AbstractType implements Composite {

    private Type[] data;

    /** 
     * Creates a new CP type
     */
    public CP(Message message) {
        super(message);
        init();
    }

    private void init() {
        data = new Type[6];    
        data[0] = new MO(getMessage());
        data[1] = new ID(getMessage(), 205);
        data[2] = new NM(getMessage());
        data[3] = new NM(getMessage());
        data[4] = new CWE(getMessage());
        data[5] = new ID(getMessage(), 298);
    }


    /**
     * Returns an array containing the data elements.
     */
    public Type[] getComponents() { 
        return this.data; 
    }

    /**
     * Returns an individual data component.
     *
     * @param number The component number (0-indexed)
     * @throws DataTypeException if the given element number is out of range.
     */
    public Type getComponent(int number) throws DataTypeException { 

        try { 
            return this.data[number]; 
        } catch (ArrayIndexOutOfBoundsException e) { 
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + getClass().getName() + " has only " + this.data.length + " components)"); 
        } 
    } 


    /**
     * Returns Price (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public MO getPrice() {
       MO ret = null;
       try {
          ret = (MO)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Price (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public MO getCp1_Price() {
       MO ret = null;
       try {
          ret = (MO)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Price Type (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getPriceType() {
       ID ret = null;
       try {
          ret = (ID)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Price Type (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getCp2_PriceType() {
       ID ret = null;
       try {
          ret = (ID)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns From Value (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getFromValue() {
       NM ret = null;
       try {
          ret = (NM)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns From Value (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getCp3_FromValue() {
       NM ret = null;
       try {
          ret = (NM)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns To Value (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getToValue() {
       NM ret = null;
       try {
          ret = (NM)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns To Value (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getCp4_ToValue() {
       NM ret = null;
       try {
          ret = (NM)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Range Units (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CWE getRangeUnits() {
       CWE ret = null;
       try {
          ret = (CWE)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Range Units (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CWE getCp5_RangeUnits() {
       CWE ret = null;
       try {
          ret = (CWE)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Range Type (component #6).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getRangeType() {
       ID ret = null;
       try {
          ret = (ID)getComponent(5);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Range Type (component #6).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getCp6_RangeType() {
       ID ret = null;
       try {
          ret = (ID)getComponent(5);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }



}

