/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v26.datatype;

import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.log.HapiLogFactory;

/**
 * <p>Represents an HL7 CSU (Channel Sensitivity and Units) data type. 
 * This type consists of the following components:</p>
 * <ul>
 * <li>Channel Sensitivity (NM)
 * <li>Unit of Measure Identifier (ST)
 * <li>Unit of Measure Description (ST)
 * <li>Unit of Measure Coding System (ID)
 * <li>Alternate Unit of Measure Identifier (ST)
 * <li>Alternate Unit of Measure Description (ST)
 * <li>Alternate Unit of Measure Coding System (ID)
 * </ul>
 */
public class CSU extends AbstractType implements Composite {

    private Type[] data;

    /** 
     * Creates a new CSU type
     */
    public CSU(Message message) {
        super(message);
        init();
    }

    private void init() {
        data = new Type[7];    
        data[0] = new NM(getMessage());
        data[1] = new ST(getMessage());
        data[2] = new ST(getMessage());
        data[3] = new ID(getMessage(), 396);
        data[4] = new ST(getMessage());
        data[5] = new ST(getMessage());
        data[6] = new ID(getMessage(), 396);
    }


    /**
     * Returns an array containing the data elements.
     */
    public Type[] getComponents() { 
        return this.data; 
    }

    /**
     * Returns an individual data component.
     *
     * @param number The component number (0-indexed)
     * @throws DataTypeException if the given element number is out of range.
     */
    public Type getComponent(int number) throws DataTypeException { 

        try { 
            return this.data[number]; 
        } catch (ArrayIndexOutOfBoundsException e) { 
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + getClass().getName() + " has only " + this.data.length + " components)"); 
        } 
    } 


    /**
     * Returns Channel Sensitivity (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getChannelSensitivity() {
       NM ret = null;
       try {
          ret = (NM)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Channel Sensitivity (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getCsu1_ChannelSensitivity() {
       NM ret = null;
       try {
          ret = (NM)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Unit of Measure Identifier (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getUnitOfMeasureIdentifier() {
       ST ret = null;
       try {
          ret = (ST)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Unit of Measure Identifier (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getCsu2_UnitOfMeasureIdentifier() {
       ST ret = null;
       try {
          ret = (ST)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Unit of Measure Description (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getUnitOfMeasureDescription() {
       ST ret = null;
       try {
          ret = (ST)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Unit of Measure Description (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getCsu3_UnitOfMeasureDescription() {
       ST ret = null;
       try {
          ret = (ST)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Unit of Measure Coding System (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getUnitOfMeasureCodingSystem() {
       ID ret = null;
       try {
          ret = (ID)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Unit of Measure Coding System (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getCsu4_UnitOfMeasureCodingSystem() {
       ID ret = null;
       try {
          ret = (ID)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Alternate Unit of Measure Identifier (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getAlternateUnitOfMeasureIdentifier() {
       ST ret = null;
       try {
          ret = (ST)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Alternate Unit of Measure Identifier (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getCsu5_AlternateUnitOfMeasureIdentifier() {
       ST ret = null;
       try {
          ret = (ST)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Alternate Unit of Measure Description (component #6).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getAlternateUnitOfMeasureDescription() {
       ST ret = null;
       try {
          ret = (ST)getComponent(5);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Alternate Unit of Measure Description (component #6).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getCsu6_AlternateUnitOfMeasureDescription() {
       ST ret = null;
       try {
          ret = (ST)getComponent(5);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Alternate Unit of Measure Coding System (component #7).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getAlternateUnitOfMeasureCodingSystem() {
       ID ret = null;
       try {
          ret = (ID)getComponent(6);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Alternate Unit of Measure Coding System (component #7).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getCsu7_AlternateUnitOfMeasureCodingSystem() {
       ID ret = null;
       try {
          ret = (ID)getComponent(6);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }



}

