/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v26.datatype;

import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.log.HapiLogFactory;

/**
 * <p>Represents an HL7 ICD (Insurance Certification Definition) data type. 
 * This type consists of the following components:</p>
 * <ul>
 * <li>Certification Patient Type (IS)
 * <li>Certification Required (ID)
 * <li>Date/Time Certification Required (DTM)
 * </ul>
 */
public class ICD extends AbstractType implements Composite {

    private Type[] data;

    /** 
     * Creates a new ICD type
     */
    public ICD(Message message) {
        super(message);
        init();
    }

    private void init() {
        data = new Type[3];    
        data[0] = new IS(getMessage(), 150);
        data[1] = new ID(getMessage(), 136);
        data[2] = new DTM(getMessage());
    }


    /**
     * Returns an array containing the data elements.
     */
    public Type[] getComponents() { 
        return this.data; 
    }

    /**
     * Returns an individual data component.
     *
     * @param number The component number (0-indexed)
     * @throws DataTypeException if the given element number is out of range.
     */
    public Type getComponent(int number) throws DataTypeException { 

        try { 
            return this.data[number]; 
        } catch (ArrayIndexOutOfBoundsException e) { 
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + getClass().getName() + " has only " + this.data.length + " components)"); 
        } 
    } 


    /**
     * Returns Certification Patient Type (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getCertificationPatientType() {
       IS ret = null;
       try {
          ret = (IS)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Certification Patient Type (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getIcd1_CertificationPatientType() {
       IS ret = null;
       try {
          ret = (IS)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Certification Required (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getCertificationRequired() {
       ID ret = null;
       try {
          ret = (ID)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Certification Required (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getIcd2_CertificationRequired() {
       ID ret = null;
       try {
          ret = (ID)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Date/Time Certification Required (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public DTM getDateTimeCertificationRequired() {
       DTM ret = null;
       try {
          ret = (DTM)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Date/Time Certification Required (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public DTM getIcd3_DateTimeCertificationRequired() {
       DTM ret = null;
       try {
          ret = (DTM)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }



}

